/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.component;

import java.util.Iterator;
import net.minecraft.world.level.Level;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.network.SignalNetwork;

public interface ISignalStructureBase {
    default public boolean compatible(ISignalStructureBase other) {
        if (other.getComponentType() != SignalComponentType.TRANSMITTER && other.getComponentType() == this.getComponentType()) {
            return false;
        }
        return this.getBandwidth() == other.getBandwidth();
    }

    public Level getStructureLevel();

    public int getBandwidth();

    public SignalNetwork getNetwork();

    public void setNetwork(SignalNetwork var1);

    public Iterator<ISignalStructureBase> connections();

    public boolean canConnect(Facing var1);

    public boolean connect(Facing var1, ISignalStructureBase var2, LittleGrid var3, int var4, boolean var5);

    public void disconnect(Facing var1, ISignalStructureBase var2);

    public void unload(Facing var1, ISignalStructureBase var2);

    default public boolean hasNetwork() {
        return this.getNetwork() != null;
    }

    default public SignalNetwork findNetwork() {
        if (this.hasNetwork()) {
            if (this.getNetwork().requiresResearch()) {
                this.getNetwork().deleteNetwork();
            } else {
                return this.getNetwork();
            }
        }
        Iterator<ISignalStructureBase> connections = this.connections();
        while (connections.hasNext()) {
            ISignalStructureBase connection = connections.next();
            if (!connection.hasNetwork()) continue;
            connection.getNetwork().add(this);
            return this.getNetwork();
        }
        SignalNetwork network = new SignalNetwork(this.getBandwidth());
        network.add(this);
        return this.getNetwork();
    }

    public SignalComponentType getComponentType();

    public int getColor();
}

