/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.input;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;
import team.creative.littletiles.common.structure.signal.logic.SignalPatternParser;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

public class SignalInputVariable
extends SignalInputCondition {
    public final SignalTarget target;

    private static int[] parseInputExact(SignalPatternParser parser) throws ParseException {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (parser.hasNext()) {
            char next = parser.lookForNext(true);
            if (next == '}') {
                parser.next(true);
                break;
            }
            if (Character.isDigit(next) || next == '*') {
                if (next == '*') {
                    indexes.add(2);
                    next = parser.next(true);
                    if (next != '}') continue;
                    break;
                }
                indexes.add(Integer.parseInt("" + next));
                next = parser.next(true);
                if (next != '}') continue;
                break;
            }
            throw parser.invalidChar(next);
        }
        if (indexes.isEmpty()) {
            return null;
        }
        int[] result = new int[indexes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)indexes.get(i);
        }
        return result;
    }

    public static SignalInputVariable parseInput(SignalPatternParser parser, boolean insideVariable) throws ParseException {
        return SignalInputVariable.parseInput(parser, insideVariable, false);
    }

    public static SignalInputVariable parseInput(SignalPatternParser parser, boolean insideVariable, boolean forceBitwise) throws ParseException {
        SignalTarget target = SignalTarget.parseTarget(parser, false, insideVariable);
        if (!insideVariable && parser.lookForNext(false) == '{') {
            parser.next(false);
            char next = parser.lookForNext(true);
            if (Character.isDigit(next) || next == '*') {
                int[] indexes = SignalInputVariable.parseInputExact(parser);
                if (indexes != null) {
                    return new SignalInputVariablePattern(target, indexes, SignalInputVariable.parsePosition(parser));
                }
                return forceBitwise ? new SignalInputVariableBitwise(target, SignalInputVariable.parsePosition(parser)) : new SignalInputVariable(target, SignalInputVariable.parsePosition(parser));
            }
            SignalLogicOperator operator = SignalLogicOperator.getOperator(next);
            if (operator != null) {
                parser.next(true);
                if (parser.next(true) == '}') {
                    return new SignalInputVariableOperator(target, operator, SignalInputVariable.parsePosition(parser));
                }
                throw parser.invalidChar(parser.current());
            }
            return new SignalInputVariableEquation(target, SignalInputCondition.parseExpression(parser, new char[]{'}'}, false, true), SignalInputVariable.parsePosition(parser));
        }
        return forceBitwise ? new SignalInputVariableBitwise(target, SignalInputVariable.parsePosition(parser)) : new SignalInputVariable(target, SignalInputVariable.parsePosition(parser));
    }

    public SignalInputVariable(SignalTarget target, SignalInputCondition.SignalPosition position) {
        super(position);
        this.target = target;
    }

    @Override
    public SignalState test(LittleStructure structure, boolean forceBitwise) {
        SignalState state = this.target.getState(structure);
        if (forceBitwise) {
            return state;
        }
        return SignalState.of(state.any());
    }

    @Override
    public boolean testIndex(SignalState state) {
        if (this.target.isIndexVariable()) {
            return state.is(this.target.child);
        }
        return false;
    }

    @Override
    public String write() {
        return this.target.write() + this.writePosition();
    }

    @Override
    protected double internalDelay() {
        return LittleTiles.CONFIG.signal.variableDuration;
    }

    @Override
    public SignalTarget target() {
        return this.target;
    }

    @Override
    public Iterator<SignalInputCondition> nested() {
        return Collections.emptyIterator();
    }

    public static class SignalInputVariablePattern
    extends SignalInputVariable {
        public final int[] indexes;

        public SignalInputVariablePattern(SignalTarget target, int[] indexes, SignalInputCondition.SignalPosition position) {
            super(target, position);
            this.indexes = indexes;
        }

        @Override
        public SignalState test(LittleStructure structure, boolean forceBitwise) {
            return SignalState.of(this.target.getState(structure).is(this.indexes));
        }

        @Override
        public String write() {
            String result = this.target.write() + "{";
            for (int i = 0; i < this.indexes.length; ++i) {
                int index = this.indexes[i];
                result = result + String.valueOf(index >= 2 ? "*" : Integer.valueOf(index));
            }
            return result + "}" + this.writePosition();
        }
    }

    public static class SignalInputVariableBitwise
    extends SignalInputVariable {
        public SignalInputVariableBitwise(SignalTarget target, SignalInputCondition.SignalPosition position) {
            super(target, position);
        }

        @Override
        public SignalState test(LittleStructure structure, boolean forceBitwise) {
            return this.target.getState(structure);
        }
    }

    public static class SignalInputVariableOperator
    extends SignalInputVariable {
        public final SignalLogicOperator operator;

        public SignalInputVariableOperator(SignalTarget target, SignalLogicOperator operator, SignalInputCondition.SignalPosition position) {
            super(target, position);
            this.operator = operator;
        }

        @Override
        public SignalState test(LittleStructure structure, boolean forceBitwise) {
            SignalState state = this.target.getState(structure);
            boolean result = false;
            int bandwidth = this.target.bandwidth(structure);
            for (int i = 0; i < bandwidth; ++i) {
                result = i == 0 ? state.is(i) : this.operator.perform(result, state.is(i));
            }
            return SignalState.of(result);
        }

        @Override
        public String write() {
            return this.target.write() + "{" + String.valueOf(this.operator == SignalLogicOperator.AND ? "&" : Character.valueOf(this.operator.operator)) + "}" + this.writePosition();
        }
    }

    public static class SignalInputVariableEquation
    extends SignalInputVariable {
        public final SignalInputCondition condition;

        public SignalInputVariableEquation(SignalTarget target, SignalInputCondition condition, SignalInputCondition.SignalPosition position) {
            super(target, position);
            this.condition = condition;
        }

        @Override
        public SignalState test(LittleStructure structure, boolean forceBitwise) {
            return SignalState.of(this.condition.testIndex(this.target.getState(structure)));
        }

        @Override
        public String write() {
            return this.target.write() + "{" + this.condition.write() + "}" + this.writePosition();
        }

        @Override
        protected double internalDelay() {
            return super.calculateDelay() + this.condition.calculateDelay();
        }

        @Override
        public Iterator<SignalInputCondition> nested() {
            return new SingleIterator((Object)this.condition);
        }
    }
}

