/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.logic;

import java.util.Iterator;
import javax.annotation.Nullable;
import team.creative.creativecore.common.util.type.itr.ArrayIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicEntry;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

public enum SignalLogicComparator implements SignalLogicEntry
{
    GREATER(">"){

        @Override
        public SignalLogicEntry lower() {
            return SignalLogicOperator.DIV;
        }

        @Override
        public double delayModifier() {
            return LittleTiles.CONFIG.signal.greater;
        }

        @Override
        public boolean compare(boolean first, boolean second) {
            return first && !second;
        }

        @Override
        public boolean compare(int first, int second) {
            return first > second;
        }

        @Override
        public boolean compare(long first, long second) {
            return first > second;
        }
    }
    ,
    GREATER_EQUALS(">="){

        @Override
        public SignalLogicEntry lower() {
            return GREATER;
        }

        @Override
        public double delayModifier() {
            return LittleTiles.CONFIG.signal.greaterEquals;
        }

        @Override
        public boolean compare(boolean first, boolean second) {
            return first || !second;
        }

        @Override
        public boolean compare(int first, int second) {
            return first >= second;
        }

        @Override
        public boolean compare(long first, long second) {
            return first >= second;
        }
    }
    ,
    SMALLER("<"){

        @Override
        public SignalLogicEntry lower() {
            return GREATER_EQUALS;
        }

        @Override
        public double delayModifier() {
            return LittleTiles.CONFIG.signal.smaller;
        }

        @Override
        public boolean compare(boolean first, boolean second) {
            return !first && second;
        }

        @Override
        public boolean compare(int first, int second) {
            return first < second;
        }

        @Override
        public boolean compare(long first, long second) {
            return first < second;
        }
    }
    ,
    SMALLER_EQUALS("<="){

        @Override
        public SignalLogicEntry lower() {
            return SMALLER;
        }

        @Override
        public double delayModifier() {
            return LittleTiles.CONFIG.signal.smallerEquals;
        }

        @Override
        public boolean compare(boolean first, boolean second) {
            return !first || second;
        }

        @Override
        public boolean compare(int first, int second) {
            return first <= second;
        }

        @Override
        public boolean compare(long first, long second) {
            return first <= second;
        }
    };

    public final String operator;

    private SignalLogicComparator(String operator) {
        this.operator = operator;
    }

    @Override
    public String operator() {
        return this.operator;
    }

    @Override
    public int maxArgmumentCount() {
        return 2;
    }

    public abstract double delayModifier();

    public abstract boolean compare(boolean var1, boolean var2);

    public abstract boolean compare(int var1, int var2);

    public abstract boolean compare(long var1, long var3);

    @Override
    public SignalInputCondition create(SignalInputCondition[] conditions, @Nullable SignalInputCondition.SignalPosition position) {
        return new SignalInputConditionComparator(conditions, this, position);
    }

    public static class SignalInputConditionComparator
    extends SignalInputCondition.SignalInputConditionOperator {
        public final SignalLogicComparator comparator;
        public final SignalInputCondition[] conditions;

        public SignalInputConditionComparator(SignalInputCondition[] conditions, SignalLogicComparator comparator, @Nullable SignalInputCondition.SignalPosition position) {
            super(position);
            this.conditions = conditions;
            this.comparator = comparator;
        }

        @Override
        public SignalState test(LittleStructure structure) {
            SignalState[] state = new SignalState[this.conditions.length];
            SignalState.SignalStateSize size = SignalState.SignalStateSize.SINGLE;
            for (int i = 0; i < this.conditions.length; ++i) {
                state[i] = this.conditions[i].test(structure, false);
                size = size.max(state[i].size());
            }
            return SignalState.of(switch (size) {
                default -> throw new MatchException(null, null);
                case SignalState.SignalStateSize.SINGLE -> this.comparator.compare(state[0].any(), state[1].any());
                case SignalState.SignalStateSize.INT -> this.comparator.compare(state[0].number(), state[1].number());
                case SignalState.SignalStateSize.LONG -> this.comparator.compare(state[0].longNumber(), state[1].longNumber());
            });
        }

        @Override
        public boolean testIndex(SignalState state) {
            boolean result = false;
            for (int i = 0; i < this.conditions.length; ++i) {
                result = i == 0 ? this.conditions[i].testIndex(state) : this.comparator.compare(result, this.conditions[i].testIndex(state));
            }
            return result;
        }

        @Override
        public String write() {
            Object result = "(";
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i > 0) {
                    result = (String)result + this.comparator.operator;
                }
                result = (String)result + this.conditions[i].write();
            }
            return (String)result + this.writePosition() + ")";
        }

        @Override
        protected double internalDelay() {
            double delay = (double)this.conditions.length * this.comparator.delayModifier();
            for (SignalInputCondition condition : this.conditions) {
                delay += condition.calculateDelay();
            }
            return delay;
        }

        @Override
        public Iterator<SignalInputCondition> nested() {
            return new ArrayIterator((Object[])this.conditions);
        }

        @Override
        public SignalTarget target() {
            return null;
        }
    }
}

