/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.logic;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicComparator;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;
import team.creative.littletiles.common.structure.signal.logic.SignalPatternParser;

public interface SignalLogicEntry {
    public static final SignalLogicEntry HIGHEST_GENERAL = SignalLogicOperator.XOR;
    public static final SignalLogicEntry HIGHEST = SignalLogicComparator.SMALLER_EQUALS;
    public static final List<SignalLogicEntry> ALL = SignalLogicEntry.calculateAll();

    private static List<SignalLogicEntry> calculateAll() {
        ArrayList<SignalLogicEntry> entries = new ArrayList<SignalLogicEntry>();
        for (SignalLogicEntry entry = HIGHEST; entry != null; entry = entry.lower()) {
            entries.add(entry);
        }
        return Collections.unmodifiableList(entries);
    }

    public static SignalLogicEntry getHighest(boolean includeBitwise) {
        if (includeBitwise) {
            return HIGHEST;
        }
        return HIGHEST_GENERAL;
    }

    public SignalLogicEntry lower();

    public String operator();

    public int maxArgmumentCount();

    default public boolean is(SignalPatternParser parser) {
        String operator = this.operator();
        if (operator.length() == 1) {
            return parser.lookForNext(true) == operator.charAt(0);
        }
        return parser.lookForNext(operator.length(), true).equals(operator);
    }

    default public void consume(SignalPatternParser parser) {
        parser.skip(this.operator().length(), true);
    }

    public SignalInputCondition create(SignalInputCondition[] var1, @Nullable SignalInputCondition.SignalPosition var2);

    default public boolean goOn(SignalPatternParser parser) throws ParseException {
        if (parser.hasNext()) {
            if (this.lower() == null) {
                char next = parser.lookForNext(true);
                return next == '(' || next == '!' || next <= 'z' && next >= 'a';
            }
            if (this.is(parser)) {
                this.consume(parser);
                return true;
            }
        }
        return false;
    }
}

