/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.logic;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.gui.signal.mode.GuiSignalModeConfiguration;
import team.creative.littletiles.common.gui.signal.mode.GuiSignalModeConfigurationEqual;
import team.creative.littletiles.common.gui.signal.mode.GuiSignalModeConfigurationExtender;
import team.creative.littletiles.common.gui.signal.mode.GuiSignalModeConfigurationPulse;
import team.creative.littletiles.common.gui.signal.mode.GuiSignalModeConfigurationStabilizer;
import team.creative.littletiles.common.gui.signal.mode.GuiSignalModeConfigurationThreshold;
import team.creative.littletiles.common.gui.signal.mode.GuiSignalModeConfigurationToggle;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.output.mode.SignalOutputHandlerExtender;
import team.creative.littletiles.common.structure.signal.output.mode.SignalOutputHandlerPulse;
import team.creative.littletiles.common.structure.signal.output.mode.SignalOutputHandlerStoreOne;
import team.creative.littletiles.common.structure.signal.output.mode.SignalOutputHandlerToggle;
import team.creative.littletiles.common.structure.signal.schedule.SignalScheduleTicket;

public enum SignalMode {
    EQUAL("signal.mode.equal"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalOutputHandler handler = new SignalOutputHandler(this, component, delay, nbt){

                @Override
                public SignalMode getMode() {
                    return EQUAL;
                }

                @Override
                public void queue(SignalState state) {
                    LittleTiles.TICKERS.schedule(this, state, this.delay);
                }

                @Override
                public void write(boolean preview, CompoundTag nbt) {
                    if (preview) {
                        return;
                    }
                    List<SignalScheduleTicket> tickets = LittleTiles.TICKERS.findTickets(this.component, this);
                    ListTag list = new ListTag();
                    for (int i = 0; i < tickets.size(); ++i) {
                        SignalScheduleTicket ticket = tickets.get(i);
                        list.add((Object)new IntArrayTag(new int[]{ticket.getDelay(), ticket.getState().number()}));
                    }
                    if (!list.isEmpty()) {
                        nbt.put("tickets", (Tag)list);
                    }
                }
            };
            if (hasWorld) {
                ListTag list = nbt.getList("tickets", 11);
                for (int i = 0; i < list.size(); ++i) {
                    int[] array = list.getIntArray(i);
                    if (array.length != 2) continue;
                    try {
                        SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                        LittleTiles.TICKERS.schedule(handler, state, array[0]);
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
            return handler;
        }

        @Override
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationEqual(handler);
        }

        @Override
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationEqual(delay);
        }
    }
    ,
    TOGGLE("signal.mode.toggle"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalState result;
            SignalState before;
            int bandwidth = nbt.getInt("bandwidth");
            if (bandwidth > 0) {
                before = SignalState.create(bandwidth);
                result = SignalState.create(bandwidth);
                before = before.load(nbt.get("before"));
                result = result.load(nbt.get("result"));
            } else {
                before = null;
                result = null;
            }
            SignalOutputHandlerToggle handler = new SignalOutputHandlerToggle(component, delay, nbt, before, result);
            if (hasWorld) {
                ListTag list = nbt.getList("tickets", 11);
                for (int i = 0; i < list.size(); ++i) {
                    int[] array = list.getIntArray(i);
                    if (array.length != 2) continue;
                    try {
                        SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                        LittleTiles.TICKERS.schedule(handler, state, array[0]);
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
            return handler;
        }

        @Override
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationToggle(handler);
        }

        @Override
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationToggle(delay);
        }
    }
    ,
    PULSE("signal.mode.pulse"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalOutputHandlerPulse condition = new SignalOutputHandlerPulse(component, delay, nbt);
            if (hasWorld) {
                if (nbt.contains("start")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.TRUE, nbt.getInt("start"));
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                } else if (nbt.contains("end")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                }
            }
            return condition;
        }

        @Override
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationPulse(handler);
        }

        @Override
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
            parent.add((GuiControl)new GuiLabel("length:").setTitle((Component)Component.translatable((String)"gui.signal.length").append(":")));
            parent.add((GuiControl)new GuiTextfield("length", "" + (configuration instanceof GuiSignalModeConfigurationPulse ? ((GuiSignalModeConfigurationPulse)configuration).length : 10)).setNumbersOnly());
        }

        @Override
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            GuiTextfield length = (GuiTextfield)parent.get("length");
            return new GuiSignalModeConfigurationPulse(delay, Math.max(1, length.parseInteger()));
        }
    }
    ,
    THRESHOLD("signal.mode.threshold"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            int[] array;
            SignalOutputHandlerStoreOne handler = new SignalOutputHandlerStoreOne(this, component, delay, nbt){

                @Override
                public void queue(SignalState state) {
                    if (this.ticket != null) {
                        this.ticket.overwriteState(state);
                    } else {
                        this.ticket = LittleTiles.TICKERS.schedule(this, state, this.delay);
                    }
                }

                @Override
                public void performStateChange(SignalState state) {
                    this.ticket = null;
                    super.performStateChange(state);
                }

                @Override
                public SignalMode getMode() {
                    return THRESHOLD;
                }

                @Override
                public void write(boolean preview, CompoundTag nbt) {
                    if (!preview && this.ticket != null) {
                        nbt.putIntArray("ticket", new int[]{this.ticket.getDelay(), this.ticket.getState().number()});
                    }
                }
            };
            if (hasWorld && nbt.contains("ticket") && (array = nbt.getIntArray("ticket")).length == 2) {
                try {
                    SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                    handler.ticket = LittleTiles.TICKERS.schedule(handler, state, array[0]);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return handler;
        }

        @Override
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationThreshold(handler);
        }

        @Override
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationThreshold(delay);
        }
    }
    ,
    STABILIZER("signal.mode.stabilizer"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            int[] array;
            SignalOutputHandlerStoreOne handler = new SignalOutputHandlerStoreOne(this, component, delay, nbt){

                @Override
                public void queue(SignalState state) {
                    if (this.ticket != null) {
                        this.ticket.markObsolete();
                    }
                    this.ticket = LittleTiles.TICKERS.schedule(this, state, this.delay);
                }

                @Override
                public void performStateChange(SignalState state) {
                    this.ticket = null;
                    super.performStateChange(state);
                }

                @Override
                public SignalMode getMode() {
                    return STABILIZER;
                }

                @Override
                public void write(boolean preview, CompoundTag nbt) {
                    if (preview) {
                        return;
                    }
                    if (this.ticket != null) {
                        nbt.putIntArray("ticket", new int[]{this.ticket.getDelay(), this.ticket.getState().number()});
                    }
                }
            };
            if (hasWorld && nbt.contains("ticket") && (array = nbt.getIntArray("ticket")).length == 2) {
                try {
                    SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                    handler.ticket = LittleTiles.TICKERS.schedule(handler, state, array[0]);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return handler;
        }

        @Override
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationStabilizer(handler);
        }

        @Override
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationStabilizer(delay);
        }
    }
    ,
    EXTENDER("signal.mode.extender"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalOutputHandlerExtender condition = new SignalOutputHandlerExtender(component, delay, nbt);
            if (hasWorld) {
                if (nbt.contains("start")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.TRUE, nbt.getInt("start"));
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                } else if (nbt.contains("end")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                }
            }
            return condition;
        }

        @Override
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationExtender(handler);
        }

        @Override
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
            parent.add((GuiControl)new GuiLabel("length:").setTitle((Component)Component.translatable((String)"gui.signal.length").append(":")));
            parent.add((GuiControl)new GuiTextfield("length", "" + (configuration instanceof GuiSignalModeConfigurationExtender ? ((GuiSignalModeConfigurationExtender)configuration).length : 10)).setNumbersOnly());
        }

        @Override
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            GuiTextfield length = (GuiTextfield)parent.get("length");
            return new GuiSignalModeConfigurationExtender(delay, Math.max(1, length.parseInteger()));
        }
    };

    public final String translateKey;

    private SignalMode(String translateKey) {
        this.translateKey = translateKey;
    }

    public abstract SignalOutputHandler create(ISignalComponent var1, int var2, CompoundTag var3, boolean var4);

    public abstract GuiSignalModeConfiguration createConfiguration(SignalOutputHandler var1);

    public abstract void createControls(GuiParent var1, GuiSignalModeConfiguration var2);

    public abstract GuiSignalModeConfiguration parseControls(GuiParent var1, int var2);

    public static GuiSignalModeConfiguration getConfigDefault() {
        return EQUAL.createConfiguration(null);
    }

    public static SignalMode get(String test) {
        try {
            return SignalMode.valueOf(test);
        }
        catch (IllegalArgumentException e) {
            return EQUAL;
        }
    }

    public static SignalMode get(String test, SignalMode defaultMode) {
        try {
            return SignalMode.valueOf(test);
        }
        catch (IllegalArgumentException e) {
            return defaultMode;
        }
    }
}

