/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.logic;

import java.text.ParseException;

public class SignalPatternParser {
    public final String pattern;
    private int pos = -1;

    public SignalPatternParser(String pattern) {
        this.pattern = pattern;
    }

    public boolean hasNext() {
        return this.pos < this.pattern.length() - 1;
    }

    public char next(boolean skipSpace) throws ParseException {
        try {
            if (skipSpace) {
                char next = ' ';
                while (Character.isWhitespace(next)) {
                    next = this.pattern.charAt(++this.pos);
                }
                return next;
            }
            return this.pattern.charAt(++this.pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.exception("Invalid end of pattern");
        }
    }

    public String lookForNext(int length, boolean skipSpace) {
        if (skipSpace) {
            StringBuilder result = new StringBuilder();
            int index = this.pos + 1;
            int counter = 0;
            while (counter < length && this.hasNext()) {
                char next = this.pattern.charAt(index);
                ++index;
                if (Character.isWhitespace(next)) continue;
                result.append(next);
                ++counter;
            }
            return result.toString();
        }
        if (this.hasNext()) {
            return this.pattern.substring(this.pos + 1, Math.min(this.pattern.length(), this.pos + 1 + length));
        }
        return "";
    }

    public char lookForNext(boolean skipSpace) {
        if (skipSpace) {
            char next = ' ';
            int index = this.pos;
            while (this.hasNext() && Character.isWhitespace(next)) {
                next = this.pattern.charAt(++index);
            }
            return next;
        }
        if (this.hasNext()) {
            return this.pattern.charAt(this.pos + 1);
        }
        return '\n';
    }

    public int parseNumber() throws ParseException {
        Object digit = "";
        boolean first = true;
        while (Character.isDigit(this.lookForNext(first))) {
            digit = (String)digit + this.next(first);
            first = false;
        }
        try {
            return Integer.parseInt((String)digit);
        }
        catch (NumberFormatException e) {
            throw this.exception("Invalid number " + (String)digit);
        }
    }

    public void skip(int amount, boolean skipSpace) {
        if (skipSpace) {
            int counter = 0;
            while (counter < amount && this.hasNext()) {
                char next;
                if (Character.isWhitespace(next = this.pattern.charAt(++this.pos))) continue;
                ++counter;
            }
        } else {
            this.pos += amount;
        }
    }

    public int position() {
        return this.pos;
    }

    public ParseException exception(String text) {
        return new ParseException(text + " '" + this.pattern + "'", this.pos);
    }

    public ParseException invalidChar(char character) {
        return this.exception("Invalid char " + character);
    }

    public char current() {
        return this.pattern.charAt(this.pos);
    }
}

