/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.network;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.level.Level;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureBase;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.network.ISignalStructureTransmitter;
import team.creative.littletiles.common.structure.signal.schedule.ISignalSchedulable;

public class SignalNetwork
implements ISignalSchedulable {
    public final int bandwidth;
    private SignalState state;
    private boolean changed = false;
    private boolean forceUpdate = false;
    private boolean containsUnloadedComponents = false;
    private List<ISignalStructureTransmitter> transmitters = new ArrayList<ISignalStructureTransmitter>();
    private List<ISignalStructureComponent> inputs = new ArrayList<ISignalStructureComponent>();
    private List<ISignalStructureComponent> outputs = new ArrayList<ISignalStructureComponent>();

    public SignalNetwork(int bandwidth) {
        this.bandwidth = bandwidth;
        this.state = SignalState.create(bandwidth);
    }

    public List<ISignalStructureComponent> getOutputs() {
        return this.outputs;
    }

    public boolean requiresResearch() {
        return this.containsUnloadedComponents;
    }

    @Override
    public void notifyChange() {
        if (!this.forceUpdate) {
            SignalState oldState = SignalState.copy(this.state);
            this.state = this.state.reset();
            for (int i = 0; i < this.outputs.size(); ++i) {
                try {
                    this.state = this.state.or(this.outputs.get(i).getState());
                    continue;
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            if (this.state.equals(this.bandwidth, oldState) && !this.inputs.isEmpty()) {
                return;
            }
        } else {
            for (int i = 0; i < this.outputs.size(); ++i) {
                try {
                    this.state = this.state.or(this.outputs.get(i).getState());
                    continue;
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
        }
        this.forceUpdate = false;
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputs.get(i).updateState(this.state);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void markChanged() {
        this.changed = true;
    }

    @Override
    public void markUnchanged() {
        this.changed = false;
    }

    public void update() {
        this.schedule();
    }

    @Override
    public Level getComponentLevel() {
        if (!this.inputs.isEmpty()) {
            return this.inputs.get(0).getStructureLevel();
        }
        if (!this.outputs.isEmpty()) {
            return this.outputs.get(0).getStructureLevel();
        }
        if (!this.transmitters.isEmpty()) {
            return this.transmitters.get(0).getStructureLevel();
        }
        return null;
    }

    public void merge(SignalNetwork network) {
        int i;
        int sizeBefore = this.outputs.size();
        for (i = 0; i < network.outputs.size(); ++i) {
            ISignalStructureComponent output = network.outputs.get(i);
            if (SignalNetwork.containsUntil(this.outputs, output, sizeBefore)) continue;
            output.setNetwork(this);
            this.outputs.add(output);
        }
        sizeBefore = this.inputs.size();
        if (!network.inputs.isEmpty()) {
            for (i = 0; i < network.inputs.size(); ++i) {
                ISignalStructureComponent input = network.inputs.get(i);
                if (SignalNetwork.containsUntil(this.inputs, input, sizeBefore)) continue;
                input.setNetwork(this);
                this.inputs.add(input);
            }
        }
        sizeBefore = this.transmitters.size();
        if (!network.transmitters.isEmpty()) {
            for (i = 0; i < network.transmitters.size(); ++i) {
                ISignalStructureTransmitter transmitter = network.transmitters.get(i);
                if (SignalNetwork.containsUntil(this.transmitters, transmitter, sizeBefore)) continue;
                transmitter.setNetwork(this);
                this.transmitters.add(transmitter);
            }
        }
        this.forceUpdate = true;
        this.schedule();
        network.inputs.clear();
        network.outputs.clear();
        network.transmitters.clear();
    }

    public static <T> boolean containsUntil(List<T> list, T object, int index) {
        for (int i = 0; i < index; ++i) {
            if (list.get(i) != object) continue;
            return true;
        }
        return false;
    }

    public void add(ISignalStructureBase base) {
        if (base.getComponentType() == SignalComponentType.INVALID) {
            this.containsUnloadedComponents = true;
        }
        if (base.getNetwork() == this) {
            return;
        }
        if (base.hasNetwork()) {
            this.merge(base.getNetwork());
            return;
        }
        base.setNetwork(this);
        Iterator<ISignalStructureBase> connections = base.connections();
        while (connections.hasNext()) {
            this.add(connections.next());
        }
        switch (base.getComponentType()) {
            case INPUT: {
                this.inputs.add((ISignalStructureComponent)base);
                this.forceUpdate = true;
                this.schedule();
                break;
            }
            case OUTPUT: {
                this.outputs.add((ISignalStructureComponent)base);
                this.forceUpdate = true;
                this.schedule();
                break;
            }
            case TRANSMITTER: {
                this.transmitters.add((ISignalStructureTransmitter)base);
                break;
            }
            case IOSPECIAL: {
                this.inputs.add((ISignalStructureComponent)base);
                this.outputs.add((ISignalStructureComponent)base);
                this.forceUpdate = true;
                this.schedule();
            }
        }
    }

    public void deleteNetwork() {
        int i;
        for (i = 0; i < this.inputs.size(); ++i) {
            this.inputs.get(i).setNetwork(null);
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            this.outputs.get(i).setNetwork(null);
        }
        for (i = 0; i < this.transmitters.size(); ++i) {
            this.transmitters.get(i).setNetwork(null);
        }
        this.inputs.clear();
        this.outputs.clear();
        this.transmitters.clear();
    }

    public void unload(ISignalStructureBase base) {
        this.deleteNetwork();
    }

    public boolean remove(ISignalStructureBase base) {
        base.setNetwork(null);
        switch (base.getComponentType()) {
            case INPUT: {
                this.inputs.remove(base);
                this.schedule();
                return false;
            }
            case OUTPUT: {
                this.outputs.remove(base);
                this.schedule();
                return false;
            }
            case TRANSMITTER: {
                this.deleteNetwork();
                return true;
            }
            case IOSPECIAL: {
                this.inputs.remove(base);
                this.outputs.remove(base);
                this.schedule();
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return Integer.toHexString(this.hashCode());
    }

    @Override
    public boolean isStillAvailable() {
        return true;
    }
}

