/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.output;

import java.text.ParseException;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.packet.update.OutputUpdate;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.InternalSignal;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.output.mode.SignalOutputHandlerToggle;

public class InternalSignalOutput
extends InternalSignal<LittleStructureType.InternalComponentOutput> {
    public final SignalMode defaultMode;
    public final boolean syncToClient;
    public SignalInputCondition condition;
    public SignalOutputHandler handler;
    public SignalInputCondition.SignalPosition outputPosition;

    public InternalSignalOutput(LittleStructure parent, LittleStructureType.InternalComponentOutput component) {
        super(parent, component);
        this.defaultMode = component.defaultMode;
        this.syncToClient = component.syncToClient;
    }

    @Override
    public void changed() {
        this.parent.performInternalOutputChange(this);
        this.parent.schedule();
        if (this.syncToClient) {
            LittleTiles.NETWORK.sendToClient((CreativePacket)new OutputUpdate(this.parent.getStructureLocation(), ((LittleStructureType.InternalComponentOutput)this.component).index, this.getState()), this.getStructureLevel(), this.parent.getStructurePos());
        }
    }

    @Override
    public SignalComponentType getComponentType() {
        return SignalComponentType.OUTPUT;
    }

    public void loadConfiguration(CompoundTag nbt) {
        try {
            this.condition = nbt.contains("con") ? SignalInputCondition.parseInput(nbt.getString("con")) : null;
        }
        catch (ParseException e) {
            this.condition = null;
        }
        SignalMode mode = this.defaultMode;
        if (nbt.contains("mode")) {
            mode = SignalMode.valueOf(nbt.getString("mode"));
        }
        int delay = nbt.getInt("delay");
        if (this.condition != null) {
            delay = Math.max((int)Math.ceil(this.condition.calculateDelay()), nbt.getInt("delay"));
        }
        this.handler = SignalOutputHandler.create(this, mode, delay, nbt, this.parent);
        this.outputPosition = nbt.contains("x") ? new SignalInputCondition.SignalPosition(nbt.getInt("x"), nbt.getInt("y")) : null;
    }

    @Override
    public void load(CompoundTag nbt) {
        this.overwrite(this.getState().load(nbt.get("state")));
        this.loadConfiguration(nbt);
    }

    public CompoundTag saveConfiguration(boolean preview, CompoundTag nbt) {
        if (this.condition != null) {
            nbt.putString("con", this.condition.write());
        }
        nbt.putString("mode", this.handler == null ? this.defaultMode.name() : this.handler.getMode().name());
        if (this.handler != null) {
            if (this.handler.delay > 0) {
                nbt.putInt("delay", this.handler.delay);
            } else {
                nbt.remove("delay");
            }
            this.handler.write(preview, nbt);
        }
        if (this.outputPosition != null) {
            nbt.putInt("x", this.outputPosition.x());
            nbt.putInt("y", this.outputPosition.y());
        }
        return nbt;
    }

    @Override
    public CompoundTag save(boolean preview, CompoundTag nbt) {
        nbt.put("state", this.getState().save());
        this.saveConfiguration(preview, nbt);
        return nbt;
    }

    public void toggle() {
        if (this.handler instanceof SignalOutputHandlerToggle) {
            ((SignalOutputHandlerToggle)this.handler).triggerToggle();
        }
    }

    public void update() {
        if (this.condition == null) {
            return;
        }
        int bandwidth = this.getBandwidth();
        if (bandwidth > 0) {
            SignalState outputState = SignalState.create(bandwidth);
            SignalState result = this.condition.test(this.getStructure(), false);
            outputState = result.size() == SignalState.SignalStateSize.SINGLE ? outputState.fill(result.any()) : outputState.fill(result);
            this.handler.schedule(outputState);
        }
    }
}

