/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.output.mode;

import net.minecraft.nbt.CompoundTag;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.schedule.SignalScheduleTicket;

public class SignalOutputHandlerPulse
extends SignalOutputHandler {
    public final int pulseLength;
    public boolean stateBefore;
    public SignalScheduleTicket pulseStart;
    public SignalScheduleTicket pulseEnd;

    public SignalOutputHandlerPulse(ISignalComponent component, int delay, CompoundTag nbt) {
        super(component, delay, nbt);
        this.pulseLength = nbt.contains("length") ? nbt.getInt("length") : 10;
        this.stateBefore = nbt.getBoolean("before");
    }

    @Override
    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
        return super.getBandwidth();
    }

    @Override
    public SignalMode getMode() {
        return SignalMode.PULSE;
    }

    @Override
    public void performStateChange(SignalState state) {
        super.performStateChange(state);
        if (state.any()) {
            this.pulseStart = null;
        } else {
            this.pulseStart = null;
            this.pulseEnd = null;
        }
    }

    @Override
    public void queue(SignalState state) {
        boolean current = state.any();
        if (this.pulseEnd == null && !this.stateBefore && current) {
            try {
                int bandwidth = this.getBandwidth();
                SignalState startState = SignalState.create(bandwidth).fill(true);
                SignalState endState = SignalState.create(bandwidth);
                this.pulseStart = LittleTiles.TICKERS.schedule(this, startState, this.delay);
                this.pulseEnd = LittleTiles.TICKERS.schedule(this, endState, this.delay + this.pulseLength);
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        this.stateBefore = current;
    }

    @Override
    public void write(boolean preview, CompoundTag nbt) {
        nbt.putInt("length", this.pulseLength);
        nbt.putBoolean("before", this.stateBefore);
        if (preview) {
            return;
        }
        if (this.pulseStart != null) {
            nbt.putInt("start", this.pulseStart.getDelay());
        }
        if (this.pulseEnd != null) {
            nbt.putInt("end", this.pulseEnd.getDelay());
        }
    }
}

