/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.premade.signal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.SurroundingBox;
import team.creative.littletiles.common.placement.box.LittlePlaceBox;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxFacing;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.type.premade.signal.LittleSignalCableBase;

public class LittleSignalInput
extends LittleSignalCableBase
implements ISignalStructureComponent {
    private SignalState state = SignalState.create(this.getBandwidth());
    @StructureDirectional
    public Facing facing;

    public LittleSignalInput(LittleStructureTypeInput type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean canConnect(Facing facing) {
        return facing == this.facing;
    }

    @Override
    public void overwriteState(SignalState state) {
        this.state = this.state.overwrite(state);
        this.state.shrinkTo(this.getBandwidth());
    }

    @Override
    public SignalState getState() {
        return this.state;
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadExtra(nbt, provider);
        this.state = this.state.load(nbt.get("state"));
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveExtra(nbt, provider);
        nbt.put("state", this.state.save());
    }

    @Override
    public SignalComponentType getComponentType() {
        return SignalComponentType.INPUT;
    }

    @Override
    public void changed() {
        try {
            if (this.getParent() != null) {
                this.getParent().getStructure().changed(this);
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFace(Facing facing, LittleGrid grid, LittleBox renderBox, int distance, Axis axis, Axis one, Axis two, boolean positive, boolean oneSidedRenderer, List<LittleRenderBox> cubes) {
        super.renderFace(facing, grid, renderBox.copy(), distance, axis, one, two, positive, oneSidedRenderer, cubes);
        LittleRenderBox cube = renderBox.getRenderingBox(grid, (BlockState)((Block)LittleTilesRegistry.INPUT_ARROW.value()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing.toVanilla()));
        cube.keepVU = true;
        cube.allowOverlap = true;
        if (positive) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + grid.toVanillaGridF(renderBox.getSize(axis)) * 0.7f);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - grid.toVanillaGridF(renderBox.getSize(axis)) * 0.7f);
        }
        float shrink = 0.14f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        super.render(box, overallBox, cubes);
        AlignedBox cube = new AlignedBox(overallBox.getBox(box.getGrid()));
        BlockState cleanState = ((Block)LittleTilesRegistry.CLEAN.value()).defaultBlockState();
        float sizePercentage = 0.25f;
        Axis one = this.facing.one();
        Axis two = this.facing.two();
        float sizeOne = cube.getSize(one);
        float sizeTwo = cube.getSize(two);
        float sizeAxis = cube.getSize(this.facing.axis);
        LittleRenderBox top = new LittleRenderBox(cube, cleanState).setColor(this.color);
        top.allowOverlap = true;
        top.setMin(one, top.getMax(one) - sizeOne * sizePercentage);
        cubes.add(top);
        LittleRenderBox bottom = new LittleRenderBox(cube, cleanState).setColor(this.color);
        bottom.allowOverlap = true;
        bottom.setMax(one, bottom.getMin(one) + sizeOne * sizePercentage);
        cubes.add(bottom);
        LittleRenderBox left = new LittleRenderBox(cube, cleanState).setColor(this.color);
        left.allowOverlap = true;
        left.setMin(two, top.getMax(two) - sizeTwo * sizePercentage);
        cubes.add(left);
        LittleRenderBox right = new LittleRenderBox(cube, cleanState).setColor(this.color);
        right.allowOverlap = true;
        right.setMax(two, right.getMin(two) + sizeTwo * sizePercentage);
        cubes.add(right);
        LittleRenderBox behind = new LittleRenderBox(cube, cleanState).setColor(this.color);
        behind.allowOverlap = true;
        float depth = sizeAxis * 0.12f;
        behind.setMin(one, behind.getMin(one) + sizeOne * sizePercentage);
        behind.setMax(one, behind.getMax(one) - sizeOne * sizePercentage);
        behind.setMin(two, behind.getMin(two) + sizeTwo * sizePercentage);
        behind.setMax(two, behind.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.positive) {
            behind.setMax(this.facing.axis, behind.getMin(this.facing.axis) + sizeAxis * 0.5f);
        } else {
            behind.setMin(this.facing.axis, behind.getMax(this.facing.axis) - sizeAxis * 0.5f);
        }
        cubes.add(behind);
        LittleRenderBox front = new LittleRenderBox(cube, cleanState).setColor(-16740609);
        front.allowOverlap = true;
        front.setMin(one, front.getMin(one) + sizeOne * sizePercentage);
        front.setMax(one, front.getMax(one) - sizeOne * sizePercentage);
        front.setMin(two, front.getMin(two) + sizeTwo * sizePercentage);
        front.setMax(two, front.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.positive) {
            front.setMin(this.facing.axis, front.getMax(this.facing.axis) - sizeAxis * 0.5f);
            front.setMax(this.facing.axis, front.getMax(this.facing.axis) - depth);
        } else {
            front.setMax(this.facing.axis, front.getMin(this.facing.axis) + sizeAxis * 0.5f);
            front.setMin(this.facing.axis, front.getMin(this.facing.axis) + depth);
        }
        cubes.add(front);
        float thickness = 1.0E-4f;
        LittleRenderBox frontTop = new LittleRenderBox(cube, cleanState).setColor(-16740609);
        frontTop.allowOverlap = true;
        frontTop.setMin(one, frontTop.getMin(one) + sizeOne * sizePercentage);
        frontTop.setMax(one, frontTop.getMin(one) + thickness);
        frontTop.setMin(two, frontTop.getMin(two) + sizeTwo * sizePercentage);
        frontTop.setMax(two, frontTop.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.positive) {
            frontTop.setMin(this.facing.axis, frontTop.getMax(this.facing.axis) - sizeAxis * sizePercentage);
        } else {
            frontTop.setMax(this.facing.axis, frontTop.getMin(this.facing.axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontTop);
        LittleRenderBox frontBottom = new LittleRenderBox(cube, cleanState).setColor(-16740609);
        frontBottom.allowOverlap = true;
        frontBottom.setMax(one, frontBottom.getMax(one) - sizeOne * sizePercentage);
        frontBottom.setMin(one, frontBottom.getMax(one) - thickness);
        frontBottom.setMin(two, frontBottom.getMin(two) + sizeTwo * sizePercentage);
        frontBottom.setMax(two, frontBottom.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.positive) {
            frontBottom.setMin(this.facing.axis, frontBottom.getMax(this.facing.axis) - sizeAxis * sizePercentage);
        } else {
            frontBottom.setMax(this.facing.axis, frontBottom.getMin(this.facing.axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontBottom);
        LittleRenderBox frontRight = new LittleRenderBox(cube, cleanState).setColor(-16740609);
        frontRight.allowOverlap = true;
        frontRight.setMin(one, frontRight.getMin(one) + sizeOne * sizePercentage);
        frontRight.setMax(one, frontRight.getMax(one) - sizeOne * sizePercentage);
        frontRight.setMin(two, frontRight.getMin(two) + sizeTwo * sizePercentage);
        frontRight.setMax(two, frontRight.getMin(two) + thickness);
        if (this.facing.positive) {
            frontRight.setMin(this.facing.axis, frontRight.getMax(this.facing.axis) - sizeAxis * sizePercentage);
        } else {
            frontRight.setMax(this.facing.axis, frontRight.getMin(this.facing.axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontRight);
        LittleRenderBox frontLeft = new LittleRenderBox(cube, cleanState).setColor(-16740609);
        frontLeft.allowOverlap = true;
        frontLeft.setMin(one, frontLeft.getMin(one) + sizeOne * sizePercentage);
        frontLeft.setMax(one, frontLeft.getMax(one) - sizeOne * sizePercentage);
        frontLeft.setMax(two, frontLeft.getMax(two) - sizeTwo * sizePercentage);
        frontLeft.setMin(two, frontLeft.getMax(two) - thickness);
        if (this.facing.positive) {
            frontLeft.setMin(this.facing.axis, frontLeft.getMax(this.facing.axis) - sizeAxis * sizePercentage);
        } else {
            frontLeft.setMax(this.facing.axis, frontLeft.getMin(this.facing.axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontLeft);
    }

    @Override
    public int getIndex(Facing facing) {
        return 0;
    }

    @Override
    public Facing getFacing(int index) {
        return this.facing;
    }

    @Override
    public int getId() {
        return this.getParent().childId;
    }

    @Override
    public LittleStructure getStructure() {
        try {
            return this.getParent().getStructure();
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasWrenchInfo() {
        return true;
    }

    @Override
    public List<Component> wrenchInfo() {
        return Arrays.asList(Component.literal((String)this.info()));
    }

    @Override
    public String info() {
        if (this.getParent() != null) {
            return "i" + this.getId() + ":" + this.getState().print(this.getBandwidth());
        }
        return "";
    }

    public static class LittleStructureTypeInput
    extends LittleSignalCableBase.LittleStructureTypeNetwork {
        public <T extends LittleSignalInput> LittleStructureTypeInput(String id, Class<T> structureClass, BiFunction<? extends LittleStructureTypeInput, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, String modid, int bandwidth) {
            super(id, structureClass, factory, attribute, modid, bandwidth, 1);
        }

        @Override
        public List<LittlePlaceBox> getSpecialBoxes(LittleGroup group) {
            List<LittlePlaceBox> result = super.getSpecialBoxes(group);
            Facing facing = (Facing)this.loadDirectional(group, "facing");
            LittleBox box = group.getSurroundingBox();
            result.add(new LittlePlaceBoxFacing(box, facing, -16740609));
            return result;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<RenderBox> getItemPreview(LittleGroup previews, boolean translucent) {
            ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
            float size = (float)((Math.sqrt(this.bandwidth) * 1.0 / 32.0 + 0.05) * 1.4);
            cubes = new ArrayList();
            cubes.add(new RenderBox(0.0f, 0.5f - size, 0.5f - size, size * 2.0f, 0.5f + size, 0.5f + size, (Block)LittleTilesRegistry.CLEAN.value()).setColor(this.getColor(previews)));
            cubes.add(new RenderBox(size * 2.0f, 0.5f - size, 0.5f - size, size * 2.5f, 0.5f + size, 0.5f + size, (Block)LittleTilesRegistry.CLEAN.value()).setColor(-16740609));
            return cubes;
        }

        @Override
        public int getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public void changed() {
        }

        @Override
        public SignalState getState() {
            return null;
        }

        @Override
        public void overwriteState(SignalState state) {
        }

        @Override
        public SignalComponentType getComponentType() {
            return SignalComponentType.INPUT;
        }
    }
}

