/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.handler;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.action.ActionEvent;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.exception.LittleActionException;
import team.creative.littletiles.common.packet.action.ActionMessagePacket;
import team.creative.littletiles.common.packet.action.PlacementPlayerSettingPacket;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;

public class LittleActionHandlerServer {
    public static void handleException(ServerPlayer player, LittleActionException e) {
        if (e.isHidden()) {
            return;
        }
        List<Component> message = e.getActionMessage();
        if (message != null) {
            LittleTiles.NETWORK.sendToClient((CreativePacket)new ActionMessagePacket(message), player);
        } else {
            player.sendSystemMessage((Component)Component.literal((String)e.getLocalizedMessage()));
        }
    }

    public static <T> T execute(ServerPlayer player, LittleAction<T> action) {
        try {
            T result = action.action((Player)player);
            if (action.wasSuccessful(result)) {
                NeoForge.EVENT_BUS.post((Event)new ActionEvent(action, ActionEvent.ActionType.NORMAL, (Player)player));
                return result;
            }
        }
        catch (LittleActionException e) {
            LittleActionHandlerServer.handleException(player, e);
        }
        return action.failed();
    }

    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        LittleTiles.NETWORK.sendToClient((CreativePacket)new PlacementPlayerSettingPacket(new PlacementPlayerSetting(player.getPersistentData().getCompound("PlayerPersisted").getCompound("littletiles:place"))), player);
    }
}

