/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.util.argument.StringArrayArgumentType;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.action.LittleActionActivated;
import team.creative.littletiles.common.action.LittleActionColorBoxes;
import team.creative.littletiles.common.action.LittleActionDestroy;
import team.creative.littletiles.common.action.LittleActionDestroyBoxes;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.action.LittleActionRegistry;
import team.creative.littletiles.common.action.LittleActions;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.registry.LittleBlocks;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.config.LittleTilesConfig;
import team.creative.littletiles.common.entity.EntitySizeHandler;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.entity.level.LittleLevelEntity;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.rules.IngredientRules;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.item.LittleItemHandler;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.level.handler.LittleAnimationHandlers;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.level.tick.LittleTickers;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.mod.theoneprobe.TheOneProbeManager;
import team.creative.littletiles.common.packet.LittlePacketTypes;
import team.creative.littletiles.common.packet.action.ActionMessagePacket;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.packet.action.ChangedColorPacket;
import team.creative.littletiles.common.packet.action.ChangedElementPacket;
import team.creative.littletiles.common.packet.action.ChangedPosPacket;
import team.creative.littletiles.common.packet.action.LittleInteractionPacket;
import team.creative.littletiles.common.packet.action.PlacementPlayerSettingPacket;
import team.creative.littletiles.common.packet.entity.EntityOriginChanged;
import team.creative.littletiles.common.packet.entity.LittleEntityPhysicPacket;
import team.creative.littletiles.common.packet.entity.LittleEntityTransitionPacket;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.common.packet.entity.LittleVanillaPackets;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationBlocksPacket;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationInitPacket;
import team.creative.littletiles.common.packet.entity.level.LittleLevelInitPacket;
import team.creative.littletiles.common.packet.item.PlacerMatrixPacket;
import team.creative.littletiles.common.packet.item.SelectionModePacket;
import team.creative.littletiles.common.packet.item.ShapeConfigPacket;
import team.creative.littletiles.common.packet.structure.BedUpdate;
import team.creative.littletiles.common.packet.structure.StructureBlockToEntityPacket;
import team.creative.littletiles.common.packet.structure.StructureEntityToBlockPacket;
import team.creative.littletiles.common.packet.structure.StructureStartAnimationPacket;
import team.creative.littletiles.common.packet.structure.StructureUpdate;
import team.creative.littletiles.common.packet.update.BlockUpdate;
import team.creative.littletiles.common.packet.update.BlocksUpdate;
import team.creative.littletiles.common.packet.update.NeighborUpdate;
import team.creative.littletiles.common.packet.update.OutputUpdate;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;
import team.creative.littletiles.common.structure.type.bed.LittleBedEventHandler;
import team.creative.littletiles.mixin.server.level.ChunkMapAccessor;
import team.creative.littletiles.server.LittleTilesServer;

@Mod(value="littletiles")
public class LittleTiles {
    public static final String MODID = "littletiles";
    public static LittleTilesConfig CONFIG;
    public static final Logger LOGGER;
    public static final CreativeNetwork NETWORK;
    public static final LittleAnimationHandlers ANIMATION_HANDLERS;
    public static final LittleTickers TICKERS;
    public static TagKey<Block> STORAGE_BLOCKS;

    public LittleTiles(IEventBus bus) {
        bus.addListener(this::init);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            LittleTilesClient.load(bus);
        }
        NeoForge.EVENT_BUS.addListener(this::serverStarting);
        NeoForge.EVENT_BUS.addListener(this::reloadListener);
        LittleTilesRegistry.BLOCKS.register(bus);
        LittleTilesRegistry.ITEMS.register(bus);
        LittleTilesRegistry.DATA_COMPONENTS.register(bus);
        LittleTilesRegistry.BLOCK_ENTITIES.register(bus);
        LittleTilesRegistry.ENTITIES.register(bus);
        LittleTilesRegistry.CREATIVE_TABS.register(bus);
        LittleTilesRegistry.RECIPE_SERIALIZERS.register(bus);
        LittleTilesRegistry.INGREDIENT_TYPES.register(bus);
        LittlePacketTypes.init();
    }

    private void init(FMLCommonSetupEvent event) {
        IngredientRules.loadRules();
        LittleStructureRegistry.initStructures();
        NETWORK.registerType(ActionMessagePacket.class, ActionMessagePacket::new);
        NETWORK.registerType(BlockPacket.class, BlockPacket::new);
        NETWORK.registerType(PlacementPlayerSettingPacket.class, PlacementPlayerSettingPacket::new);
        NETWORK.registerType(ChangedElementPacket.class, ChangedElementPacket::new);
        NETWORK.registerType(ChangedColorPacket.class, ChangedColorPacket::new);
        NETWORK.registerType(ChangedPosPacket.class, ChangedPosPacket::new);
        NETWORK.registerType(PlacerMatrixPacket.class, PlacerMatrixPacket::new);
        NETWORK.registerType(SelectionModePacket.class, SelectionModePacket::new);
        NETWORK.registerType(ShapeConfigPacket.class, ShapeConfigPacket::new);
        NETWORK.registerType(BedUpdate.class, BedUpdate::new);
        NETWORK.registerType(StructureBlockToEntityPacket.class, StructureBlockToEntityPacket::new);
        NETWORK.registerType(StructureEntityToBlockPacket.class, StructureEntityToBlockPacket::new);
        NETWORK.registerType(StructureUpdate.class, StructureUpdate::new);
        NETWORK.registerType(StructureStartAnimationPacket.class, StructureStartAnimationPacket::new);
        NETWORK.registerType(NeighborUpdate.class, NeighborUpdate::new);
        NETWORK.registerType(BlockUpdate.class, BlockUpdate::new);
        NETWORK.registerType(BlocksUpdate.class, BlocksUpdate::new);
        NETWORK.registerType(OutputUpdate.class, OutputUpdate::new);
        NETWORK.registerType(LittleEntityTransitionPacket.class, LittleEntityTransitionPacket::new);
        NETWORK.registerType(EntityOriginChanged.class, EntityOriginChanged::new);
        NETWORK.registerType(LittleEntityPhysicPacket.class, LittleEntityPhysicPacket::new);
        NETWORK.registerType(LittleAnimationInitPacket.class, LittleAnimationInitPacket::new);
        NETWORK.registerType(LittleAnimationBlocksPacket.class, LittleAnimationBlocksPacket::new);
        NETWORK.registerType(LittleVanillaPacket.class, LittleVanillaPacket::new);
        NETWORK.registerType(LittleVanillaPackets.class, LittleVanillaPackets::new);
        NETWORK.registerType(LittleLevelInitPacket.class, LittleLevelInitPacket::new);
        NETWORK.registerType(LittleInteractionPacket.class, LittleInteractionPacket::new);
        CONFIG = new LittleTilesConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        LittleActionRegistry.register(LittleActions.class, LittleActions::new);
        LittleActionRegistry.register(LittleActionPlace.class, LittleActionPlace::new);
        LittleActionRegistry.register(LittleActionActivated.class, LittleActionActivated::new);
        LittleActionRegistry.register(LittleActionColorBoxes.class, LittleActionColorBoxes::new);
        LittleActionRegistry.register(LittleActionColorBoxes.LittleActionColorBoxesFiltered.class, LittleActionColorBoxes.LittleActionColorBoxesFiltered::new);
        LittleActionRegistry.register(LittleActionDestroyBoxes.class, LittleActionDestroyBoxes::new);
        LittleActionRegistry.register(LittleActionDestroyBoxes.LittleActionDestroyBoxesFiltered.class, LittleActionDestroyBoxes.LittleActionDestroyBoxesFiltered::new);
        LittleActionRegistry.register(LittleActionDestroy.class, LittleActionDestroy::new);
        NeoForge.EVENT_BUS.register((Object)new LittleBedEventHandler());
        NeoForge.EVENT_BUS.register((Object)new LittleItemHandler());
        LittleTilesServer.init(event);
        if (ModList.get().isLoaded("theoneprobe")) {
            TheOneProbeManager.init();
        }
        NeoForge.EVENT_BUS.register(EntitySizeHandler.class);
        STORAGE_BLOCKS = BlockTags.create((ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)"storage_blocks"));
        LittleTilesGuiRegistry.init();
        LittleBlocks.init();
    }

    private void reloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(this){

            @Nullable
            protected Void prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
                ItemMultiTiles.reloadExampleStructures(resourceManager);
                return null;
            }

            protected void apply(@Nullable Void object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
            }
        });
    }

    private void serverStarting(ServerStartingEvent event) {
        NeoForgeConfig.SERVER.fullBoundingBoxLadders.set((Object)true);
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"lt-tovanilla").executes(x -> {
            ArrayList<BETiles> blocks = new ArrayList<BETiles>();
            for (ServerLevel level : ((CommandSourceStack)x.getSource()).getServer().getAllLevels()) {
                for (ChunkHolder holder : ((ChunkMapAccessor)level.getChunkSource().chunkMap).callGetChunks()) {
                    LevelChunk chunk = holder.getTickingChunk();
                    if (chunk == null) continue;
                    for (BlockEntity be : chunk.getBlockEntities().values()) {
                        if (!(be instanceof BETiles)) continue;
                        BETiles b = (BETiles)be;
                        blocks.add(b);
                    }
                }
            }
            ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Attempting to convert " + blocks.size() + " blocks!")), false);
            int converted = 0;
            int i = 0;
            for (BETiles be : blocks) {
                if (be.convertBlockToVanilla()) {
                    // empty if block
                }
                int index = ++i;
                int convertedValue = ++converted;
                if (i % 50 != 0) continue;
                ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Processed " + index + "/" + blocks.size() + " and converted " + convertedValue)), false);
            }
            int convertedValue = converted;
            ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Converted " + convertedValue + " blocks")), false);
            return 0;
        }));
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"lt-export").executes(x -> {
            LittleTilesGuiRegistry.EXPORTER.open((Player)((CommandSourceStack)x.getSource()).getPlayerOrException());
            return 0;
        }));
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"lt-import").executes(x -> {
            LittleTilesGuiRegistry.IMPORTER.open((Player)((CommandSourceStack)x.getSource()).getPlayerOrException());
            return 0;
        }));
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"level").executes(x -> {
            try {
                ServerLevel level = ((CommandSourceStack)x.getSource()).getLevel();
                BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)x.getSource()).getPosition()).above();
                LittleLevelEntity entity = new LittleLevelEntity((Level)level, pos);
                LittleSubLevel subLevel = entity.getSubLevel();
                LittleGrid grid = LittleGrid.overallDefault();
                CompoundTag nbt = new CompoundTag();
                nbt.putString("id", ((LittleStructureType)LittleStructureRegistry.REGISTRY.getDefault()).id);
                LittleGroup group = new LittleGroup(nbt, (List<LittleGroup>)Collections.EMPTY_LIST);
                group.add(grid, new LittleElement(Blocks.STONE.defaultBlockState(), -1), new LittleBox(0, grid.count - 1, 0, grid.count, grid.count, grid.count));
                subLevel.setBlock(pos.above(), Blocks.DIRT.defaultBlockState(), 3);
                PlacementPreview preview = PlacementPreview.load(null, PlacementMode.ALL, new LittleGroupAbsolute(pos, group));
                Placement placement = new Placement(null, (Level)subLevel, preview);
                PlacementResult result = placement.place();
                if (result == null) {
                    throw new LittleActionException("Could not be placed");
                }
                level.addFreshEntity((Entity)entity);
                ((CommandSourceStack)x.getSource()).sendSystemMessage((Component)Component.literal((String)"Spawned level"));
            }
            catch (LittleActionException e) {
                ((CommandSourceStack)x.getSource()).sendFailure(e.getTranslatable());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            catch (Error e) {
                e.printStackTrace();
            }
            return 0;
        }));
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"animation").executes(x -> {
            try {
                ServerLevel level = ((CommandSourceStack)x.getSource()).getLevel();
                BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)x.getSource()).getPosition()).above();
                LittleAnimationLevel subLevel = new LittleAnimationLevel((Level)level);
                LittleGrid grid = LittleGrid.overallDefault();
                CompoundTag nbt = new CompoundTag();
                nbt.putString("id", ((LittleStructureType)LittleStructureRegistry.REGISTRY.getDefault()).id);
                LittleGroup group = new LittleGroup(nbt, (List<LittleGroup>)Collections.EMPTY_LIST);
                group.add(grid, new LittleElement(Blocks.STONE.defaultBlockState(), -1), new LittleBox(0, grid.count - 1, 0, grid.count, grid.count, grid.count));
                PlacementPreview preview = PlacementPreview.load(null, PlacementMode.ALL, new LittleGroupAbsolute(pos, group));
                level.addFreshEntity((Entity)new LittleAnimationEntity((Level)level, subLevel, new StructureAbsolute(pos, grid.box(), grid), new Placement(null, subLevel, preview)));
                ((CommandSourceStack)x.getSource()).sendSystemMessage((Component)Component.literal((String)"Spawned animation"));
            }
            catch (LittleActionException e) {
                ((CommandSourceStack)x.getSource()).sendFailure(e.getTranslatable());
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                throw e;
            }
            return 0;
        }));
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"lt-optimize").executes(x -> {
            int levels = 0;
            int chunks = 0;
            int totalTiles = 0;
            int newCount = 0;
            int toVanilla = 0;
            ArrayList<BETiles> blocks = new ArrayList<BETiles>();
            for (Object level : ((CommandSourceStack)x.getSource()).getServer().getAllLevels()) {
                for (ChunkHolder holder : ((ChunkMapAccessor)level.getChunkSource().chunkMap).callGetChunks()) {
                    LevelChunk chunk = holder.getTickingChunk();
                    if (chunk != null) {
                        for (BlockEntity be : chunk.getBlockEntities().values()) {
                            if (!(be instanceof BETiles)) continue;
                            BETiles b = (BETiles)be;
                            blocks.add(b);
                        }
                    }
                    ++chunks;
                }
                ++levels;
            }
            ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Attempting to optimize " + blocks.size() + " blocks!")), false);
            int i = 0;
            for (BETiles be : blocks) {
                totalTiles += be.boxesCount();
                be.optimizeTiles();
                if (be.convertBlockToVanilla()) {
                    ++toVanilla;
                } else {
                    newCount += be.boxesCount();
                }
                int index = ++i;
                if (i % 50 != 0) continue;
                ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Processed " + index + "/" + blocks.size() + " blocks")), false);
            }
            if (toVanilla > 0) {
                int convertedBlocks = toVanilla;
                ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Converted " + convertedBlocks + " to vanilla blocks.")), false);
            }
            int result = totalTiles - newCount;
            ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Optimization could save " + result + " tiles.")), false);
            int levelCount = levels;
            int chunkCount = chunks;
            int tilesCount = totalTiles;
            ((CommandSourceStack)x.getSource()).sendSuccess(() -> Component.literal((String)("Scanned " + levelCount + " levels, " + chunkCount + " chunks, " + blocks.size() + " blocks, " + tilesCount + " tiles")), false);
            return 0;
        }));
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lt-open").then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(x -> {
            ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)x, (String)"position");
            ServerLevel level = ((CommandSourceStack)x.getSource()).getLevel();
            for (LittleDoor door : LittleTiles.findDoors((LittleAnimationHandler)ANIMATION_HANDLERS.get((Level)level), new AABB(pos))) {
                doors.add(door);
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BETiles) {
                BETiles be = (BETiles)blockEntity;
                for (LittleStructure structure : be.loadedStructures()) {
                    if (!(structure instanceof LittleDoor)) continue;
                    LittleDoor d = (LittleDoor)structure;
                    try {
                        structure = d.getParentDoor();
                        if (doors.contains(structure)) continue;
                        try {
                            structure.checkConnections();
                            doors.add(d);
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            ((CommandSourceStack)x.getSource()).sendFailure((Component)Component.translatable((String)"commands.open.notloaded"));
                        }
                    }
                    catch (LittleActionException littleActionException) {}
                }
            }
            for (LittleDoor door : doors) {
                door.toggleState();
            }
            return 0;
        }))).then(Commands.argument((String)"names", (ArgumentType)StringArrayArgumentType.stringArray()).executes(x -> {
            ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)x, (String)"position");
            ServerLevel level = ((CommandSourceStack)x.getSource()).getLevel();
            String[] args = StringArrayArgumentType.getStringArray((CommandContext)x, (String)"names");
            for (LittleDoor door : LittleTiles.findDoors((LittleAnimationHandler)ANIMATION_HANDLERS.get((Level)level), new AABB(pos))) {
                if (!this.checkStructureName(door, args)) continue;
                doors.add(door);
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BETiles) {
                BETiles be = (BETiles)blockEntity;
                for (LittleStructure structure : be.loadedStructures()) {
                    if (!(structure instanceof LittleDoor)) continue;
                    LittleDoor d = (LittleDoor)structure;
                    try {
                        structure = d.getParentDoor();
                        if (!this.checkStructureName(structure, args) || doors.contains(structure)) continue;
                        try {
                            structure.checkConnections();
                            doors.add(d);
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            ((CommandSourceStack)x.getSource()).sendFailure((Component)Component.translatable((String)"commands.open.notloaded"));
                        }
                    }
                    catch (LittleActionException littleActionException) {}
                }
            }
            for (LittleDoor door : doors) {
                door.toggleState();
            }
            return 0;
        })));
    }

    public static List<LittleDoor> findDoors(LittleAnimationHandler handler, AABB box) {
        ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
        for (LittleEntity entity : handler.entities) {
            if (!(entity instanceof LittleAnimationEntity)) continue;
            LittleAnimationEntity a = (LittleAnimationEntity)entity;
            try {
                LittleStructure littleStructure = a.getStructure();
                if (!(littleStructure instanceof LittleDoor)) continue;
                LittleDoor d = (LittleDoor)littleStructure;
                if (!entity.getBoundingBox().intersects(box) || doors.contains(a.getStructure())) continue;
                doors.add(d.getParentDoor());
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
        return doors;
    }

    protected boolean checkStructureName(LittleStructure structure, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (structure.name == null || !structure.name.equalsIgnoreCase(args[i])) continue;
            return true;
        }
        return false;
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        NETWORK = new CreativeNetwork(1, LOGGER, ResourceLocation.tryBuild((String)MODID, (String)"main"));
        ANIMATION_HANDLERS = new LittleAnimationHandlers();
        TICKERS = new LittleTickers();
    }
}

