/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeBlockModel;
import team.creative.creativecore.client.render.model.CreativeItemBoxModel;
import team.creative.creativecore.client.render.model.CreativeItemModel;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.action.interact.LittleInteractionHandlerClient;
import team.creative.littletiles.client.level.LevelHandlersClient;
import team.creative.littletiles.client.level.LittleAnimationHandlerClient;
import team.creative.littletiles.client.level.LittleVanillaInteractionHandlerClient;
import team.creative.littletiles.client.mod.iris.IrisManager;
import team.creative.littletiles.client.mod.sodium.SodiumManager;
import team.creative.littletiles.client.player.LittleClientPlayerConnection;
import team.creative.littletiles.client.render.block.BETilesRenderer;
import team.creative.littletiles.client.render.block.BlockTileRenderProperties;
import team.creative.littletiles.client.render.block.LittleBlockClientRegistry;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.client.render.entity.LittleEntityRenderer;
import team.creative.littletiles.client.render.entity.LittleSitRenderer;
import team.creative.littletiles.client.render.entity.RenderSizedTNTPrimed;
import team.creative.littletiles.client.render.item.ItemRenderCache;
import team.creative.littletiles.client.render.item.LittleModelItemBackground;
import team.creative.littletiles.client.render.item.LittleModelItemPreview;
import team.creative.littletiles.client.render.item.LittleModelItemTilesBig;
import team.creative.littletiles.client.render.level.LittleClientEventHandler;
import team.creative.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import team.creative.littletiles.client.render.overlay.OverlayRenderer;
import team.creative.littletiles.client.render.overlay.PreviewRenderer;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.item.ItemPremadeStructure;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

@OnlyIn(value=Dist.CLIENT)
public class LittleTilesClient {
    public static final Minecraft MC = Minecraft.getInstance();
    public static final IKeyConflictContext LITTLE_KEY_CONTEXT = new IKeyConflictContext(){

        public boolean isActive() {
            return true;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    };
    public static final LevelHandlersClient LEVEL_HANDLERS = new LevelHandlersClient();
    public static LittleActionHandlerClient ACTION_HANDLER;
    public static LittleAnimationHandlerClient ANIMATION_HANDLER;
    public static LittleVanillaInteractionHandlerClient INTERACTION_HANDLER;
    public static LittleInteractionHandlerClient INTERACTION;
    public static PreviewRenderer PREVIEW_RENDERER;
    public static ItemRenderCache ITEM_RENDER_CACHE;
    public static LittleClientPlayerConnection PLAYER_CONNECTION;
    public static OverlayRenderer OVERLAY_RENDERER;
    public static KeyMapping KEY_MIRROR;
    public static KeyMapping KEY_MARK;
    public static KeyMapping KEY_CONFIGURE;
    public static KeyMapping KEY_UP;
    public static KeyMapping KEY_DOWN;
    public static KeyMapping KEY_RIGHT;
    public static KeyMapping KEY_LEFT;
    public static KeyMapping[] TOOL_KEYS;
    public static KeyMapping KEY_UNDO;
    public static KeyMapping KEY_REDO;
    public static BETilesRenderer BLOCK_TILES_RENDERER;

    public static void grid(LittleGrid grid) {
        LittleTilesClient.ACTION_HANDLER.setting.grid(grid);
    }

    public static void placementMode(PlacementMode mode) {
        LittleTilesClient.ACTION_HANDLER.setting.placementMode(mode);
    }

    public static void setPlace(LittleGrid grid, PlacementMode mode) {
        LittleTilesClient.ACTION_HANDLER.setting.set(grid, mode);
    }

    public static Component arrowKeysTooltip() {
        if (KEY_UP.isDefault() && KEY_DOWN.isDefault() && KEY_RIGHT.isDefault() && KEY_LEFT.isDefault()) {
            return Component.translatable((String)"gui.tooltip.arrow_keys");
        }
        return Component.empty().append(KEY_UP.getTranslatedKeyMessage()).append(", ").append(KEY_DOWN.getTranslatedKeyMessage()).append(", ").append(KEY_RIGHT.getTranslatedKeyMessage()).append(", ").append(KEY_LEFT.getTranslatedKeyMessage());
    }

    public static void displayActionMessage(List<Component> message) {
        OVERLAY_RENDERER.displayActionMessage(message);
    }

    public static IntMatrix3c fromKeybind(Player player, KeyMapping key) {
        if (key == KEY_UP) {
            return Rotation.Z_CLOCKWISE.getMatrix();
        }
        if (key == KEY_DOWN) {
            return Rotation.Z_COUNTER_CLOCKWISE.getMatrix();
        }
        if (key == KEY_RIGHT) {
            return Rotation.Y_COUNTER_CLOCKWISE.getMatrix();
        }
        if (key == KEY_LEFT) {
            return Rotation.Y_CLOCKWISE.getMatrix();
        }
        if (key == KEY_MIRROR) {
            return Facing.of((Player)player).axis.getMatrix();
        }
        return null;
    }

    public static void load(IEventBus bus) {
        bus.addListener(LittleTilesClient::setup);
        NeoForge.EVENT_BUS.addListener(LittleTilesClient::commands);
        bus.addListener(LittleTilesClient::initItemColors);
        bus.addListener(LittleTilesClient::initBlockColors);
        bus.addListener(LittleTilesClient::registerKeys);
        bus.addListener(LittleTilesClient::modelEvent);
        bus.addListener(LittleTilesClient::modelLoader);
        bus.addListener(LittleTilesClient::initBlockClient);
    }

    private static void registerKeys(RegisterKeyMappingsEvent event) {
        KEY_UP = new LittleKeyMapping("key.rotateup", LITTLE_KEY_CONTEXT, 265, "key.categories.littletiles").ignoreModifier();
        KEY_DOWN = new LittleKeyMapping("key.rotatedown", LITTLE_KEY_CONTEXT, 264, "key.categories.littletiles").ignoreModifier();
        KEY_RIGHT = new LittleKeyMapping("key.rotateright", LITTLE_KEY_CONTEXT, 262, "key.categories.littletiles").ignoreModifier();
        KEY_LEFT = new LittleKeyMapping("key.rotateleft", LITTLE_KEY_CONTEXT, 263, "key.categories.littletiles").ignoreModifier();
        KEY_MIRROR = new LittleKeyMapping("key.little.mirror", LITTLE_KEY_CONTEXT, 71, "key.categories.littletiles");
        KEY_MARK = new LittleKeyMapping("key.little.mark", LITTLE_KEY_CONTEXT, 77, "key.categories.littletiles");
        KEY_CONFIGURE = new LittleKeyMapping("key.little.config.item", LITTLE_KEY_CONTEXT, 67, "key.categories.littletiles");
        KEY_UNDO = new LittleKeyMapping("key.little.undo", LITTLE_KEY_CONTEXT, KeyModifier.CONTROL, 90, "key.categories.littletiles");
        KEY_REDO = new LittleKeyMapping("key.little.redo", LITTLE_KEY_CONTEXT, KeyModifier.CONTROL, 89, "key.categories.littletiles");
        event.register(KEY_UP);
        event.register(KEY_DOWN);
        event.register(KEY_RIGHT);
        event.register(KEY_LEFT);
        event.register(KEY_MIRROR);
        event.register(KEY_MARK);
        event.register(KEY_CONFIGURE);
        TOOL_KEYS = new KeyMapping[]{KEY_UP, KEY_DOWN, KEY_RIGHT, KEY_LEFT, KEY_MIRROR, KEY_MARK, KEY_CONFIGURE};
        event.register(KEY_UNDO);
        event.register(KEY_REDO);
    }

    private static void setup(FMLClientSetupEvent event) {
        MC.getItemColors().register((stack, layer) -> {
            if (layer == 0) {
                return -1;
            }
            return (Integer)stack.getOrDefault(LittleTilesRegistry.COLOR, (Object)-1);
        }, new ItemLike[]{(ItemLike)LittleTilesRegistry.PAINT_BRUSH.value()});
        NeoForge.EVENT_BUS.register((Object)new LittleClientEventHandler());
        LEVEL_HANDLERS.register(LittleActionHandlerClient::new, x -> {
            ACTION_HANDLER = x;
        });
        LEVEL_HANDLERS.register(LittleVanillaInteractionHandlerClient::new, x -> {
            INTERACTION_HANDLER = x;
        });
        LEVEL_HANDLERS.register(LittleTiles.ANIMATION_HANDLERS::get, x -> {
            ANIMATION_HANDLER = (LittleAnimationHandlerClient)x;
        });
        PREVIEW_RENDERER = new PreviewRenderer();
        LEVEL_HANDLERS.register(PREVIEW_RENDERER);
        ITEM_RENDER_CACHE = new ItemRenderCache();
        LEVEL_HANDLERS.register(ITEM_RENDER_CACHE);
        PLAYER_CONNECTION = new LittleClientPlayerConnection();
        LEVEL_HANDLERS.register(PLAYER_CONNECTION);
        INTERACTION = new LittleInteractionHandlerClient();
        LEVEL_HANDLERS.register(INTERACTION);
        NeoForge.EVENT_BUS.register(LittleTilesProfilerOverlay.class);
        OVERLAY_RENDERER = new OverlayRenderer();
        LEVEL_HANDLERS.register(OVERLAY_RENDERER);
        ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)MC.getResourceManager();
        reloadableResourceManager.registerReloadListener((PreparableReloadListener)new ResourceManagerReloadListener(){

            public void onResourceManagerReload(ResourceManager manager) {
                ++RenderingThread.CURRENT_RENDERING_INDEX;
                if (ANIMATION_HANDLER != null) {
                    ANIMATION_HANDLER.reload();
                }
                LittleBlockClientRegistry.clearCache();
                ITEM_RENDER_CACHE.clearCache();
            }
        });
        CreativeCoreClient.registerClientConfig((String)"littletiles");
        EntityRenderers.register((EntityType)((EntityType)LittleTilesRegistry.SIZED_TNT_TYPE.get()), RenderSizedTNTPrimed::new);
        EntityRenderers.register((EntityType)((EntityType)LittleTilesRegistry.ENTITY_LEVEL.get()), LittleEntityRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)LittleTilesRegistry.ENTITY_ANIMATION.get()), LittleEntityRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)LittleTilesRegistry.SIT_TYPE.get()), LittleSitRenderer::new);
        BLOCK_TILES_RENDERER = new BETilesRenderer();
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)LittleTilesRegistry.BE_TILES_TYPE_RENDERED.get()), x -> BLOCK_TILES_RENDERER);
        ResourceLocation filled = ResourceLocation.tryBuild((String)"littletiles", (String)"filled");
        ClampedItemPropertyFunction function = (stack, level, entity, x) -> (float)((ItemColorIngredient)stack.getItem()).getColor(stack) / (float)ColorIngredient.BOTTLE_SIZE;
        ItemProperties.register((Item)((Item)LittleTilesRegistry.BLACK_COLOR.value()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        ItemProperties.register((Item)((Item)LittleTilesRegistry.CYAN_COLOR.value()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        ItemProperties.register((Item)((Item)LittleTilesRegistry.MAGENTA_COLOR.value()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        ItemProperties.register((Item)((Item)LittleTilesRegistry.YELLOW_COLOR.value()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        SodiumManager.init();
        IrisManager.init();
    }

    private static void modelLoader(ModelEvent.RegisterAdditional event) {
        event.register(new ModelResourceLocation(ResourceLocation.tryBuild((String)"littletiles", (String)"glove_background"), "standalone"));
        event.register(new ModelResourceLocation(ResourceLocation.tryBuild((String)"littletiles", (String)"chisel_background"), "standalone"));
        event.register(new ModelResourceLocation(ResourceLocation.tryBuild((String)"littletiles", (String)"blueprint_background"), "standalone"));
    }

    private static void modelEvent(ModelEvent.RegisterGeometryLoaders event) {
        CreativeCoreClient.registerBlockModel((ResourceLocation)ResourceLocation.tryBuild((String)"littletiles", (String)"empty"), (CreativeBlockModel)new CreativeBlockModel(){

            public List<? extends RenderBox> getBoxes(BlockState state, ModelData data, RandomSource source) {
                return Collections.EMPTY_LIST;
            }

            @NotNull
            public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
                return modelData;
            }
        });
        CreativeCoreClient.registerItemModel((ResourceLocation)ResourceLocation.tryBuild((String)"littletiles", (String)"tiles"), (CreativeItemModel)new LittleModelItemTilesBig());
        CreativeCoreClient.registerItemModel((ResourceLocation)ResourceLocation.tryBuild((String)"littletiles", (String)"premade"), (CreativeItemModel)new LittleModelItemTilesBig(){

            @Override
            public List<? extends RenderBox> getBoxes(ItemStack stack, boolean translucent) {
                if (!ILittleTool.getData(stack).contains("s")) {
                    return Collections.EMPTY_LIST;
                }
                LittleStructurePremade.LittlePremadeType premade = ItemPremadeStructure.get(stack);
                if (premade == null) {
                    return Collections.EMPTY_LIST;
                }
                LittleGroup previews = ((ItemPremadeStructure)stack.getItem()).getTiles(stack);
                if (previews == null) {
                    return Collections.EMPTY_LIST;
                }
                List<RenderBox> cubes = premade.getItemPreview(previews, translucent);
                if (cubes == null) {
                    cubes = previews.getRenderingBoxes(translucent);
                    LittleGroup.shrinkCubesToOneBlock(cubes);
                }
                return cubes;
            }
        });
        CreativeCoreClient.registerItemModel((ResourceLocation)ResourceLocation.tryBuild((String)"littletiles", (String)"chisel"), (CreativeItemModel)new LittleModelItemPreview(new ModelResourceLocation(ResourceLocation.tryBuild((String)"littletiles", (String)"chisel_background"), "standalone"), stack -> LittleElement.getOrDefault(stack)));
        CreativeCoreClient.registerItemModel((ResourceLocation)ResourceLocation.tryBuild((String)"littletiles", (String)"blueprint"), (CreativeItemModel)new LittleModelItemBackground(new ModelResourceLocation(ResourceLocation.tryBuild((String)"littletiles", (String)"blueprint_background"), "standalone"), x -> {
            CompoundTag contentData = ItemLittleBlueprint.getContent(x);
            if (!LittleGroup.shouldRenderInHand(contentData)) {
                return ItemStack.EMPTY;
            }
            ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.value());
            ILittleTool.setData(stack, contentData);
            return stack;
        }));
        CreativeCoreClient.registerItemModel((ResourceLocation)ResourceLocation.tryBuild((String)"littletiles", (String)"blockingredient"), (CreativeItemModel)new CreativeItemBoxModel(new ModelResourceLocation(ResourceLocation.tryBuild((String)"minecraft", (String)"stone"), "standalone")){

            public List<? extends RenderBox> getBoxes(ItemStack stack, boolean translucent) {
                ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
                BlockIngredientEntry ingredient = ItemBlockIngredient.loadIngredient(stack);
                if (ingredient == null) {
                    return null;
                }
                double volume = Math.min(1.0, ingredient.value);
                LittleGrid context = LittleGrid.overallDefault();
                long pixels = (long)(volume * (double)context.count3d);
                if (pixels < (long)(context.count * context.count)) {
                    cubes.add(new RenderBox(0.4f, 0.4f, 0.4f, 0.6f, 0.6f, 0.6f, ingredient.block.getState()));
                } else {
                    long remainingPixels = pixels;
                    long planes = pixels / context.count2d;
                    long rows = (remainingPixels -= planes * context.count2d) / (long)context.count;
                    remainingPixels -= rows * (long)context.count;
                    float height = (float)((double)planes * context.pixelLength);
                    if (planes > 0L) {
                        cubes.add(new RenderBox(0.0f, 0.0f, 0.0f, 1.0f, height, 1.0f, ingredient.block.getState()));
                    }
                    float width = (float)((double)rows * context.pixelLength);
                    if (rows > 0L) {
                        cubes.add(new RenderBox(0.0f, height, 0.0f, 1.0f, height + (float)context.pixelLength, width, ingredient.block.getState()));
                    }
                    if (remainingPixels > 0L) {
                        cubes.add(new RenderBox(0.0f, height, width, 1.0f, height + (float)context.pixelLength, width + (float)context.pixelLength, ingredient.block.getState()));
                    }
                }
                return cubes;
            }
        });
    }

    private static void initItemColors(RegisterColorHandlersEvent.Item event) {
        CreativeCoreClient.registerItemColor((ItemColors)event.getItemColors(), (Item)((Item)LittleTilesRegistry.PREMADE.value()));
        CreativeCoreClient.registerItemColor((ItemColors)event.getItemColors(), (Item)((Item)LittleTilesRegistry.ITEM_TILES.value()));
        event.register((stack, tint) -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BlockItem) {
                BlockItem block = (BlockItem)patt0$temp;
                return event.getBlockColors().getColor(block.getBlock().defaultBlockState(), (BlockAndTintGetter)null, (BlockPos)null, tint);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)LittleTilesRegistry.WATER.value(), (ItemLike)LittleTilesRegistry.FLOWING_WATER.value()});
    }

    private static void initBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tint) -> level != null && pos != null ? ColorUtils.setAlpha((int)BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos), (int)255) : -12618012, new Block[]{(Block)LittleTilesRegistry.WATER.value(), (Block)LittleTilesRegistry.FLOWING_WATER.value()});
    }

    private static void commands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"lt-debug").executes(x -> {
            if (LittleTilesProfilerOverlay.isActive()) {
                LittleTilesProfilerOverlay.stop();
            } else {
                LittleTilesProfilerOverlay.start();
            }
            return 1;
        }));
    }

    private static void initBlockClient(RegisterClientExtensionsEvent event) {
        event.registerBlock((IClientBlockExtensions)BlockTileRenderProperties.INSTANCE, new Holder[]{LittleTilesRegistry.BLOCK_TILES, LittleTilesRegistry.BLOCK_TILES_RENDERED, LittleTilesRegistry.BLOCK_TILES_TICKING, LittleTilesRegistry.BLOCK_TILES_TICKING_RENDERED});
    }

    public static class LittleKeyMapping
    extends KeyMapping {
        private boolean ignoreModifier = false;

        public LittleKeyMapping(String description, IKeyConflictContext keyConflictContext, int keyCode, String category) {
            super(description, keyConflictContext, KeyModifier.NONE, InputConstants.Type.KEYSYM, keyCode, category);
        }

        public LittleKeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode, String category) {
            super(description, keyConflictContext, keyModifier, InputConstants.Type.KEYSYM, keyCode, category);
        }

        public LittleKeyMapping ignoreModifier() {
            this.ignoreModifier = true;
            return this;
        }

        public boolean isActiveAndMatches(InputConstants.Key keyCode) {
            if (this.ignoreModifier) {
                return keyCode != InputConstants.UNKNOWN && keyCode.equals((Object)this.getKey());
            }
            return super.isActiveAndMatches(keyCode);
        }

        public boolean same(KeyMapping other) {
            return other instanceof LittleKeyMapping && super.same(other);
        }
    }
}

