/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.action;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.ActionEvent;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.level.handler.LevelHandler;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;

@OnlyIn(value=Dist.CLIENT)
public class LittleActionHandlerClient
extends LevelHandler {
    private static final Minecraft mc = Minecraft.getInstance();
    public final PlacementPlayerSetting setting = new PlacementPlayerSetting();
    private List<LittleAction> lastActions = new ArrayList<LittleAction>();
    private int index = 0;

    public static boolean canUseUndoOrRedo() {
        GameType type = PlayerUtils.getGameType((Player)LittleActionHandlerClient.mc.player);
        return type == GameType.CREATIVE || type == GameType.SURVIVAL;
    }

    public static boolean isUsingSecondMode() {
        if (LittleActionHandlerClient.mc.player == null) {
            return false;
        }
        if (LittleTiles.CONFIG.building.useALTForEverything) {
            return Screen.hasAltDown();
        }
        if (LittleTiles.CONFIG.building.useAltWhenFlying) {
            return LittleActionHandlerClient.mc.player.getAbilities().flying ? Screen.hasAltDown() : LittleActionHandlerClient.mc.player.isCrouching();
        }
        return LittleActionHandlerClient.mc.player.isCrouching();
    }

    public static void handleException(LittleActionException e) {
        if (e.isHidden()) {
            return;
        }
        List<Component> message = e.getActionMessage();
        if (message != null) {
            LittleTilesClient.displayActionMessage(message);
        } else {
            LittleActionHandlerClient.mc.player.sendSystemMessage((Component)Component.literal((String)e.getLocalizedMessage()));
        }
    }

    public LittleActionHandlerClient(Level level) {
        super(level);
    }

    protected void rememberAction(LittleAction action) {
        if (!action.canBeReverted()) {
            return;
        }
        if (this.index > 0) {
            this.lastActions = this.index < this.lastActions.size() ? this.lastActions.subList(this.index, this.lastActions.size()) : new ArrayList<LittleAction>();
        }
        this.index = 0;
        if (this.lastActions.size() == LittleTiles.CONFIG.building.maxSavedActions) {
            this.lastActions.remove(LittleTiles.CONFIG.building.maxSavedActions - 1);
        }
        this.lastActions.add(0, action);
    }

    public <T> T execute(LittleAction<T> action) {
        LocalPlayer player = Minecraft.getInstance().player;
        try {
            T result = action.action((Player)player);
            if (action.wasSuccessful(result)) {
                this.rememberAction(action);
                NeoForge.EVENT_BUS.post((Event)new ActionEvent(action, ActionEvent.ActionType.NORMAL, (Player)player));
                LittleTiles.NETWORK.sendToServer(action);
            }
            return result;
        }
        catch (LittleActionException e) {
            LittleActionHandlerClient.handleException(e);
            return action.failed();
        }
    }

    public boolean undo() throws LittleActionException {
        if (this.lastActions.size() > this.index) {
            LocalPlayer player = LittleActionHandlerClient.mc.player;
            if (!LittleActionHandlerClient.canUseUndoOrRedo()) {
                return false;
            }
            LittleAction reverted = this.lastActions.get(this.index).revert((Player)player);
            if (reverted == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            if (reverted.wasSuccessful(reverted.action((Player)player))) {
                NeoForge.EVENT_BUS.post((Event)new ActionEvent(reverted, ActionEvent.ActionType.UNDO, (Player)player));
                LittleTiles.NETWORK.sendToServer((CreativePacket)reverted);
                this.lastActions.set(this.index, reverted);
                ++this.index;
                return true;
            }
        }
        return false;
    }

    public boolean redo() throws LittleActionException {
        if (this.index > 0 && this.index <= this.lastActions.size()) {
            LocalPlayer player = LittleActionHandlerClient.mc.player;
            if (!LittleActionHandlerClient.canUseUndoOrRedo()) {
                return false;
            }
            --this.index;
            LittleAction reverted = this.lastActions.get(this.index).revert((Player)player);
            if (reverted == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            if (reverted.wasSuccessful(reverted.action((Player)player))) {
                NeoForge.EVENT_BUS.post((Event)new ActionEvent(reverted, ActionEvent.ActionType.REDO, (Player)player));
                LittleTiles.NETWORK.sendToServer((CreativePacket)reverted);
                this.lastActions.set(this.index, reverted);
                return true;
            }
        }
        return false;
    }

    @Override
    public void unload() {
        this.lastActions.clear();
        this.index = 0;
    }
}

