/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.level.little;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.level.little.LittleAnimationLevelCallback;

public class LittleAnimationLevelClientCallback
extends LittleAnimationLevelCallback {
    public LittleAnimationLevelClientCallback(LittleAnimationLevel level) {
        super(level);
    }

    public void onCreated(Entity entity) {
    }

    public void onDestroyed(Entity entity) {
    }

    @Override
    public void onTickingStart(Entity entity) {
        this.tickingEntities.add(entity);
    }

    @Override
    public void onTickingEnd(Entity entity) {
        this.tickingEntities.remove(entity);
    }

    public void onTrackingStart(Entity entity) {
    }

    public void onTrackingEnd(Entity entity) {
        entity.unRide();
        entity.onRemovedFromLevel();
        NeoForge.EVENT_BUS.post((Event)new EntityLeaveLevelEvent(entity, (Level)this.level));
    }

    @Override
    public void addTrackingPlayer(ServerPlayer player) {
    }

    @Override
    public void removeTrackingPlayer(ServerPlayer player) {
    }

    @Override
    public void tickEntity(Entity entity) {
        if (!entity.isRemoved() && !entity.isPassenger()) {
            this.level.guardEntityTick(this::tickNonPassenger, entity);
        }
    }

    public void tickNonPassenger(Entity entity) {
        entity.setOldPosAndRot();
        ++entity.tickCount;
        if (!EventHooks.fireEntityTickPre((Entity)entity).isCanceled()) {
            entity.tick();
            EventHooks.fireEntityTickPost((Entity)entity);
        }
        for (Entity passenger : entity.getPassengers()) {
            this.tickPassenger(entity, passenger);
        }
    }

    private void tickPassenger(Entity vehicle, Entity entity) {
        if (!entity.isRemoved() && entity.getVehicle() == vehicle) {
            if (entity instanceof Player || this.tickingEntities.contains(entity)) {
                entity.setOldPosAndRot();
                ++entity.tickCount;
                entity.rideTick();
                for (Entity passenger : entity.getPassengers()) {
                    this.tickPassenger(entity, passenger);
                }
            }
        } else {
            entity.stopRiding();
        }
    }
}

