/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium;

import javax.annotation.Nullable;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.LocalSectionIndex;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.mod.sodium.SodiumManager;
import team.creative.littletiles.client.mod.sodium.entity.LittleAnimationRenderManagerSodium;
import team.creative.littletiles.client.mod.sodium.pipeline.LittleRenderPipelineSodium;
import team.creative.littletiles.client.mod.sodium.pipeline.LittleRenderPipelineTypeSodium;
import team.creative.littletiles.client.render.cache.build.RenderingLevelHandler;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.level.little.LittleLevel;

public class SodiumInteractor {
    public static final LittleRenderPipelineTypeSodium PIPELINE = new LittleRenderPipelineTypeSodium();
    private static final int POSITION_MAX_VALUE = 0x100000;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;

    public static void init() {
        LittleTiles.LOGGER.info("Loaded Sodium extension");
        SodiumManager.RENDERING_LEVEL = new RenderingLevelHandler(){

            @Override
            public LittleRenderPipelineType getPipeline() {
                return PIPELINE;
            }

            @Override
            public RenderChunkExtender getRenderChunk(Level level, long pos) {
                return LittleRenderPipelineSodium.getChunk(pos);
            }

            @Override
            public int sectionIndex(Level level, long pos) {
                int rX = SectionPos.x((long)pos) & 7;
                int rY = SectionPos.y((long)pos) & 3;
                int rZ = SectionPos.z((long)pos) & 7;
                return LocalSectionIndex.pack((int)rX, (int)rY, (int)rZ);
            }

            @Override
            public BlockPos standardOffset(Level level, SectionPos pos) {
                return pos.origin();
            }
        };
        SodiumManager.RENDERING_ANIMATION = new RenderingLevelHandler(){

            @Override
            public LittleRenderPipelineType getPipeline() {
                return PIPELINE;
            }

            @Override
            public void prepareModelOffset(Level level, BlockPos.MutableBlockPos modelOffset, BlockPos pos) {
                BlockPos chunkOffset = ((LittleAnimationEntity)((LittleLevel)level).getHolder()).getCenter().chunkOrigin;
                modelOffset.set(pos.getX() - chunkOffset.getX(), pos.getY() - chunkOffset.getY(), pos.getZ() - chunkOffset.getZ());
            }

            @Override
            public RenderChunkExtender getRenderChunk(Level level, long pos) {
                return ((LittleLevel)level).getRenderManager().getRenderChunk(pos);
            }

            @Override
            public int sectionIndex(Level level, long pos) {
                int rX = SectionPos.x((long)pos) & 7;
                int rY = SectionPos.y((long)pos) & 3;
                int rZ = SectionPos.z((long)pos) & 7;
                return LocalSectionIndex.pack((int)rX, (int)rY, (int)rZ);
            }

            @Override
            public long sectionPos(BETiles be) {
                return ((LittleAnimationEntity)((LittleLevel)be.getLevel()).getHolder()).getCenter().chunkOffset.asLong();
            }

            @Override
            public BlockPos standardOffset(Level level, SectionPos pos) {
                return ((LittleAnimationEntity)((LittleLevel)level).getHolder()).getCenter().chunkOrigin;
            }

            @Override
            public long prepareQueue(long pos) {
                return 0L;
            }
        };
    }

    public static LittleEntityRenderManager createRenderManager(LittleAnimationEntity entity) {
        return new LittleAnimationRenderManagerSodium(entity);
    }

    public static float unpackPositionX(int hi, int lo) {
        return SodiumInteractor.unquantizePosition((hi >> 0 & 0x3FF) << 10 | lo >> 0 & 0x3FF);
    }

    public static float unpackPositionY(int hi, int lo) {
        return SodiumInteractor.unquantizePosition((hi >> 10 & 0x3FF) << 10 | lo >> 10 & 0x3FF);
    }

    public static float unpackPositionZ(int hi, int lo) {
        return SodiumInteractor.unquantizePosition((hi >> 20 & 0x3FF) << 10 | lo >> 20 & 0x3FF);
    }

    public static int packPositionHi(int x, int y, int z) {
        return (x >>> 10 & 0x3FF) << 0 | (y >>> 10 & 0x3FF) << 10 | (z >>> 10 & 0x3FF) << 20;
    }

    public static int packPositionLo(int x, int y, int z) {
        return (x & 0x3FF) << 0 | (y & 0x3FF) << 10 | (z & 0x3FF) << 20;
    }

    public static float unquantizePosition(int position) {
        return SodiumInteractor.unnormalizePosition((float)(position & 0xFFFFF) / 1048576.0f);
    }

    public static int quantizePosition(float position) {
        return (int)(SodiumInteractor.normalizePosition(position) * 1048576.0f) & 0xFFFFF;
    }

    public static float unnormalizePosition(float v) {
        return v * 32.0f - 8.0f;
    }

    public static float normalizePosition(float v) {
        return (8.0f + v) / 32.0f;
    }

    @Nullable
    public static Direction toDirection(ModelQuadFacing facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case ModelQuadFacing.NEG_X -> Direction.WEST;
            case ModelQuadFacing.NEG_Y -> Direction.DOWN;
            case ModelQuadFacing.NEG_Z -> Direction.NORTH;
            case ModelQuadFacing.POS_X -> Direction.EAST;
            case ModelQuadFacing.POS_Y -> Direction.UP;
            case ModelQuadFacing.POS_Z -> Direction.SOUTH;
            case ModelQuadFacing.UNASSIGNED -> null;
        };
    }
}

