/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.system.MemoryUtil;
import team.creative.creativecore.common.util.type.itr.FunctionNonNullIterator;
import team.creative.littletiles.client.mod.sodium.SodiumInteractor;
import team.creative.littletiles.client.mod.sodium.buffer.SodiumBufferUploader;
import team.creative.littletiles.client.mod.sodium.data.LittleQuadView;
import team.creative.littletiles.client.mod.sodium.pipeline.LittleRenderPipelineSodium;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;

public class SodiumBufferCache
implements BufferCache {
    private final BufferHolder[] buffers;
    private List<TextureAtlasSprite> textures;
    private boolean invalid;

    public SodiumBufferCache(BufferHolder[] buffers, List<TextureAtlasSprite> textures) {
        this.buffers = buffers;
        this.textures = textures;
    }

    public BufferHolder buffer(ModelQuadFacing facing) {
        return this.buffers[facing.ordinal()];
    }

    public List<TextureAtlasSprite> getUsedTextures() {
        return this.textures;
    }

    @Override
    public BufferCache extract(int index) {
        BufferHolder[] buffers = new BufferHolder[ModelQuadFacing.COUNT];
        boolean found = false;
        for (int i = 0; i < buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            buffers[i] = this.buffers[i].extract(index);
            if (this.buffers[i].isEmpty()) {
                this.buffers[i] = null;
            }
            if (buffers[i] == null) continue;
            found = true;
        }
        if (found) {
            return new SodiumBufferCache(buffers, this.textures);
        }
        return null;
    }

    @Override
    public BufferCache extract(int[] toExtract) {
        BufferHolder[] buffers = new BufferHolder[ModelQuadFacing.COUNT];
        boolean found = false;
        for (int i = 0; i < buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            buffers[i] = this.buffers[i].extract(toExtract);
            if (this.buffers[i].isEmpty()) {
                this.buffers[i] = null;
            }
            if (buffers[i] == null) continue;
            found = true;
        }
        if (found) {
            return new SodiumBufferCache(buffers, this.textures);
        }
        return null;
    }

    @Override
    public BufferCache copy() {
        BufferHolder[] buffers = new BufferHolder[ModelQuadFacing.COUNT];
        for (int i = 0; i < buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            buffers[i] = this.buffers[i].copy();
        }
        return new SodiumBufferCache(buffers, new ArrayList<TextureAtlasSprite>(this.textures));
    }

    @Override
    public BufferCache combine(Iterator<BufferCache> itr) {
        ArrayList<SodiumBufferCache> list = new ArrayList<SodiumBufferCache>();
        ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
        while (itr.hasNext()) {
            SodiumBufferCache b = (SodiumBufferCache)itr.next();
            for (TextureAtlasSprite texture : b.getUsedTextures()) {
                if (sprites.contains(texture)) continue;
                sprites.add(texture);
            }
            list.add(b);
        }
        BufferHolder[] buffers = new BufferHolder[ModelQuadFacing.COUNT];
        for (int i = 0; i < buffers.length; ++i) {
            int index = i;
            buffers[i] = (BufferHolder)BufferCache.combineOrCopy(this.buffers[i], (Iterable<BufferCache>)new FunctionNonNullIterator(list, x -> x.buffers[index]));
        }
        return new SodiumBufferCache(buffers, sprites);
    }

    private void applySodiumOffset(ByteBuffer buffer, Vec3 vec) {
        if (buffer == null) {
            return;
        }
        long ptr = MemoryUtil.memAddress((ByteBuffer)buffer);
        for (int i = 0; i < buffer.limit(); i += 20) {
            int hi = MemoryUtil.memGetInt((long)(ptr + 0L));
            int lo = MemoryUtil.memGetInt((long)(ptr + 4L));
            float x = SodiumInteractor.unpackPositionX(hi, lo) + (float)vec.x;
            float y = SodiumInteractor.unpackPositionY(hi, lo) + (float)vec.y;
            float z = SodiumInteractor.unpackPositionZ(hi, lo) + (float)vec.z;
            int quantX = SodiumInteractor.quantizePosition(x);
            int quantY = SodiumInteractor.quantizePosition(y);
            int quantZ = SodiumInteractor.quantizePosition(z);
            MemoryUtil.memPutInt((long)(ptr + 0L), (int)SodiumInteractor.packPositionHi(quantX, quantY, quantZ));
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)SodiumInteractor.packPositionLo(quantX, quantY, quantZ));
            ptr += 20L;
        }
    }

    @Override
    public void applyOffset(Vec3 vec) {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            this.applySodiumOffset(this.buffers[i].byteBuffer(), vec);
        }
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    @Override
    public boolean isAvailable() {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i].isAvailable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int lengthToUpload() {
        int length = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || !this.buffers[i].isAvailable()) continue;
            length += this.buffers[i].lengthToUpload();
        }
        return length;
    }

    @Override
    public int lengthToUpload(int facing) {
        if (this.buffers[facing] != null && this.buffers[facing].isAvailable()) {
            return this.buffers[facing].lengthToUpload();
        }
        return 0;
    }

    @Override
    public void eraseBuffer() {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            this.buffers[i].eraseBuffer();
        }
    }

    @Override
    public boolean upload(ChunkBufferUploader uploader) {
        for (TextureAtlasSprite texture : this.textures) {
            uploader.addTexture(texture);
        }
        if (uploader.hasFacingSupport()) {
            SodiumBufferUploader u;
            if (uploader instanceof SodiumBufferUploader && (u = (SodiumBufferUploader)uploader).isSorted()) {
                ChunkVertexType type = LittleRenderPipelineSodium.getType();
                int stride = type.getVertexFormat().getStride();
                LittleQuadView quad = new LittleQuadView();
                for (int i = 0; i < this.buffers.length; ++i) {
                    long ptr;
                    if (this.buffers[i] == null) continue;
                    if (!this.buffers[i].upload(i, uploader)) {
                        return false;
                    }
                    ModelQuadFacing facing = ModelQuadFacing.values()[i];
                    ByteBuffer buffer = this.buffers[i].byteBuffer();
                    long end = ptr + (long)buffer.remaining();
                    TranslucentGeometryCollector collector = u.getTranslucentCollector();
                    for (ptr = MemoryUtil.memAddress((ByteBuffer)buffer); ptr < end; ptr += (long)(stride * 4)) {
                        quad.readVertices(ptr, 0, stride, facing);
                        collector.appendQuad(quad.getPackedNormal(), quad.getVertices(), facing);
                    }
                }
                return true;
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null || this.buffers[i].upload(i, uploader)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i].upload(uploader)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean download(ChunkBufferDownloader downloader) {
        if (downloader.hasFacingSupport()) {
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null || this.buffers[i].download(downloader.downloaded(i))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i].download(downloader.downloaded())) continue;
            return false;
        }
        return true;
    }

    public void moveInBuffer(int offset) {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            this.buffers[i].moveUploadIndex(offset);
        }
    }

    public String toString() {
        return Arrays.toString(this.buffers);
    }
}

