/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.mod.sodium.buffer.RenderedBufferSodium;
import team.creative.littletiles.client.mod.sodium.renderer.DefaultChunkRendererExtender;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.entity.LittleAnimationRenderManager;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;

@OnlyIn(value=Dist.CLIENT)
public class LittleAnimationRenderManagerSodium
extends LittleAnimationRenderManager {
    private GlVertexAttributeBinding[] vertexAttributeBindings;
    private GlVertexFormat format;

    public LittleAnimationRenderManagerSodium(LittleAnimationEntity entity) {
        super(entity);
    }

    public void prepare(GlVertexAttributeBinding[] vertexAttributeBindings, GlVertexFormat format) {
        this.vertexAttributeBindings = vertexAttributeBindings;
        this.format = format;
    }

    @Override
    public void compileSections(Camera camera) {
        if (!this.needsUpdate || this.vertexAttributeBindings == null) {
            return;
        }
        this.needsUpdate = false;
        this.hasBlocks.clear();
        this.renderableBlockEntities.clear();
        RebuildTask rebuild = new RebuildTask();
        Vec3 cam = camera.getPosition();
        CompileResults results = rebuild.compile((float)cam.x, (float)cam.y, (float)cam.z);
        this.globalBlockEntities.clear();
        this.globalBlockEntities.addAll(results.globalBlockEntities);
        this.renderableBlockEntities = results.blockEntities;
        this.prepareUpload();
        for (Tuple entry : results.buffers.tuples()) {
            VertexBuffer buffer = this.getVertexBuffer((RenderType)entry.key);
            if (!buffer.isInvalid() && buffer instanceof VertexBufferExtender) {
                VertexBufferExtender ex = (VertexBufferExtender)buffer;
                buffer.bind();
                ex.setFormat(null);
                int length = ((RenderedBufferSodium)entry.value).byteBuffer().limit();
                this.uploadVertexBuffer(ex, ((RenderedBufferSodium)entry.value).byteBuffer());
                ex.setMode(VertexFormat.Mode.QUADS);
                ex.setIndexCount(ex.getMode().indexCount(length / this.format.getStride()));
                ex.setSequentialIndices(this.uploadIndexBuffer(ex));
                ex.setIndexType(VertexFormat.IndexType.INT);
                ex.setLastUploadedLength(length);
                BufferCollection buffers = rebuild.getBuffers((RenderType)entry.key);
                if (buffers != null) {
                    this.uploaded((RenderType)entry.key, buffers);
                }
                try {
                    ((RenderedBufferSodium)entry.value).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.hasBlocks.add((RenderType)entry.key);
                continue;
            }
            LittleTiles.LOGGER.error("Could not upload chunk render data due to invalid buffer");
        }
        VertexBuffer.unbind();
    }

    @Nullable
    private RenderSystem.AutoStorageIndexBuffer uploadIndexBuffer(VertexBufferExtender ex) {
        RenderSystem.AutoStorageIndexBuffer buffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)ex.getMode());
        if (buffer != ex.getSequentialIndices() || !buffer.hasStorage(ex.getIndexCount())) {
            buffer.bind(ex.getIndexCount());
        }
        return buffer;
    }

    private void uploadVertexBuffer(VertexBufferExtender buffer, ByteBuffer byteBuffer) {
        GlStateManager._glBindBuffer((int)34962, (int)buffer.getVertexBufferId());
        for (GlVertexAttributeBinding attrib : this.vertexAttributeBindings) {
            if (attrib.isIntType()) {
                GL30C.glVertexAttribIPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat(), (int)attrib.getStride(), (long)attrib.getPointer());
            } else {
                GL20C.glVertexAttribPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat(), (boolean)attrib.isNormalized(), (int)attrib.getStride(), (long)attrib.getPointer());
            }
            GL20C.glEnableVertexAttribArray((int)attrib.getIndex());
        }
        RenderSystem.glBufferData((int)34962, (ByteBuffer)byteBuffer, (int)35044);
    }

    @Override
    public boolean isSmall() {
        return true;
    }

    public void renderChunkLayerSodium(RenderType layer, PoseStack pose, double camx, double camy, double camz, Matrix4fc projectionMatrix, ChunkShaderInterface shader, CameraTransform camera) {
        if (this.hasBlocks.contains(layer)) {
            VertexBuffer vertexbuffer = (VertexBuffer)this.buffers.get(layer);
            if (vertexbuffer == null) {
                return;
            }
            DefaultChunkRendererExtender.setRenderRegionOffset(shader, ((LittleAnimationEntity)this.entity).getCenter().chunkOrigin, camera);
            vertexbuffer.bind();
            vertexbuffer.draw();
        }
    }

    @Override
    public MeshData.SortState getTransparencyState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertexSorting createVertexSorting(double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resortTransparency(RenderType layer, double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    private class RebuildTask {
        private ChunkLayerMap<BufferCollection> caches;

        private RebuildTask() {
        }

        private CompileResults compile(float x, float y, float z) {
            CompileResults results = new CompileResults();
            LittleRenderPipelineType.startCompile(LittleAnimationRenderManagerSodium.this);
            for (BETiles block : LittleAnimationRenderManagerSodium.this.getLevel()) {
                this.handleBlockEntity(results, block);
            }
            if (this.caches != null) {
                for (Tuple layer : this.caches.tuples()) {
                    results.buffers.put((RenderType)layer.key, (Object)new RenderedBufferSodium((BufferCollection)layer.value));
                }
            }
            LittleRenderPipelineType.endCompile(LittleAnimationRenderManagerSodium.this);
            return results;
        }

        private void handleBlockEntity(CompileResults results, BETiles entity) {
            LittleRenderPipelineType.compileUploaded(((LittleAnimationEntity)LittleAnimationRenderManagerSodium.this.entity).getCenter().chunkOffset.asLong(), entity, x -> this.getOrCreateBuffers((RenderType)x));
            BlockEntityRenderer blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)entity);
            if (blockentityrenderer != null) {
                if (blockentityrenderer.shouldRenderOffScreen((BlockEntity)entity)) {
                    results.globalBlockEntities.add((BlockEntity)entity);
                } else {
                    results.blockEntities.add((BlockEntity)entity);
                }
            }
        }

        public BufferCollection getBuffers(RenderType layer) {
            if (this.caches == null) {
                return null;
            }
            return (BufferCollection)this.caches.get(layer);
        }

        public BufferCollection getOrCreateBuffers(RenderType layer) {
            BufferCollection cache;
            if (this.caches == null) {
                this.caches = new ChunkLayerMap();
            }
            if ((cache = (BufferCollection)this.caches.get(layer)) == null) {
                cache = new BufferCollection();
                this.caches.put(layer, (Object)cache);
            }
            return cache;
        }
    }

    static final class CompileResults {
        public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final ChunkLayerMap<RenderedBufferSodium> buffers = new ChunkLayerMap();

        CompileResults() {
        }

        public boolean isEmpty() {
            return this.buffers.isEmpty() && this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty();
        }
    }
}

