/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.pipeline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.color.ColorProviderRegistry;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.LightDataAccess;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.render.frapi.SodiumRenderer;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AmbientOcclusionMode;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.lwjgl.system.MemoryUtil;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.common.util.type.map.ChunkLayerMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.client.IFakeRenderingBlock;
import team.creative.littletiles.client.mod.iris.IrisManager;
import team.creative.littletiles.client.mod.sodium.SodiumInteractor;
import team.creative.littletiles.client.mod.sodium.buffer.SodiumBufferCache;
import team.creative.littletiles.client.mod.sodium.data.ChunkLayerMapSodium;
import team.creative.littletiles.client.mod.sodium.level.LittleLevelSliceExtender;
import team.creative.littletiles.client.mod.sodium.pipeline.LittleLightDataAccess;
import team.creative.littletiles.client.mod.sodium.renderer.BlockRendererExtender;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipeline;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.mixin.sodium.BlockRenderContextAccessor;
import team.creative.littletiles.mixin.sodium.ChunkBuildBuffersAccessor;
import team.creative.littletiles.mixin.sodium.ChunkBuilderAccessor;
import team.creative.littletiles.mixin.sodium.ChunkMeshBufferBuilderAccessor;
import team.creative.littletiles.mixin.sodium.RenderSectionManagerAccessor;
import team.creative.littletiles.mixin.sodium.SodiumWorldRendererAccessor;
import team.creative.littletiles.mixin.sodium.TerrainRenderPassAccessor;

public class LittleRenderPipelineSodium
extends LittleRenderPipeline {
    private static final RenderMaterial[] STANDARD_MATERIALS;
    private static final RenderMaterial TRANSLUCENT_MATERIAL;
    private ChunkBuildBuffers buildBuffers;
    private ChunkVertexType type;
    private final LevelSlice slice = LittleLevelSliceExtender.create();
    private BlockRenderer renderer;
    private LittleLightDataAccess lightAccess;
    private LightPipelineProvider lighters;
    private QuadLightData cachedQuadLightData = new QuadLightData();
    public BlockRenderContext context = new BlockRenderContext(this.slice, null);
    private Set<TextureAtlasSprite> sprites = new ObjectOpenHashSet();
    private BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();
    private ChunkLayerMapSodium<IntArrayList[]> indexes = new ChunkLayerMapSodium<IntArrayList[]>(x -> {
        IntArrayList[] index = new IntArrayList[ModelQuadFacing.COUNT];
        for (int i = 0; i < index.length; ++i) {
            index[i] = new IntArrayList();
        }
        return index;
    });
    private BlockPos.MutableBlockPos scratchColorPos = new BlockPos.MutableBlockPos();
    private int[] colors = new int[4];
    private Vec3d cubeCenter = new Vec3d();

    public static RenderChunkExtender getChunk(long pos) {
        return (RenderChunkExtender)((RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager()).callGetRenderSection(SectionPos.x((long)pos), SectionPos.y((long)pos), SectionPos.z((long)pos));
    }

    public static ChunkVertexType getType() {
        return RenderingThread.getOrCreate(SodiumInteractor.PIPELINE).getVertexType();
    }

    @Override
    public void buildCache(PoseStack pose, ChunkLayerMap<BufferCache> buffers, RenderingBlockContext data, VertexFormat format, SingletonList<BakedQuad> bakedQuadWrapper) {
        LittleSubLevel sub;
        if (this.buildBuffers == null || this.renderer == null) {
            this.reload();
        }
        Level renderLevel = data.be.getLevel();
        while (renderLevel instanceof LittleSubLevel && !(sub = (LittleSubLevel)renderLevel).shouldUseLightingForRenderig()) {
            renderLevel = sub.getParent();
        }
        ((LittleLevelSliceExtender)this.slice).setLevel(renderLevel);
        ((BlockRenderContextAccessor)this.context).setSlice(this.slice);
        BlockPos pos = data.be.getBlockPos();
        this.lightAccess.prepare((BlockAndTintGetter)renderLevel);
        this.renderer.prepare(this.buildBuffers, this.slice, null);
        LightPipeline lighter = this.lighters.getLighter(Minecraft.useAmbientOcclusion() && data.state.getLightEmission((BlockGetter)data.be.getLevel(), pos) == 0 ? LightMode.SMOOTH : LightMode.FLAT);
        ColorProviderRegistry colorProvider = ((BlockRendererExtender)this.renderer).colorRegistry();
        data.prepareModelOffset(this.modelOffset, pos);
        ((BlockRendererExtender)this.renderer).setOffset((BlockPos)this.modelOffset);
        MutableQuadViewImpl editorQuad = ((BlockRendererExtender)this.renderer).getEditorQuadAndClear();
        for (TerrainRenderPass terrainRenderPass : DefaultTerrainRenderPasses.ALL) {
            ChunkModelBuilder layerBuilder = this.buildBuffers.get(terrainRenderPass);
            for (int i = 0; i < ModelQuadFacing.VALUES.length; ++i) {
                layerBuilder.getVertexBuffer(ModelQuadFacing.VALUES[i]).start(data.sectionIndex());
            }
        }
        for (Int2ObjectMap.Entry entry : data.be.render.cachedBoxes().int2ObjectEntrySet()) {
            ChunkLayerMapList structureMap = (ChunkLayerMapList)entry.getValue();
            if (structureMap == null || structureMap.isEmpty()) continue;
            for (Tuple tuple : structureMap.tuples()) {
                List cubes = (List)tuple.value;
                if (cubes.isEmpty()) continue;
                Material material = DefaultMaterials.forRenderLayer((RenderType)((RenderType)tuple.key));
                for (LittleRenderBox cube : cubes) {
                    BlockState state = cube.state;
                    this.context.update(pos, (BlockPos)this.modelOffset, state, null, 0L);
                    this.cubeCenter.set((double)(cube.maxX + cube.minX) * 0.5, (double)(cube.maxY + cube.minY) * 0.5, (double)(cube.maxZ + cube.minZ) * 0.5);
                    ColorProvider colorizer = null;
                    if (IrisManager.isShaders()) {
                        Block block = state.getBlock();
                        if (block instanceof IFakeRenderingBlock) {
                            IFakeRenderingBlock fake = (IFakeRenderingBlock)block;
                            state = fake.getFakeState(state);
                        }
                        IrisManager.beginBlock(this.buildBuffers, state, pos);
                    }
                    for (int h = 0; h < Facing.VALUES.length; ++h) {
                        Facing facing = Facing.VALUES[h];
                        Object quadObject = cube.getQuad(facing);
                        SingletonList<BakedQuad> quads = null;
                        if (quadObject instanceof List) {
                            SingletonList<BakedQuad> q;
                            quads = q = (SingletonList<BakedQuad>)quadObject;
                        } else if (quadObject instanceof BakedQuad) {
                            BakedQuad quad = (BakedQuad)quadObject;
                            bakedQuadWrapper.setElement((Object)quad);
                            quads = bakedQuadWrapper;
                        }
                        if (quads == null || quads.isEmpty()) continue;
                        Direction direction = facing.toVanilla();
                        for (BakedQuad quad : quads) {
                            int i;
                            editorQuad.fromVanilla(quad, tuple.key == RenderType.tripwire() || tuple.key == RenderType.translucent() ? TRANSLUCENT_MATERIAL : STANDARD_MATERIALS[AmbientOcclusionMode.DEFAULT.ordinal()], direction);
                            RenderMaterialImpl mat = editorQuad.material();
                            boolean hasColor = false;
                            if (cube.color != -1) {
                                int color = ColorARGB.pack((int)ColorUtils.red((int)cube.color), (int)ColorUtils.green((int)cube.color), (int)ColorUtils.blue((int)cube.color), (int)ColorUtils.alpha((int)cube.color));
                                Arrays.fill(this.colors, color);
                                hasColor = true;
                            } else if (!mat.disableColorIndex() && editorQuad.hasColor()) {
                                if (colorizer == null) {
                                    colorizer = colorProvider.getColorProvider(state.getBlock());
                                }
                                colorizer.getColors(this.slice, pos, this.scratchColorPos, (Object)state, (ModelQuadView)editorQuad, this.colors);
                                hasColor = true;
                            } else {
                                Arrays.fill(this.colors, -1);
                            }
                            if (hasColor) {
                                for (i = 0; i < 4; ++i) {
                                    editorQuad.color(i, ColorMixer.mulComponentWise((int)this.colors[i], (int)editorQuad.color(i)));
                                }
                            }
                            lighter.calculate((ModelQuadView)editorQuad, pos, this.cachedQuadLightData, editorQuad.cullFace(), editorQuad.lightFace(), editorQuad.hasShade(), mat.shadeMode() == ShadeMode.ENHANCED);
                            if (mat.emissive()) {
                                for (i = 0; i < 4; ++i) {
                                    editorQuad.lightmap(i, 0xF000F0);
                                }
                            } else {
                                for (i = 0; i < 4; ++i) {
                                    editorQuad.lightmap(i, ColorHelper.maxBrightness((int)editorQuad.lightmap(i), (int)this.cachedQuadLightData.lm[i]));
                                }
                            }
                            ((BlockRendererExtender)this.renderer).callBufferQuad(editorQuad, this.cachedQuadLightData.br, material);
                            TextureAtlasSprite sprite = editorQuad.cachedSprite();
                            if (sprite != null && SpriteUtil.hasAnimation((TextureAtlasSprite)sprite)) {
                                this.sprites.add(sprite);
                            }
                            editorQuad.clear();
                        }
                    }
                    bakedQuadWrapper.setElement(null);
                    IrisManager.resetBlockContext(this.buildBuffers);
                    if (LittleTiles.CONFIG.rendering.useQuadCache) continue;
                    cube.deleteQuadCache();
                }
            }
            for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
                ChunkModelBuilder builder = this.buildBuffers.get(pass);
                if (builder == null) continue;
                IntArrayList[] indexArray = this.indexes.get(pass);
                for (int i = 0; i < indexArray.length; ++i) {
                    ChunkMeshBufferBuilderAccessor a = (ChunkMeshBufferBuilderAccessor)builder.getVertexBuffer(ModelQuadFacing.VALUES[i]);
                    int index = a.getVertexCount() * a.getStride();
                    if (index == 0 || indexArray[i].size() > 0 && indexArray[i].getInt(indexArray[i].size() - 1) == index) continue;
                    indexArray[i].add(entry.getIntKey());
                    indexArray[i].add(index);
                }
            }
        }
        for (TerrainRenderPass terrainRenderPass : DefaultTerrainRenderPasses.ALL) {
            ChunkModelBuilder builder = this.buildBuffers.get(terrainRenderPass);
            if (builder == null) continue;
            IntArrayList[] indexArray = this.indexes.get(terrainRenderPass);
            BufferHolder[] holders = new BufferHolder[ModelQuadFacing.COUNT];
            boolean hasData = false;
            if (terrainRenderPass.isTranslucent()) {
                IntArrayList newIndexes = new IntArrayList();
                int size = 0;
                int vertexCount = 0;
                for (int i = 0; i < indexArray.length; ++i) {
                    ChunkMeshBufferBuilderAccessor v = (ChunkMeshBufferBuilderAccessor)builder.getVertexBuffer(ModelQuadFacing.VALUES[i]);
                    int bufferSize = v.getStride() * v.getVertexCount();
                    for (int j = 0; j < indexArray[i].size(); j += 2) {
                        int start = j == 0 ? 0 : indexArray[i].getInt(j - 1);
                        int next = indexArray[i].getInt(j + 1);
                        this.addIndexGroup((IntList)newIndexes, indexArray[i].getInt(j), next - start);
                    }
                    size += bufferSize;
                    vertexCount += v.getVertexCount();
                }
                boolean bl = hasData = size > 0;
                if (hasData) {
                    int i;
                    ByteBuffer buffer = ByteBuffer.allocateDirect(size);
                    Int2ObjectArrayMap bufferMap = new Int2ObjectArrayMap();
                    int[] correctIndexes = new int[newIndexes.size()];
                    int current = 0;
                    for (i = 0; i < newIndexes.size(); i += 2) {
                        int length = newIndexes.getInt(i + 1);
                        int index = newIndexes.getInt(i);
                        bufferMap.put(index, (Object)buffer.slice(current, length));
                        correctIndexes[i] = index;
                        correctIndexes[i + 1] = current + length;
                        current += length;
                    }
                    for (i = 0; i < indexArray.length; ++i) {
                        ChunkMeshBufferBuilderAccessor v = (ChunkMeshBufferBuilderAccessor)builder.getVertexBuffer(ModelQuadFacing.VALUES[i]);
                        ByteBuffer threadBuffer = v.getBuffer();
                        int threadIndex = 0;
                        for (int j = 0; j < indexArray[i].size(); j += 2) {
                            int start = j == 0 ? 0 : indexArray[i].getInt(j - 1);
                            int next = indexArray[i].getInt(j + 1);
                            int length = next - start;
                            if (length == 0) continue;
                            ByteBuffer b = (ByteBuffer)bufferMap.get(indexArray[i].getInt(j));
                            b.put(b.position(), threadBuffer, threadIndex, length);
                            b.position(b.position() + length);
                            threadIndex += length;
                        }
                        indexArray[i].clear();
                    }
                    holders[ModelQuadFacing.UNASSIGNED.ordinal()] = new BufferHolder(buffer, size, vertexCount, correctIndexes);
                }
            } else {
                for (int i = 0; i < indexArray.length; ++i) {
                    ChunkMeshBufferBuilderAccessor v = (ChunkMeshBufferBuilderAccessor)builder.getVertexBuffer(ModelQuadFacing.VALUES[i]);
                    if (v.getVertexCount() <= 0) continue;
                    ByteBuffer buffer = ByteBuffer.allocateDirect(v.getStride() * v.getVertexCount());
                    ByteBuffer threadBuffer = v.getBuffer();
                    threadBuffer.limit(buffer.capacity());
                    MemoryUtil.memCopy((ByteBuffer)threadBuffer, (ByteBuffer)buffer);
                    threadBuffer.limit(threadBuffer.capacity());
                    holders[i] = new BufferHolder(buffer, buffer.limit(), v.getVertexCount(), indexArray[i].toIntArray());
                    indexArray[i].clear();
                    hasData = true;
                }
            }
            if (hasData) {
                buffers.put(((TerrainRenderPassAccessor)terrainRenderPass).getRenderType(), (Object)new SodiumBufferCache(holders, new ArrayList<TextureAtlasSprite>(this.sprites)));
            }
            this.sprites.clear();
        }
        ((LittleLevelSliceExtender)this.slice).setLevel(null);
    }

    private void addIndexGroup(IntList list, int index, int count) {
        for (int i = 0; i < list.size(); i += 2) {
            if (list.getInt(i) != index) continue;
            list.set(i + 1, list.getInt(i + 1) + count);
            return;
        }
        list.add(index);
        list.add(count);
    }

    @Override
    public void reload() {
        RenderSectionManager manager = ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager();
        if (manager == null) {
            this.buildBuffers = null;
            this.renderer = null;
            return;
        }
        ChunkBuilderAccessor chunkBuilder = (ChunkBuilderAccessor)manager.getBuilder();
        this.type = ((ChunkBuildBuffersAccessor)chunkBuilder.getLocalContext().buffers).getVertexType();
        this.buildBuffers = new ChunkBuildBuffers(this.type);
        this.buildBuffers.init(null, 0);
        this.lightAccess = new LittleLightDataAccess();
        this.lighters = new LightPipelineProvider((LightDataAccess)this.lightAccess);
        this.renderer = new BlockRenderer(new ColorProviderRegistry(Minecraft.getInstance().getBlockColors()), this.lighters);
        ((BlockRendererExtender)this.renderer).markAsTakenOver();
    }

    public ChunkVertexType getVertexType() {
        if (this.type == null || this.type.getVertexFormat() == null) {
            this.reload();
        }
        return this.type;
    }

    @Override
    public void release() {
        this.buildBuffers.destroy();
    }

    static {
        TRANSLUCENT_MATERIAL = SodiumRenderer.INSTANCE.materialFinder().blendMode(BlendMode.TRANSLUCENT).find();
        STANDARD_MATERIALS = new RenderMaterial[AmbientOcclusionMode.values().length];
        AmbientOcclusionMode[] values = AmbientOcclusionMode.values();
        for (int i = 0; i < values.length; ++i) {
            TriState state = switch (values[i]) {
                case AmbientOcclusionMode.ENABLED -> TriState.TRUE;
                case AmbientOcclusionMode.DISABLED -> TriState.FALSE;
                case AmbientOcclusionMode.DEFAULT -> TriState.DEFAULT;
                default -> throw new MatchException(null, null);
            };
            LittleRenderPipelineSodium.STANDARD_MATERIALS[i] = SodiumRenderer.INSTANCE.materialFinder().ambientOcclusion(state).find();
        }
    }
}

