/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.renderer;

import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;

public interface DefaultChunkRendererExtender {
    public static final int REGION_WIDTH_M = 7;
    public static final int REGION_HEIGHT_M = 3;
    public static final int REGION_LENGTH_M = 7;
    public static final int REGION_WIDTH_SH = Integer.bitCount(7);
    public static final int REGION_HEIGHT_SH = Integer.bitCount(3);
    public static final int REGION_LENGTH_SH = Integer.bitCount(7);

    public void begin(RenderType var1);

    public void end(RenderType var1);

    public static void setRenderRegionOffset(ChunkShaderInterface shader, BlockPos pos, CameraTransform camera) {
        float x = DefaultChunkRendererExtender.getCameraTranslation(pos.getX() >> 4 >> REGION_WIDTH_SH << REGION_WIDTH_SH << 4, camera.intX, camera.fracX);
        float y = DefaultChunkRendererExtender.getCameraTranslation(pos.getY() >> 4 >> REGION_HEIGHT_SH << REGION_HEIGHT_SH << 4, camera.intY, camera.fracY);
        float z = DefaultChunkRendererExtender.getCameraTranslation(pos.getZ() >> 4 >> REGION_LENGTH_SH << REGION_LENGTH_SH << 4, camera.intZ, camera.fracZ);
        shader.setRegionOffset(x, y, z);
    }

    public static BlockPos regionOffset(BlockPos pos) {
        return new BlockPos(pos.getX() >> 4 >> REGION_WIDTH_SH << REGION_WIDTH_SH << 4, pos.getY() >> 4 >> REGION_HEIGHT_SH << REGION_HEIGHT_SH << 4, pos.getZ() >> 4 >> REGION_LENGTH_SH << REGION_LENGTH_SH << 4);
    }

    private static float getCameraTranslation(int chunkBlockPos, int cameraBlockPos, float cameraPos) {
        return (float)(chunkBlockPos - cameraBlockPos) - cameraPos;
    }
}

