/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.RenderType;
import team.creative.creativecore.common.util.type.itr.FunctionNonNullIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.littletiles.client.render.cache.AdditionalBufferReceiver;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;

public class AdditionalBuffers
implements AdditionalBufferReceiver {
    private final List<AdditionalBuffer> content = new ArrayList<AdditionalBuffer>();

    public void uploadAdditional(RenderType layer, ChunkBufferUploader uploader, BufferCollection collection) {
        for (AdditionalBuffer a : this.content) {
            BufferCache buffer = (BufferCache)a.buffers.get(layer);
            if (buffer == null) continue;
            LittleRenderPipelineType.upload(uploader, collection, buffer);
        }
    }

    public void markUploadedAdditional(RenderType layer, BufferCollection collection) {
        for (AdditionalBuffer a : this.content) {
            BufferCache buffer = (BufferCache)a.buffers.get(layer);
            if (buffer == null) continue;
            LittleRenderPipelineType.markUploaded(collection, buffer);
        }
    }

    public BufferCache getAdditional(BufferCache original, RenderType layer) {
        return BufferCache.combineOrCopy(original, (Iterable<BufferCache>)new FunctionNonNullIterator(this.content, x -> (BufferCache)x.buffers.get(layer)));
    }

    public boolean has(RenderType layer) {
        for (AdditionalBuffer b : this.content) {
            if (!b.buffers.containsKey(layer)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(UUID uuid) {
        for (int i = 0; i < this.content.size(); ++i) {
            if (!this.content.get((int)i).uuid.equals(uuid)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized void additional(UUID uuid, LayeredBufferCache cache) {
        int index = this.indexOf(uuid);
        if (index == -1) {
            this.content.add(new AdditionalBuffer(uuid, cache));
        } else {
            this.content.get(index).add(cache);
        }
    }

    @Override
    public void additional(AdditionalBuffers buffers) {
        this.content.addAll(buffers.content);
    }

    public Iterable<LayeredBufferCache> additionals() {
        return new FunctionNonNullIterator(this.content, x -> x.buffers);
    }

    public String toString() {
        return this.content.toString();
    }

    private record AdditionalBuffer(UUID uuid, LayeredBufferCache buffers) {
        public void add(LayeredBufferCache cache) {
            for (Tuple tuple : cache.tuples()) {
                if (this.buffers.containsKey((RenderType)tuple.key)) {
                    this.buffers.put((RenderType)tuple.key, BufferCache.combineOrCopy((BufferCache)this.buffers.get((RenderType)tuple.key), (Iterable<BufferCache>)new SingleIterator((Object)((BufferCache)tuple.value))));
                    continue;
                }
                this.buffers.put((RenderType)tuple.key, (BufferCache)tuple.value);
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.uuid) + "|" + String.valueOf((Object)this.buffers);
        }
    }
}

