/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;

public interface BufferCache {
    public static BufferCache combineOrCopy(@Nullable BufferCache first, Iterable<BufferCache> caches) {
        Iterator<BufferCache> itr = caches.iterator();
        if (first == null && !itr.hasNext()) {
            return null;
        }
        if (!itr.hasNext()) {
            return first.copy();
        }
        if (first == null) {
            first = itr.next();
        }
        if (!itr.hasNext()) {
            return first.copy();
        }
        return first.combine(itr);
    }

    public BufferCache extract(int var1);

    public BufferCache extract(int[] var1);

    public BufferCache copy();

    public BufferCache combine(Iterator<BufferCache> var1);

    public void applyOffset(Vec3 var1);

    public boolean isEmpty();

    public boolean isInvalid();

    public boolean isAvailable();

    public boolean upload(ChunkBufferUploader var1);

    public boolean download(ChunkBufferDownloader var1);

    public void eraseBuffer();

    public void invalidate();

    public int lengthToUpload();

    public int lengthToUpload(int var1);
}

