/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import com.mojang.blaze3d.vertex.MeshData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.client.render.VertexFormatUtils;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.mixin.client.render.ByteBufferBuilderResultAccessor;
import team.creative.littletiles.mixin.client.render.MeshDataAccessor;

public class BufferHolder
implements BufferCache {
    private ByteBuffer buffer;
    private int length;
    private int vertexCount;
    private int[] indexes;
    private boolean invalid;
    private int uploadIndex;

    public static BufferHolder combine(BufferHolder first, BufferHolder second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return (BufferHolder)first.combine((Iterator<BufferCache>)new SingleIterator((Object)second));
    }

    public BufferHolder(ByteBuffer buffer, int length, int vertexCount, int[] indexes) {
        this.buffer = buffer;
        this.length = length;
        this.vertexCount = vertexCount;
        this.indexes = indexes;
    }

    public BufferHolder(MeshData buffer, int[] indexes) {
        this.length = ((ByteBufferBuilderResultAccessor)((MeshDataAccessor)buffer).getVertexBuffer()).getCapacity();
        this.buffer = ByteBuffer.allocateDirect(this.length);
        this.buffer.put(buffer.vertexBuffer());
        this.buffer.rewind();
        this.vertexCount = buffer.drawState().vertexCount();
        buffer.close();
        this.indexes = indexes;
    }

    @Override
    public void eraseBuffer() {
        if (this.uploadIndex >= 0) {
            this.buffer = null;
        }
    }

    @Override
    public boolean upload(ChunkBufferUploader uploader) {
        if (!this.isAvailable()) {
            return false;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return false;
        }
        this.uploadIndex = uploader.uploadIndex();
        uploader.upload(buffer);
        buffer.rewind();
        return true;
    }

    public boolean upload(int facing, ChunkBufferUploader uploader) {
        if (!this.isAvailable()) {
            return false;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return false;
        }
        this.uploadIndex = uploader.uploadIndex(facing);
        uploader.upload(facing, buffer);
        buffer.rewind();
        return true;
    }

    public int[] indexes() {
        return this.indexes;
    }

    public ByteBuffer byteBuffer() {
        return this.buffer;
    }

    public ByteBuffer byteBufferOrThrow() {
        if (this.buffer != null) {
            return this.buffer;
        }
        throw new IllegalArgumentException("No buffer found");
    }

    public int length() {
        return this.length;
    }

    @Override
    public int lengthToUpload() {
        if (this.isAvailable()) {
            return this.length;
        }
        return 0;
    }

    @Override
    public int lengthToUpload(int facing) {
        if (this.isAvailable() && facing == ModelQuadFacing.UNASSIGNED.ordinal()) {
            return this.length;
        }
        return 0;
    }

    public int vertexCount() {
        return this.vertexCount;
    }

    @Override
    public boolean isEmpty() {
        return this.indexes == null || this.indexes.length == 0;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
        this.eraseBuffer();
    }

    @Override
    public boolean isAvailable() {
        return this.buffer != null && this.length > 0;
    }

    @Override
    public boolean download(ChunkBufferDownloader downloader) {
        return this.download(downloader.downloaded());
    }

    public boolean download(ByteBuffer buffer) {
        if (this.uploadIndex >= 0 && buffer.capacity() >= this.uploadIndex + this.length()) {
            ByteBuffer downloaded = ByteBuffer.allocateDirect(this.length);
            downloaded.put(0, buffer, this.uploadIndex, this.length);
            downloaded.rewind();
            this.buffer = downloaded;
            this.uploadIndex = -1;
            return true;
        }
        this.invalidate();
        return false;
    }

    private int indexOf(IntList list, int index) {
        for (int i = 0; i < list.size(); i += 2) {
            if (list.getInt(i) != index) continue;
            return i;
        }
        return -1;
    }

    private void add(IntList list, int index, int length) {
        int foundIndex = this.indexOf(list, index);
        if (foundIndex == -1) {
            list.add(index);
            list.add(length);
        } else {
            list.set(foundIndex + 1, list.getInt(foundIndex + 1) + length);
        }
    }

    @Override
    public BufferCache combine(Iterator<BufferCache> itr) {
        boolean self;
        int vertexCount = 0;
        int totalLength = 0;
        ArrayList<BufferHolder> holders = new ArrayList<BufferHolder>();
        IntArrayList indexes = new IntArrayList();
        boolean bl = self = !this.isEmpty();
        while (self || itr.hasNext()) {
            BufferHolder holder = self ? this : (BufferHolder)itr.next();
            self = false;
            if (holder.isEmpty()) continue;
            vertexCount += holder.vertexCount();
            totalLength += holder.length();
            for (int i = 0; i < holder.indexes.length; i += 2) {
                int start = i == 0 ? 0 : holder.indexes[i - 1];
                int length = holder.indexes[i + 1] - start;
                this.add((IntList)indexes, holder.indexes[i], length);
            }
            holders.add(holder);
        }
        if (vertexCount == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(totalLength);
        int totalIndex = 0;
        int[] bufferIndexes = new int[indexes.size()];
        for (int i = 0; i < indexes.size(); i += 2) {
            int length = indexes.getInt(i + 1);
            bufferIndexes[i] = indexes.getInt(i);
            bufferIndexes[i + 1] = totalIndex;
            indexes.set(i + 1, totalIndex += length);
        }
        for (BufferHolder holder : holders) {
            ByteBuffer b = holder.byteBufferOrThrow();
            for (int i = 0; i < holder.indexes.length; i += 2) {
                int start = i == 0 ? 0 : holder.indexes[i - 1];
                int length = holder.indexes[i + 1] - start;
                int index = this.indexOf((IntList)indexes, holder.indexes[i]);
                byteBuffer.put(bufferIndexes[index + 1], b, start, length);
                int n = index + 1;
                bufferIndexes[n] = bufferIndexes[n] + length;
            }
        }
        return new BufferHolder(byteBuffer, totalLength, vertexCount, indexes.toIntArray());
    }

    @Override
    public BufferHolder copy() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.length);
        ByteBuffer b = this.byteBufferOrThrow();
        b.position(0);
        b.limit(this.length());
        byteBuffer.put(b);
        b.rewind();
        byteBuffer.rewind();
        return new BufferHolder(byteBuffer, this.length, this.vertexCount, (int[])this.indexes.clone());
    }

    private boolean isIdentitcal(int[] toExtract) {
        if (toExtract.length * 2 != this.indexes.length) {
            return false;
        }
        for (int i = 0; i < toExtract.length; ++i) {
            if (toExtract[i] == this.indexes[i * 2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public BufferHolder extract(int toExtract) {
        int[] indexes = this.indexes();
        if (indexes == null) {
            return null;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return null;
        }
        if (indexes.length == 2 && indexes[0] == toExtract) {
            int length = this.length;
            int vertexCount = this.vertexCount;
            this.buffer = null;
            this.indexes = null;
            this.length = 0;
            this.vertexCount = 0;
            return new BufferHolder(buffer, length, vertexCount, indexes);
        }
        int[] extractedIndexes = new int[2];
        int found = 0;
        int extractedTotalLength = 0;
        for (int i = 0; i < indexes.length; i += 2) {
            if (indexes[i] != toExtract) continue;
            int start = i == 0 ? 0 : indexes[i - 1];
            int length = indexes[i + 1] - start;
            extractedIndexes[0] = toExtract;
            ++found;
            extractedTotalLength += length;
        }
        if (extractedTotalLength == 0) {
            return null;
        }
        ByteBuffer extractedBuffer = ByteBuffer.allocateDirect(extractedTotalLength);
        int div = this.length / this.vertexCount;
        int extractedVertexCount = extractedTotalLength / div;
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.length - extractedTotalLength);
        int[] newIndexes = new int[indexes.length - found * 2];
        int otherIndex = 0;
        int newIndex = 0;
        for (int i = 0; i < indexes.length; i += 2) {
            int start = i == 0 ? 0 : indexes[i - 1];
            int length = indexes[i + 1] - start;
            if (indexes[i] == extractedIndexes[otherIndex]) {
                extractedBuffer.put(extractedBuffer.position(), buffer, start, length);
                extractedBuffer.position(extractedBuffer.position() + length);
                extractedIndexes[otherIndex + 1] = extractedBuffer.position();
                ++otherIndex;
                continue;
            }
            newBuffer.put(newBuffer.position(), buffer, start, length);
            newBuffer.position(newBuffer.position() + length);
            newIndexes[newIndex] = indexes[i];
            newIndexes[newIndex + 1] = newBuffer.position();
            ++newIndex;
        }
        extractedBuffer.rewind();
        newBuffer.rewind();
        this.buffer = newBuffer;
        this.indexes = newIndexes;
        this.length = newBuffer.capacity();
        this.vertexCount = this.length / div;
        return new BufferHolder(extractedBuffer, extractedTotalLength, extractedVertexCount, extractedIndexes);
    }

    @Override
    public BufferHolder extract(int[] toExtract) {
        int[] indexes = this.indexes();
        if (indexes == null) {
            return null;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return null;
        }
        if (this.isIdentitcal(toExtract)) {
            this.buffer = null;
            this.indexes = null;
            this.length = 0;
            this.vertexCount = 0;
            return new BufferHolder(buffer, this.length, this.vertexCount, (int[])indexes.clone());
        }
        int[] extractedIndexes = new int[toExtract.length * 2];
        int found = 0;
        int extractedTotalLength = 0;
        for (int i = 0; i < indexes.length; i += 2) {
            int index = Arrays.binarySearch(toExtract, indexes[i]);
            if (index == -1) continue;
            int start = i == 0 ? 0 : indexes[i - 1];
            int length = indexes[i + 1] - start;
            extractedIndexes[index * 2] = toExtract[index];
            ++found;
            extractedTotalLength += length;
        }
        if (extractedTotalLength == 0) {
            return null;
        }
        ByteBuffer extractedBuffer = ByteBuffer.allocateDirect(extractedTotalLength);
        int div = this.length / this.vertexCount;
        int extractedVertexCount = extractedTotalLength / div;
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.length - extractedTotalLength);
        int[] newIndexes = new int[indexes.length - found * 2];
        int otherIndex = 0;
        int newIndex = 0;
        for (int i = 0; i < indexes.length; i += 2) {
            int start = i == 0 ? 0 : indexes[i - 1];
            int length = indexes[i + 1] - start;
            if (indexes[i] == extractedIndexes[otherIndex]) {
                extractedBuffer.put(extractedBuffer.position(), buffer, start, length);
                extractedBuffer.position(extractedBuffer.position() + length);
                extractedIndexes[otherIndex + 1] = extractedBuffer.position();
                ++otherIndex;
                continue;
            }
            newBuffer.put(newBuffer.position(), buffer, start, length);
            newBuffer.position(newBuffer.position() + length);
            newIndexes[newIndex] = indexes[i];
            newIndexes[newIndex + 1] = newBuffer.position();
            ++newIndex;
        }
        extractedBuffer.rewind();
        newBuffer.rewind();
        this.buffer = newBuffer;
        this.indexes = newIndexes;
        this.length = newBuffer.capacity();
        this.vertexCount = this.length / div;
        return new BufferHolder(extractedBuffer, extractedTotalLength, extractedVertexCount, extractedIndexes);
    }

    @Override
    public void applyOffset(Vec3 vec) {
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return;
        }
        int positionOffset = VertexFormatUtils.blockPositionOffset();
        int formatSize = VertexFormatUtils.blockFormatSize();
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < buffer.limit(); i += formatSize) {
            float x = buffer.getFloat(i + positionOffset);
            buffer.putFloat(i + positionOffset, x + (float)vec.x);
            float y = buffer.getFloat(i + positionOffset + 4);
            buffer.putFloat(i + positionOffset + 4, y + (float)vec.y);
            float z = buffer.getFloat(i + positionOffset + 8);
            buffer.putFloat(i + positionOffset + 8, z + (float)vec.z);
        }
    }

    public void moveUploadIndex(int offset) {
        this.uploadIndex += offset;
    }

    public String toString() {
        return "length: " + this.length + ", indexes: " + Arrays.toString(this.indexes) + ", uploadIndex: " + this.uploadIndex;
    }
}

