/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.build;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import team.creative.creativecore.client.render.box.QuadGeneratorContext;
import team.creative.creativecore.common.level.LevelAccessorFake;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.common.util.type.map.ChunkLayerMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.build.RenderingBlockQueue;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipeline;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.entity.BETiles;

@OnlyIn(value=Dist.CLIENT)
public class RenderingThread
extends Thread {
    public static volatile int CURRENT_RENDERING_INDEX = Integer.MIN_VALUE;
    private static final ChunkLayerMap<BufferCache> EMPTY_HOLDERS = new ChunkLayerMap();
    public static List<RenderingThread> THREADS;
    public static final Minecraft MC;
    public static final RenderingBlockQueue QUEUE;
    private final SingletonList<BakedQuad> bakedQuadWrapper = new SingletonList(null);
    private final LevelAccessorFake fakeAccess = new LevelAccessorFake();
    private final ChunkLayerMap<BufferCache> buffers = new ChunkLayerMap();
    public boolean active = true;
    private volatile boolean requiresReload = false;
    private LittleRenderPipeline[] pipelines = new LittleRenderPipeline[LittleRenderPipelineType.typeCount()];
    private QuadGeneratorContext quadContext;

    public static synchronized void initThreads(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count has to be at least equal or greater than one");
        }
        if (THREADS != null) {
            for (RenderingThread thread : THREADS) {
                if (thread == null) continue;
                thread.interrupt();
            }
            while (!QUEUE.isEmpty()) {
                RenderingThread.QUEUE.poll().be.render.resetRenderingState();
            }
        }
        THREADS = new ArrayList<RenderingThread>();
        for (int i = 0; i < count; ++i) {
            THREADS.add(new RenderingThread());
        }
    }

    public static synchronized void unload() {
        if (THREADS != null) {
            for (RenderingThread thread : THREADS) {
                if (thread == null) continue;
                thread.interrupt();
            }
        }
        THREADS = null;
        QUEUE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean queue(BETiles be, boolean hasPos, long pos) {
        if (THREADS == null) {
            RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
        }
        if (be.isRenderingEmpty()) {
            int index = be.render.startBuildingCache();
            BERenderManager bERenderManager = be.render;
            synchronized (bERenderManager) {
                be.render.eraseBoxCache();
                be.render.setBuffersEmpty();
            }
            if (!be.render.finishBuildingCache(index, EMPTY_HOLDERS, CURRENT_RENDERING_INDEX, true)) {
                return RenderingThread.queue(be, hasPos, pos);
            }
            return false;
        }
        QUEUE.queue(be, hasPos, pos);
        return true;
    }

    public static int queueSize() {
        return QUEUE.size();
    }

    public static synchronized void reload() {
        if (THREADS == null) {
            return;
        }
        RenderingThread.unload();
    }

    public static <T extends LittleRenderPipeline> T getOrCreate(LittleRenderPipelineType<T> type) {
        for (RenderingThread thread : THREADS) {
            if (thread.pipelines[type.id] == null) continue;
            return (T)thread.pipelines[type.id];
        }
        return THREADS.get(0).get(type);
    }

    public RenderingThread() {
        this.start();
    }

    public <T extends LittleRenderPipeline> T get(LittleRenderPipelineType<T> type) {
        LittleRenderPipeline pipeline = this.pipelines[type.id];
        if (pipeline == null) {
            this.pipelines[type.id] = pipeline = (LittleRenderPipeline)type.factory.get();
            pipeline.reload();
        }
        return (T)pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.quadContext = new QuadGeneratorContext();
            while (this.active) {
                if (this.requiresReload) {
                    this.requiresReload = false;
                    for (int i = 0; i < this.pipelines.length; ++i) {
                        if (this.pipelines[i] == null) continue;
                        this.pipelines[i].reload();
                    }
                }
                ClientLevel level = RenderingThread.MC.level;
                long duration = 0L;
                RandomSource rand = RandomSource.create();
                PoseStack posestack = new PoseStack();
                if (level != null && !QUEUE.isEmpty()) {
                    RenderingBlockContext data;
                    block36: {
                        data = QUEUE.poll();
                        if (data == null) continue;
                        try {
                            if (LittleTilesProfilerOverlay.isActive()) {
                                duration = System.nanoTime();
                            }
                            data.checkRemoved();
                            data.checkLoaded();
                            data.index = data.be.render.startBuildingCache();
                            BlockPos pos = data.be.getBlockPos();
                            data.beforeBuilding();
                            Int2ObjectMap<ChunkLayerMapList<LittleRenderBox>> cubes = data.be.render.getRenderingBoxes(data);
                            if (cubes == null || cubes.isEmpty()) continue;
                            for (ChunkLayerMapList map : cubes.values()) {
                                for (Tuple tuple : map.tuples()) {
                                    for (LittleRenderBox cube : (List)tuple.value) {
                                        if (!cube.doesNeedQuadUpdate) continue;
                                        this.fakeAccess.set(data.be.getLevel(), pos, cube.state);
                                        level = this.fakeAccess;
                                        BlockState modelState = cube.state;
                                        rand.setSeed(modelState.getSeed(pos));
                                        BakedModel blockModel = MC.getBlockRenderer().getBlockModel(modelState);
                                        ModelData modelData = blockModel.getModelData((BlockAndTintGetter)level, pos, modelState, level.getModelData(pos));
                                        BlockPos offset = cube.getOffset();
                                        for (int h = 0; h < Facing.VALUES.length; ++h) {
                                            Facing facing = Facing.VALUES[h];
                                            if (cube.shouldRenderFace(facing)) {
                                                if (cube.getQuad(facing) != null) continue;
                                                cube.setQuad(facing, cube.getBakedQuad(this.quadContext, (LevelAccessor)level, pos, offset, modelState, blockModel, modelData, facing, (RenderType)tuple.key, rand, true, -1));
                                                continue;
                                            }
                                            cube.setQuad(facing, null);
                                        }
                                        cube.doesNeedQuadUpdate = false;
                                    }
                                }
                            }
                            this.quadContext.clear();
                            data.clearQuadBuilding();
                            this.fakeAccess.set(null, null, null);
                            data.checkRemoved();
                            level = RenderingThread.MC.level;
                            int renderState = CURRENT_RENDERING_INDEX;
                            VertexFormat format = DefaultVertexFormat.BLOCK;
                            try {
                                posestack.setIdentity();
                                ((LittleRenderPipeline)this.get(data.getPipeline())).buildCache(posestack, this.buffers, data, format, this.bakedQuadWrapper);
                                if (!LittleTiles.CONFIG.rendering.useCubeCache) {
                                    data.be.render.eraseBoxCache();
                                }
                                if (!RenderingThread.finish(data, this.buffers, renderState, false)) {
                                    QUEUE.requeue(data);
                                }
                                this.buffers.clear();
                                if (LittleTilesProfilerOverlay.isActive()) {
                                    LittleTilesProfilerOverlay.finishBuildingCache(System.nanoTime() - duration);
                                }
                            }
                            catch (Exception e) {
                                LittleTiles.LOGGER.error((Object)e);
                                if (RenderingThread.finish(data, EMPTY_HOLDERS, -1, false)) break block36;
                                QUEUE.requeue(data);
                            }
                        }
                        catch (RemovedBlockEntityException e) {
                            RenderingThread.finish(data, EMPTY_HOLDERS, -1, true);
                        }
                        catch (RenderingBlockedException e) {
                            QUEUE.requeue(data);
                        }
                        catch (Exception e) {
                            if (!(e instanceof RenderingException)) {
                                LittleTiles.LOGGER.error((Object)e);
                            }
                            RenderingThread.finish(data, EMPTY_HOLDERS, -1, true);
                        }
                        catch (OutOfMemoryError error) {
                            QUEUE.requeue(data);
                            LittleTiles.LOGGER.error((Object)error);
                        }
                        finally {
                            this.buffers.clear();
                            data.unsetBlocked();
                            continue;
                        }
                    }
                    data = null;
                } else if (level == null || QUEUE.isEmpty()) {
                    RenderingThread.sleep(1L);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
        }
        catch (InterruptedException i) {
            for (int i2 = 0; i2 < this.pipelines.length; ++i2) {
                if (this.pipelines[i2] == null) continue;
                this.pipelines[i2].release();
            }
        }
        finally {
            for (int i = 0; i < this.pipelines.length; ++i) {
                if (this.pipelines[i] == null) continue;
                this.pipelines[i].release();
            }
        }
    }

    public static boolean finish(RenderingBlockContext data, ChunkLayerMap<BufferCache> buffers, int renderState, boolean force) {
        if (!data.be.render.finishBuildingCache(data.index, buffers, renderState, force)) {
            return false;
        }
        RenderChunkExtender chunk = QUEUE.unqeue(data);
        if (chunk != null) {
            ++LittleTilesProfilerOverlay.chunkUpdates;
            chunk.markReadyForUpdate(false);
        }
        return true;
    }

    static {
        MC = Minecraft.getInstance();
        QUEUE = new RenderingBlockQueue();
        RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
    }

    public static class RemovedBlockEntityException
    extends Exception {
        public RemovedBlockEntityException(String arg0) {
            super(arg0);
        }
    }

    public static class RenderingBlockedException
    extends RenderingException {
        public RenderingBlockedException() {
            super("");
        }
    }

    public static class RenderingException
    extends Exception {
        public RenderingException(String arg0) {
            super(arg0);
        }
    }
}

