/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.item;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import team.creative.littletiles.LittleTiles;

public class ItemModelCache {
    private boolean building = true;
    private List<BakedQuad> cache;
    private long lastUsed = System.currentTimeMillis();

    public boolean expired() {
        return System.currentTimeMillis() - this.lastUsed >= (long)LittleTiles.CONFIG.rendering.itemCacheDuration;
    }

    public void setQuads(boolean translucent, List<BakedQuad> baked) {
        if (translucent) {
            return;
        }
        this.cache = baked;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void complete() {
        this.building = false;
    }

    public List<BakedQuad> getQuads(boolean translucent) {
        this.lastUsed = System.currentTimeMillis();
        if (translucent) {
            return Collections.EMPTY_LIST;
        }
        return this.cache;
    }

    public boolean hasTranslucent() {
        return false;
    }
}

