/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.item;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeItemBoxModel;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;

public class LittleModelItemTiles
extends CreativeItemBoxModel {
    public LittleModelItemTiles() {
        super(new ModelResourceLocation(ResourceLocation.tryBuild((String)"minecraft", (String)"stone"), "inventory"));
    }

    public List<? extends RenderBox> getBoxes(ItemStack stack, boolean translucent) {
        ILittlePlacer tool = (ILittlePlacer)stack.getItem();
        if (tool.hasTiles(stack) && LittleGroup.shouldRenderInHand(ILittleTool.getData(stack))) {
            return tool.getTiles(stack).getRenderingBoxes(translucent);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasTranslucentLayer(ItemStack stack) {
        return LittleTilesClient.ITEM_RENDER_CACHE.hasTranslucent(stack);
    }

    public void saveCachedModel(boolean translucent, List<BakedQuad> cachedQuads, ItemStack stack, boolean threaded) {
    }

    public List<BakedQuad> getCachedModel(boolean translucent, ItemStack stack, boolean threaded) {
        return LittleTilesClient.ITEM_RENDER_CACHE.requestCache(stack, translucent);
    }
}

