/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.SectionCompiler;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.entity.LittleLevelRenderManager;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.SectionCompilerResultsExtender;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.mixin.client.render.CompiledSectionAccessor;

@OnlyIn(value=Dist.CLIENT)
public class LittleRenderChunk
implements RenderChunkExtender {
    public final LittleLevelRenderManager manager;
    public final SectionPos section;
    public final BlockPos pos;
    public final AtomicReference<SectionRenderDispatcher.CompiledSection> compiled = new AtomicReference<SectionRenderDispatcher.CompiledSection>(SectionRenderDispatcher.CompiledSection.UNCOMPILED);
    private AABB bb;
    public final AtomicBoolean considered = new AtomicBoolean();
    @Nullable
    private RebuildTask lastRebuildTask;
    @Nullable
    private ResortTransparencyTask lastResortTransparencyTask;
    private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
    private final ChunkLayerMap<VertexBuffer> buffers = new ChunkLayerMap(x -> new VertexBuffer(VertexBuffer.Usage.STATIC));
    private boolean dirty = true;
    private final SectionPos[] neighbors;
    private boolean playerChanged;
    public ChunkLayerMap<BufferCollection> lastUploaded;
    private volatile int queued;

    public LittleRenderChunk(LittleLevelRenderManager manager, SectionPos pos) {
        this.manager = manager;
        this.section = pos;
        this.pos = this.section.origin();
        this.bb = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 16), (double)(pos.getY() + 16), (double)(pos.getZ() + 16));
        this.neighbors = new SectionPos[Direction.values().length];
        for (int i = 0; i < this.neighbors.length; ++i) {
            Direction direction = Direction.values()[i];
            this.neighbors[i] = SectionPos.of((int)(this.section.getX() + direction.getStepX()), (int)(this.section.getY() + direction.getStepY()), (int)(this.section.getZ() + direction.getStepZ()));
        }
    }

    public LittleSubLevel level() {
        return this.manager.getLevel();
    }

    private boolean doesChunkExistAt(SectionPos pos) {
        return this.level().getChunk(pos.getX(), pos.getZ(), ChunkStatus.FULL, false) != null;
    }

    public boolean hasAllNeighbors() {
        if (this.getDistToPlayerSqr() <= 576.0) {
            return true;
        }
        return this.doesChunkExistAt(this.neighbors[Direction.WEST.ordinal()]) && this.doesChunkExistAt(this.neighbors[Direction.NORTH.ordinal()]) && this.doesChunkExistAt(this.neighbors[Direction.EAST.ordinal()]) && this.doesChunkExistAt(this.neighbors[Direction.SOUTH.ordinal()]);
    }

    @Override
    public ChunkLayerMap<BufferCollection> getLastUploaded() {
        return this.lastUploaded;
    }

    @Override
    public void setLastUploaded(ChunkLayerMap<BufferCollection> uploaded) {
        this.lastUploaded = uploaded;
    }

    @Override
    public int getQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(int queued) {
        this.queued = queued;
    }

    public AABB getBB() {
        return this.bb;
    }

    @Override
    public VertexBuffer getVertexBuffer(RenderType layer) {
        return (VertexBuffer)this.buffers.get(layer);
    }

    protected double getDistToPlayerSqr() {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 cam = this.level().getOrigin().transformPointToFakeWorld(camera.getPosition());
        Vec3 center = this.bb.getCenter();
        double d0 = center.x - cam.x;
        double d1 = center.y - cam.y;
        double d2 = center.z - cam.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public SectionRenderDispatcher.CompiledSection getCompiledSection() {
        return this.compiled.get();
    }

    private void reset() {
        this.cancelTasks();
        this.compiled.set(SectionRenderDispatcher.CompiledSection.UNCOMPILED);
        this.dirty = true;
    }

    public void releaseBuffers() {
        this.reset();
        this.buffers.forEach(VertexBuffer::close);
    }

    public void setDirty(boolean playerChanged) {
        boolean flag = this.dirty;
        this.dirty = true;
        this.playerChanged = playerChanged | (flag && this.playerChanged);
    }

    public void setNotDirty() {
        this.dirty = false;
        this.playerChanged = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markReadyForUpdate(boolean playerChanged) {
        this.setDirty(playerChanged);
    }

    public boolean isDirtyFromPlayer() {
        return this.dirty && this.playerChanged;
    }

    public boolean resortTransparency(RenderType layer) {
        SectionRenderDispatcher.CompiledSection compiled = this.getCompiledSection();
        if (this.lastResortTransparencyTask != null) {
            this.lastResortTransparencyTask.cancel();
        }
        if (!((CompiledSectionAccessor)compiled).getHasBlocks().contains(layer)) {
            return false;
        }
        this.lastResortTransparencyTask = new ResortTransparencyTask(this.getDistToPlayerSqr(), compiled);
        this.manager.schedule(this.lastResortTransparencyTask);
        return true;
    }

    protected boolean cancelTasks() {
        boolean flag = false;
        if (this.lastRebuildTask != null) {
            this.lastRebuildTask.cancel();
            this.lastRebuildTask = null;
            flag = true;
        }
        if (this.lastResortTransparencyTask != null) {
            this.lastResortTransparencyTask.cancel();
            this.lastResortTransparencyTask = null;
        }
        return flag;
    }

    public CompileTask createCompileTask(RenderRegionCache cache) {
        boolean canceled = this.cancelTasks();
        List additionalRenderers = ClientHooks.gatherAdditionalRenderers((BlockPos)this.pos, (Level)((Level)this.manager.getLevel()));
        RenderChunkRegion region = cache.createRegion((Level)this.manager.getLevel(), this.section, additionalRenderers.isEmpty());
        this.lastRebuildTask = new RebuildTask(this.getDistToPlayerSqr(), region, canceled || this.compiled.get() != SectionRenderDispatcher.CompiledSection.UNCOMPILED, additionalRenderers);
        return this.lastRebuildTask;
    }

    public void compileASync(RenderRegionCache cache) {
        this.manager.schedule(this.createCompileTask(cache));
    }

    public void compile(RenderRegionCache cache) {
        this.createCompileTask(cache).doTask(this.manager.fixedBuffers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalBlockEntities(Collection<BlockEntity> blockEntities) {
        HashSet set1;
        HashSet set = Sets.newHashSet(blockEntities);
        Set<BlockEntity> set2 = this.globalBlockEntities;
        synchronized (set2) {
            set1 = Sets.newHashSet(this.globalBlockEntities);
            set.removeAll(this.globalBlockEntities);
            set1.removeAll(blockEntities);
            this.globalBlockEntities.clear();
            this.globalBlockEntities.addAll(blockEntities);
        }
        this.manager.updateGlobalBlockEntities(set1, set);
    }

    @Override
    public MeshData.SortState getTransparencyState() {
        return ((CompiledSectionAccessor)this.getCompiledSection()).getTransparencyState();
    }

    @Override
    public void setTransparencyState(MeshData.SortState state) {
        ((CompiledSectionAccessor)this.getCompiledSection()).setTransparencyState(state);
    }

    @Override
    public void setHasBlock(RenderType layer) {
        SectionRenderDispatcher.CompiledSection compiled = this.getCompiledSection();
        if (compiled != SectionRenderDispatcher.CompiledSection.UNCOMPILED) {
            ((CompiledSectionAccessor)compiled).getHasBlocks().add(layer);
        }
    }

    @Override
    public boolean isEmpty(RenderType layer) {
        return this.getCompiledSection().isEmpty(layer);
    }

    @Override
    public VertexSorting createVertexSorting(double x, double y, double z) {
        return VertexSorting.byDistance((float)((float)x - (float)this.pos.getX()), (float)((float)y - (float)this.pos.getY()), (float)((float)z - (float)this.pos.getZ()));
    }

    @OnlyIn(value=Dist.CLIENT)
    class ResortTransparencyTask
    extends CompileTask {
        private final SectionRenderDispatcher.CompiledSection compiledSection;

        public ResortTransparencyTask(double distAtCreation, SectionRenderDispatcher.CompiledSection section) {
            super(LittleRenderChunk.this, distAtCreation, true);
            this.compiledSection = section;
        }

        @Override
        public String name() {
            return "rend_chk_sort";
        }

        @Override
        public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack pack) {
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }
            if (!LittleRenderChunk.this.hasAllNeighbors()) {
                this.isCancelled.set(true);
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }
            Vec3d cam = LittleRenderChunk.this.manager.getCameraPosition();
            MeshData.SortState sortstate = ((CompiledSectionAccessor)this.compiledSection).getTransparencyState();
            if (sortstate != null && !this.compiledSection.isEmpty(RenderType.translucent())) {
                VertexSorting vertexsorting = LittleRenderChunk.this.createVertexSorting(cam.x, cam.y, cam.z);
                ByteBufferBuilder.Result result = sortstate.buildSortedIndexBuffer(pack.buffer(RenderType.translucent()), vertexsorting);
                if (result == null) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    result.close();
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompletionStage completablefuture = LittleRenderChunk.this.manager.uploadSectionIndexBuffer(result, LittleRenderChunk.this.getVertexBuffer(RenderType.translucent())).thenApply(x -> SectionTaskResult.CANCELLED);
                return ((CompletableFuture)completablefuture).handle((r, exception) -> {
                    if (exception != null && !(exception instanceof CancellationException) && !(exception instanceof InterruptedException)) {
                        Minecraft.getInstance().delayCrash(CrashReport.forThrowable((Throwable)exception, (String)"Rendering chunk"));
                    }
                    return this.isCancelled.get() ? SectionTaskResult.CANCELLED : SectionTaskResult.SUCCESSFUL;
                });
            }
            return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
        }

        @Override
        public void cancel() {
            this.isCancelled.set(true);
        }
    }

    public abstract class CompileTask
    implements Comparable<CompileTask> {
        protected final double distAtCreation;
        protected final AtomicBoolean isCancelled = new AtomicBoolean(false);
        public final boolean isHighPriority;

        public CompileTask(LittleRenderChunk this$0, double distAtCreation, boolean isHighPriority) {
            this.distAtCreation = distAtCreation;
            this.isHighPriority = isHighPriority;
        }

        public abstract CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack var1);

        public abstract void cancel();

        public abstract String name();

        @Override
        public int compareTo(CompileTask other) {
            return Doubles.compare((double)this.distAtCreation, (double)other.distAtCreation);
        }
    }

    class RebuildTask
    extends CompileTask {
        private final List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers;
        private RenderChunkRegion region;

        public RebuildTask(double distAtCreation, RenderChunkRegion region, boolean isHighPriority, List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers) {
            super(LittleRenderChunk.this, distAtCreation, isHighPriority);
            this.region = region;
            this.additionalRenderers = additionalRenderers;
        }

        @Override
        public String name() {
            return "rend_chk_rebuild";
        }

        @Override
        public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack pack) {
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }
            Vec3d cam = LittleRenderChunk.this.manager.getCameraPosition();
            SectionCompiler.Results results = LittleTilesClient.ANIMATION_HANDLER.sectionCompiler.compile(LittleRenderChunk.this.section, this.region, LittleRenderChunk.this.createVertexSorting(cam.x, cam.y, cam.z), pack, this.additionalRenderers);
            LittleRenderChunk.this.updateGlobalBlockEntities(results.globalBlockEntities);
            if (this.isCancelled.get()) {
                results.release();
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }
            if (((SectionCompilerResultsExtender)results).isEmpty()) {
                LittleRenderChunk.this.manager.emptyChunk(LittleRenderChunk.this);
                LittleRenderChunk.this.compiled.set(SectionRenderDispatcher.CompiledSection.UNCOMPILED);
                results.release();
                LittleRenderChunk.this.prepareUpload();
                return CompletableFuture.completedFuture(SectionTaskResult.SUCCESSFUL);
            }
            SectionRenderDispatcher.CompiledSection compiled = new SectionRenderDispatcher.CompiledSection();
            ((CompiledSectionAccessor)compiled).setVisibilitySet(results.visibilitySet);
            compiled.getRenderableBlockEntities().addAll(results.blockEntities);
            ((CompiledSectionAccessor)compiled).setTransparencyState(results.transparencyState);
            ArrayList list = Lists.newArrayList();
            for (Map.Entry entry : results.renderedLayers.entrySet()) {
                list.add(LittleRenderChunk.this.manager.uploadChunkLayer((MeshData)entry.getValue(), LittleRenderChunk.this.getVertexBuffer((RenderType)entry.getKey())));
                ((CompiledSectionAccessor)compiled).getHasBlocks().add((RenderType)entry.getKey());
            }
            return ((CompletableFuture)Util.sequenceFailFast((List)list).handle((voids, throwable) -> {
                if (throwable != null && !(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                    Minecraft.getInstance().delayCrash(CrashReport.forThrowable((Throwable)throwable, (String)"Rendering chunk"));
                }
                if (this.isCancelled.get()) {
                    return SectionTaskResult.CANCELLED;
                }
                LittleRenderChunk.this.compiled.set(compiled);
                LittleRenderChunk.this.manager.queueChunk(LittleRenderChunk.this);
                return SectionTaskResult.SUCCESSFUL;
            })).whenComplete((result, exception) -> {
                if (result == SectionTaskResult.SUCCESSFUL) {
                    LittleRenderChunk.this.prepareUpload();
                    ChunkLayerMap<BufferCollection> caches = ((SectionCompilerResultsExtender)results).getCaches();
                    if (caches != null) {
                        for (Tuple tuple : caches.tuples()) {
                            LittleRenderChunk.this.uploaded((RenderType)tuple.key, (BufferCollection)tuple.value);
                        }
                    }
                }
            });
        }

        @Override
        public void cancel() {
            this.region = null;
            if (this.isCancelled.compareAndSet(false, true)) {
                LittleRenderChunk.this.setDirty(false);
            }
        }
    }

    public static enum SectionTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }
}

