/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.AdditionalBuffers;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingLevelHandler;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;

@OnlyIn(value=Dist.CLIENT)
public class RenderUploader {
    private static final HashMap<Level, RenderDataLevel> CACHES = new HashMap();

    private static RenderDataLevel getOrCreate(Level level) {
        RenderDataLevel data = CACHES.get(level);
        if (data == null) {
            data = new RenderDataLevel(level);
            CACHES.put(level, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Level targetLevel, LittleAnimationEntity entity) {
        HashMap<Level, RenderDataLevel> hashMap = CACHES;
        synchronized (hashMap) {
            if (RenderUploader.getOrCreate(targetLevel).queue(entity.getUUID(), entity.getSubLevel(), entity.getSubLevel())) {
                CACHES.remove(entity.getSubLevel());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyReceiveClientUpdate(BETiles be) {
        if (CACHES.isEmpty()) {
            return;
        }
        HashMap<Level, RenderDataLevel> hashMap = CACHES;
        synchronized (hashMap) {
            RenderDataLevel data = CACHES.get(be.getLevel());
            if (data != null && data.notifyReceiveClientUpdate(be)) {
                CACHES.remove(be.getLevel());
            }
        }
    }

    public static void unload() {
        CACHES.clear();
    }

    public static void longTick(int index) {
        Iterator<RenderDataLevel> iterator = CACHES.values().iterator();
        while (iterator.hasNext()) {
            RenderDataLevel level = iterator.next();
            if (!level.longTick(index)) continue;
            iterator.remove();
        }
    }

    public static class RenderDataLevel {
        public final Level targetLevel;
        public final RenderingLevelHandler target;
        private final HashMap<BlockPos, RenderDataToAdd> caches = new HashMap();
        private int waitTill;

        public RenderDataLevel(Level level) {
            this.targetLevel = level;
            this.target = RenderingLevelHandler.of(level);
        }

        private RenderDataToAdd getOrCreateBlock(RenderChunkUploader section, BlockPos pos) {
            RenderDataToAdd data = this.caches.get(pos);
            if (data == null) {
                data = new RenderDataToAdd();
                this.caches.put(pos, data);
                section.queue(data);
            }
            return data;
        }

        private RenderChunkUploader getOrCreateSection(RenderingLevelHandler origin, Level originLevel, Long2ObjectMap<RenderChunkUploader> sections, BlockPos pos) {
            long section = SectionPos.asLong((BlockPos)pos);
            RenderChunkUploader s = (RenderChunkUploader)sections.get(section);
            if (s == null) {
                origin.getRenderChunk(originLevel, section).backToRAM();
                s = new RenderChunkUploader(this.target.getRenderChunk(this.targetLevel, section), SectionPos.of((BlockPos)pos));
                sections.put(section, (Object)s);
            }
            return s;
        }

        public boolean queue(UUID uuid, Level originLevel, Iterable<BETiles> blocks) {
            RenderingLevelHandler origin = RenderingLevelHandler.of(originLevel);
            Long2ObjectOpenHashMap sections = new Long2ObjectOpenHashMap();
            for (Map.Entry<BlockPos, RenderDataToAdd> entry : this.caches.entrySet()) {
                this.getOrCreateSection(origin, originLevel, (Long2ObjectMap<RenderChunkUploader>)sections, entry.getKey()).queue(entry.getValue());
            }
            for (BETiles be : blocks) {
                RenderChunkUploader section = this.getOrCreateSection(origin, originLevel, (Long2ObjectMap<RenderChunkUploader>)sections, be.getBlockPos());
                this.getOrCreateBlock(section, be.getBlockPos()).queueNew(uuid, origin, originLevel, be, section.pos);
            }
            this.waitTill = LittleTilesClient.ANIMATION_HANDLER.longTickIndex + 2;
            if (LittleTiles.CONFIG.rendering.uploadToVBODirectly) {
                for (RenderChunkUploader section : sections.values()) {
                    section.appendRenderData();
                }
            } else {
                for (RenderChunkUploader section : sections.values()) {
                    section.markReadyForUpdate();
                }
            }
            Iterator<Map.Entry<BlockPos, RenderDataToAdd>> iterator = this.caches.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, RenderDataToAdd> entry;
                entry = iterator.next();
                if (!entry.getValue().isDone()) continue;
                iterator.remove();
            }
            return this.caches.isEmpty();
        }

        public boolean isEmpty() {
            return this.caches.isEmpty();
        }

        public boolean notifyReceiveClientUpdate(BETiles be) {
            RenderDataToAdd data = this.caches.remove(be.getBlockPos());
            if (data != null) {
                data.receiveUpdate(be);
            }
            return this.caches.isEmpty();
        }

        public boolean longTick(int index) {
            return index >= this.waitTill;
        }

        private class RenderDataToAdd
        extends AdditionalBuffers {
            private boolean done;

            private RenderDataToAdd() {
            }

            public void queueNew(UUID uuid, RenderingLevelHandler origin, Level originLevel, BETiles be, SectionPos pos) {
                IBlockBufferCache cache = be.render.buffers();
                Vec3 vec = RenderingLevelHandler.offsetCorrection(RenderDataLevel.this.target, RenderDataLevel.this.targetLevel, origin, originLevel, pos);
                LayeredBufferCache layers = new LayeredBufferCache();
                for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
                    BufferCache holder = cache.getIncludingAdditional(layer);
                    if (holder == null) continue;
                    if (vec != null) {
                        holder.applyOffset(vec);
                    }
                    layers.put(layer, holder);
                }
                this.additional(uuid, layers);
                BETiles target = BlockTile.loadBE((BlockGetter)RenderDataLevel.this.targetLevel, be.getBlockPos());
                if (target != null) {
                    target.render.additionalBuffers(x -> x.additional(this));
                    this.done = true;
                }
            }

            public boolean isDone() {
                return this.done;
            }

            public void receiveUpdate(BETiles be) {
                be.render.additionalBuffers(x -> x.additional(this));
            }
        }
    }

    private static class RenderChunkUploader {
        public final RenderChunkExtender section;
        public final SectionPos pos;
        private final List<RenderDataLevel.RenderDataToAdd> entries = new ArrayList<RenderDataLevel.RenderDataToAdd>();

        public RenderChunkUploader(RenderChunkExtender section, SectionPos pos) {
            this.section = section;
            this.pos = pos;
            this.section.backToRAM();
        }

        public void appendRenderData() {
            ArrayList<LayeredBufferCache> buffers = new ArrayList<LayeredBufferCache>();
            for (RenderDataLevel.RenderDataToAdd d : this.entries) {
                for (LayeredBufferCache b : d.additionals()) {
                    buffers.add(b);
                }
            }
            if (!this.section.appendRenderData(buffers)) {
                this.markReadyForUpdate();
            }
        }

        public void markReadyForUpdate() {
            this.section.markReadyForUpdate(false);
        }

        public void queue(RenderDataLevel.RenderDataToAdd data) {
            this.entries.add(data);
        }
    }
}

