/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.mc;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL15C;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;

public interface RenderChunkExtender {
    public VertexBuffer getVertexBuffer(RenderType var1);

    public void markReadyForUpdate(boolean var1);

    default public VertexSorting createVertexSorting(Vec3 vec) {
        return this.createVertexSorting(vec.x, vec.y, vec.z);
    }

    public VertexSorting createVertexSorting(double var1, double var3, double var5);

    public boolean isEmpty(RenderType var1);

    public MeshData.SortState getTransparencyState();

    public void setTransparencyState(MeshData.SortState var1);

    public void setHasBlock(RenderType var1);

    public int getQueued();

    public void setQueued(int var1);

    public ChunkLayerMap<BufferCollection> getLastUploaded();

    public void setLastUploaded(ChunkLayerMap<BufferCollection> var1);

    default public void prepareUpload() {
        this.setLastUploaded(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void uploaded(RenderType layer, BufferCollection buffers) {
        if (buffers == null) {
            return;
        }
        ChunkLayerMap uploaded = this.getLastUploaded();
        if (this.getLastUploaded() == null) {
            uploaded = new ChunkLayerMap();
            this.setLastUploaded((ChunkLayerMap<BufferCollection>)uploaded);
        }
        uploaded.put(layer, (Object)buffers);
        RenderChunkExtender renderChunkExtender = this;
        synchronized (renderChunkExtender) {
            if (this.getQueued() == 0) {
                buffers.eraseBuffers();
            }
        }
    }

    default public void backToRAM() {
        ChunkLayerMap<BufferCollection> lastUploaded = this.getLastUploaded();
        if (lastUploaded == null) {
            return;
        }
        Supplier<Boolean> run = () -> {
            ChunkBufferDownloader.SimpleChunkBufferDownloader downloader = new ChunkBufferDownloader.SimpleChunkBufferDownloader();
            for (Tuple tuple : lastUploaded.tuples()) {
                VertexBuffer buffer = this.getVertexBuffer((RenderType)tuple.key);
                BufferCollection uploaded = (BufferCollection)tuple.value;
                if (Minecraft.getInstance().level == null || uploaded == null || ((VertexBufferExtender)buffer).getVertexBufferId() == -1) {
                    if (uploaded == null) continue;
                    uploaded.discard();
                    continue;
                }
                ByteBuffer uploadedData = this.downloadUploadedData((VertexBufferExtender)buffer, 0L, ((VertexBufferExtender)buffer).getLastUploadedLength());
                if (uploadedData != null) {
                    downloader.buffer = uploadedData;
                    uploaded.download(downloader);
                    uploadedData.rewind();
                    downloader.buffer = null;
                    continue;
                }
                uploaded.discard();
            }
            this.setLastUploaded(null);
            return true;
        };
        try {
            if (Minecraft.getInstance().isSameThread()) {
                run.get();
            } else {
                CompletableFuture future = Minecraft.getInstance().submit(run);
                future.get();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ByteBuffer downloadUploadedData(VertexBufferExtender buffer, long offset, int size) {
        GlStateManager._glBindBuffer((int)34962, (int)buffer.getVertexBufferId());
        try {
            ByteBuffer result = ByteBuffer.allocateDirect(size);
            GL15C.glGetBufferSubData((int)34962, (long)offset, (ByteBuffer)result);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (!(e instanceof IllegalStateException)) {
                e.printStackTrace();
            }
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
    }

    default public boolean appendRenderData(Iterable<? extends LayeredBufferCache> blocks) {
        for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
            int size = 0;
            for (LayeredBufferCache layeredBufferCache : blocks) {
                size += layeredBufferCache.length(layer);
            }
            if (size == 0) continue;
            VertexBuffer uploadBuffer = this.getVertexBuffer(layer);
            if (uploadBuffer == null) {
                return false;
            }
            VertexFormat vertexFormat = uploadBuffer.getFormat();
            if (vertexFormat == null) {
                VertexFormat vertexFormat2 = DefaultVertexFormat.BLOCK;
            }
            Buffer vanillaBuffer = null;
            if (!this.isEmpty(layer)) {
                vanillaBuffer = this.downloadUploadedData((VertexBufferExtender)uploadBuffer, 0L, ((VertexBufferExtender)uploadBuffer).getLastUploadedLength());
            }
            ByteBufferBuilder buffer = new ByteBufferBuilder(((vanillaBuffer != null ? vanillaBuffer.limit() : 0) + size + DefaultVertexFormat.BLOCK.getVertexSize()) / 6);
            BufferBuilder builder = new BufferBuilder(buffer, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            if (vanillaBuffer != null) {
                ((ChunkBufferUploader)builder).upload((ByteBuffer)vanillaBuffer);
            }
            for (LayeredBufferCache layeredBufferCache : blocks) {
                ((BufferCache)layeredBufferCache.get(layer)).upload((ChunkBufferUploader)builder);
            }
            MeshData data = builder.build();
            if (layer == RenderType.translucent()) {
                Vec3 vec3 = Minecraft.getInstance().levelRenderer.getSectionRenderDispatcher().getCameraPosition();
                this.setTransparencyState(data.sortQuads(buffer, this.createVertexSorting(vec3.x, vec3.y, vec3.z)));
            }
            uploadBuffer.bind();
            uploadBuffer.upload(data);
            buffer.close();
            VertexBuffer.unbind();
            this.setHasBlock(layer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void startBuilding() {
        RenderChunkExtender renderChunkExtender = this;
        synchronized (renderChunkExtender) {
            this.setQueued(this.getQueued() + 1);
        }
        this.backToRAM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void endBuilding() {
        RenderChunkExtender renderChunkExtender = this;
        synchronized (renderChunkExtender) {
            this.setQueued(this.getQueued() - 1);
        }
    }
}

