/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.tool;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL14;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.render.overlay.PreviewRenderer;

public abstract class LittleTool {
    public ItemStack stack;

    public LittleTool(ItemStack stack) {
        this.stack = stack;
    }

    public abstract void tick(Level var1, Player var2, @Nullable BlockHitResult var3);

    public abstract void render(Level var1, Player var2, PoseStack var3, Vec3 var4, boolean var5);

    public abstract boolean keyPressed(Level var1, Player var2, KeyMapping var3);

    public abstract void removed();

    protected void setupPreviewRenderer(boolean lines) {
        if (lines) {
            RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
            RenderSystem.lineWidth((float)((float)LittleTiles.CONFIG.rendering.previewLineThickness));
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            RenderSystem.enableDepthTest();
            return;
        }
        if (LittleTiles.CONFIG.rendering.darkerPreviewBoxShading) {
            GL14.glBlendColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        double alpha = (float)(Math.sin((double)System.nanoTime() / 2.0E8) * 0.2 + 0.5);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PreviewRenderer.WHITE_TEXTURE);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
    }

    protected ByteBufferBuilder createBuffer() {
        return new ByteBufferBuilder(86432);
    }

    protected BufferBuilder createBuilder(ByteBufferBuilder buffer, boolean lines) {
        if (lines) {
            return new BufferBuilder(buffer, VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        }
        return new BufferBuilder(buffer, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
    }

    protected BufferBuilder createTesselatorBuilder(boolean lines) {
        if (lines) {
            return Tesselator.getInstance().begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        }
        return Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
    }

    protected void buildBox(PoseStack pose, RenderBox box, BufferBuilder builder, int colorAlpha, boolean lines) {
        if (lines) {
            box.renderLines(pose, (VertexConsumer)builder, colorAlpha, box.getCenter(), 0.002);
        } else {
            box.renderPreview(pose, (VertexConsumer)builder, colorAlpha);
        }
    }

    public boolean onRightClick(Level level, Player player, BlockHitResult result) {
        return true;
    }

    public boolean onLeftClick(Level level, Player player, BlockHitResult result) {
        return false;
    }

    public boolean onMouseWheelClickBlock(Level level, Player player, BlockHitResult result) {
        return false;
    }
}

