/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.tool.shaper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementPosition;

public class ShapePosition
extends PlacementPosition {
    public final BlockHitResult ray;
    public final LittleTileContext result;

    public ShapePosition(Player player, PlacementPosition position, BlockHitResult result, boolean whenClicked, boolean inside) {
        super(position);
        this.ray = result;
        this.result = LittleTileContext.selectFocused((BlockGetter)player.level(), result.getBlockPos(), player, whenClicked ? 1.0f : TickUtils.getFrameTime((LevelAccessor)player.level()));
        LittleGrid grid = this.getGrid();
        if (position.facing != null) {
            if (inside) {
                if (position.facing.positive && grid.isAtEdge(position.facing.axis.get(result.getLocation()))) {
                    this.getVec().sub(position.facing);
                }
            } else if (!position.facing.positive && grid.isAtEdge(position.facing.axis.get(result.getLocation()))) {
                this.getVec().add(position.facing);
            }
        }
    }

    public ShapePosition(PlacementPosition position, BlockHitResult ray, LittleTileContext result) {
        super(position);
        this.ray = ray;
        this.result = result;
    }

    public void move(LittleGrid context, Facing facing) {
        LittleVec vec = new LittleVec(facing);
        vec.scale(Screen.hasControlDown() ? context.count : 1);
        this.subVec(vec);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ShapePosition) {
            ShapePosition s = (ShapePosition)obj;
            if (!super.equals(obj)) {
                return false;
            }
            if (this.result.parent != s.result.parent) {
                return false;
            }
            return this.result.tile == s.result.tile;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack pose, boolean selected) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        AABB box = this.getBox().inflate(0.002);
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        RenderSystem.lineWidth((float)4.0f);
        LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)bufferbuilder, (AABB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        if (selected) {
            RenderSystem.lineWidth((float)1.0f);
            LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)bufferbuilder, (AABB)box, (float)1.0f, (float)0.3f, (float)0.0f, (float)1.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.enableDepthTest();
    }

    @Override
    public ShapePosition copy() {
        return new ShapePosition(super.copy(), this.ray, this.result);
    }
}

