/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.action;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableInt;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.config.LittleBuildingConfig;
import team.creative.littletiles.common.config.LittleTilesConfig;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.structure.exception.MissingAnimationException;

public abstract class LittleActionBoxes
extends LittleAction<Boolean> {
    public LittleBoxes boxes;
    @CanBeNull
    public UUID levelUUID;

    public LittleActionBoxes(Level level, LittleBoxes boxes) {
        this.boxes = boxes;
        this.levelUUID = level instanceof ISubLevel ? ((ISubLevel)level).getHolder().getUUID() : null;
    }

    public LittleActionBoxes(UUID levelUUID, LittleBoxes boxes) {
        this.boxes = boxes;
        this.levelUUID = levelUUID;
    }

    public LittleActionBoxes() {
    }

    public abstract void action(Level var1, Player var2, BlockPos var3, BlockState var4, List<LittleBox> var5, LittleGrid var6) throws LittleActionException;

    @Override
    public Boolean action(Player player) throws LittleActionException {
        BlockState state;
        if (this.boxes.isEmpty()) {
            return true;
        }
        Level level = player.level();
        if (this.levelUUID != null) {
            LittleEntity animation = LittleTiles.ANIMATION_HANDLERS.find(level.isClientSide, this.levelUUID);
            if (animation == null) {
                throw new MissingAnimationException(this.levelUUID);
            }
            level = (Level)animation.getSubLevel();
        }
        if (LittleTiles.CONFIG.isEditLimited(player)) {
            LittleBuildingConfig config = (LittleBuildingConfig)LittleTiles.CONFIG.build.get(player);
            if (this.boxes.getSurroundingBox().getPercentVolume(this.boxes.grid) > (double)((Integer)config.editBlockLimit.value).intValue()) {
                throw new LittleTilesConfig.NotAllowedToEditException(player, config);
            }
        }
        LittleActionBoxes.isAllowedToUse(player, this.boxes);
        HashMapList<BlockPos, LittleBox> boxesMap = this.boxes.generateBlockWise();
        MutableInt affectedBlocks = new MutableInt();
        try {
            for (BlockPos pos : boxesMap.keySet()) {
                BETiles be = LittleAction.loadBE(player, level, pos, null, false, 0);
                if (be == null && !(state = level.getBlockState(pos)).is(BlockTags.REPLACEABLE) && LittleAction.isBlockValid(state) && !LittleAction.canConvertBlock(player, level, pos, state, affectedBlocks.incrementAndGet())) continue;
            }
        }
        catch (LittleActionException e) {
            for (BlockPos pos : boxesMap.keySet()) {
                LittleActionBoxes.sendBlockResetToClient((LevelAccessor)level, player, pos);
            }
            throw e;
        }
        for (Map.Entry entry : boxesMap.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            state = level.getBlockState(pos);
            if (!LittleActionBoxes.isAllowedToInteract((LevelAccessor)level, player, pos, false, Facing.EAST)) {
                if (level.isClientSide) continue;
                LittleActionBoxes.sendBlockResetToClient((LevelAccessor)level, player, pos);
                continue;
            }
            this.action(level, player, pos, state, (List)entry.getValue(), this.boxes.grid);
        }
        this.actionDone(level, player);
        level.playSound(null, (Entity)player, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public void actionDone(Level level, Player player) {
    }

    protected LittleActionBoxes assignMirror(LittleActionBoxes action, Axis axis, LittleBoxAbsolute box) {
        action.boxes = this.boxes.copy();
        action.boxes.mirror(axis, box);
        return action;
    }

    @Override
    public boolean wasSuccessful(Boolean result) {
        return result;
    }

    @Override
    public Boolean failed() {
        return false;
    }
}

