/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.ChildVecOrigin;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.client.entity.LevelTransitionListener;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.entity.INoPushEntity;
import team.creative.littletiles.common.entity.LittleEntityPhysic;
import team.creative.littletiles.common.entity.OrientationAwareEntity;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.math.vec.LittleHitResult;

public abstract class LittleEntity<T extends LittleEntityPhysic>
extends Entity
implements OrientationAwareEntity,
INoPushEntity,
LevelTransitionListener {
    protected LittleSubLevel subLevel;
    protected IVecOrigin origin;
    protected boolean hasOriginChanged = false;
    public final T physic = this.createPhysic();
    private List<Entity> entitiesToAdd;
    protected boolean changedLevel;

    public LittleEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public LittleEntity(EntityType<?> type, Level level, Vec3d center) {
        super(type, level);
        this.setSubLevel(this.createLevel(), center);
        this.setPos(center.x, center.y, center.z);
        this.origin.tick();
        ((LittleEntityPhysic)this.physic).ignoreCollision(() -> this.initialTick());
    }

    public LittleEntity(EntityType<?> type, Level level, LittleSubLevel subLevel, Vec3d center) {
        super(type, level);
        this.setSubLevel(subLevel, center);
        this.setPos(center.x, center.y, center.z);
        this.origin.tick();
        ((LittleEntityPhysic)this.physic).ignoreCollision(() -> this.initialTick());
    }

    protected abstract LittleSubLevel createLevel();

    protected abstract T createPhysic();

    public boolean isReal() {
        Level level = this.level();
        Level level2 = this.level();
        if (level2 instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level2;
            level = sub.getRealLevel();
        }
        return !(level instanceof IOrientatedLevel);
    }

    @Override
    public void markOriginChange() {
        this.hasOriginChanged = true;
        for (OrientationAwareEntity child : this.children()) {
            child.markOriginChange();
        }
    }

    public void resetOriginChange() {
        this.hasOriginChanged = false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    public IVecOrigin getOrigin() {
        return this.origin;
    }

    public LittleSubLevel getSubLevel() {
        return this.subLevel;
    }

    public Level getRealLevel() {
        Level level = this.level();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            return sub.getRealLevel();
        }
        return this.level();
    }

    public LittleEntity getTopLevelEntity() {
        Level level = this.level();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            return ((LittleEntity)sub.getHolder()).getTopLevelEntity();
        }
        return this;
    }

    public abstract CreativePacket initClientPacket();

    public abstract void startTracking(ServerPlayer var1);

    public abstract void stopTracking(ServerPlayer var1);

    protected void setSubLevel(LittleSubLevel subLevel, Vec3d center) {
        this.subLevel = subLevel;
        this.subLevel.setHolder(this);
        this.subLevel.setOrigin(center);
        this.origin = subLevel.getOrigin();
        ((LittleEntityPhysic)this.physic).setSubLevel(subLevel);
    }

    @Override
    public void parentVecOriginChange(IVecOrigin origin) {
        ((ChildVecOrigin)origin).parent = origin;
    }

    @Override
    public void transform(CollisionCoordinator coordinator) {
        ((LittleEntityPhysic)this.physic).transform(coordinator);
    }

    @Override
    public void changedLevel(Level oldLevel, Level newLevel) {
        this.changedLevel = true;
    }

    public AABB getRealBB() {
        Level level = this.level();
        if (level instanceof ISubLevel) {
            ISubLevel or = (ISubLevel)level;
            return or.getOrigin().getAABB(this.getBoundingBox()).toVanilla();
        }
        return this.getBoundingBox();
    }

    public Vec3 getRealCenter() {
        Level level = this.level();
        if (level instanceof ISubLevel) {
            ISubLevel or = (ISubLevel)level;
            return or.getOrigin().transformPointToWorld(this.position());
        }
        return this.position();
    }

    public Iterable<Entity> entities() {
        return this.subLevel.entities();
    }

    public Iterable<OrientationAwareEntity> children() {
        return new FilterIterator(this.entities(), x -> {
            OrientationAwareEntity e;
            return x instanceof OrientationAwareEntity && (e = (OrientationAwareEntity)x).hasLoaded();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract LittleEntityRenderManager getRenderManager();

    public abstract void initialTick();

    public abstract void internalTick();

    @Override
    public void performTick() {
        if (this.entitiesToAdd != null) {
            for (Entity entity : this.entitiesToAdd) {
                this.subLevel.addFreshEntity(entity);
            }
            this.entitiesToAdd = null;
        }
        if (this.level() instanceof ISubLevel) {
            if (!this.level().isClientSide) {
                this.setSharedFlag(6, this.isCurrentlyGlowing());
            }
            super.baseTick();
        } else {
            super.tick();
        }
        this.children().forEach(x -> x.performTick());
        this.internalTick();
        this.subLevel.tick();
        ((LittleEntityPhysic)this.physic).tick();
        ((LittleEntityPhysic)this.physic).updateBoundingBox();
        this.syncMovement();
        this.origin.tick();
        Vec3 center = ((LittleEntityPhysic)this.physic).getCenter();
        this.setPosRaw(center.x, center.y, center.z);
    }

    public abstract void syncMovement();

    protected abstract Vec3d loadCenter(CompoundTag var1);

    public void readAdditionalSaveData(CompoundTag nbt) {
        this.setSubLevel(this.createLevel(), this.loadCenter(nbt));
        ((LittleEntityPhysic)this.physic).load(nbt.getCompound("physic"));
        this.loadEntity(nbt);
        ((LittleEntityPhysic)this.physic).updateBoundingBox();
        if (nbt.contains("entities")) {
            this.entitiesToAdd = new ArrayList<Entity>();
            ListTag list = nbt.getList("entities", 10);
            for (int i = 0; i < list.size(); ++i) {
                EntityType.create((CompoundTag)list.getCompound(i), (Level)((Level)this.subLevel)).ifPresent(this.entitiesToAdd::add);
            }
        } else {
            this.entitiesToAdd = null;
        }
    }

    public abstract void loadEntity(CompoundTag var1);

    public void addAdditionalSaveData(CompoundTag nbt) {
        nbt.put("physic", (Tag)((LittleEntityPhysic)this.physic).save());
        this.saveEntity(nbt);
        ListTag list = new ListTag();
        for (Entity entity : this.entities()) {
            CompoundTag entityNBT = new CompoundTag();
            entity.save(entityNBT);
            list.add((Object)entityNBT);
        }
        if (!list.isEmpty()) {
            nbt.put("entities", (Tag)list);
        }
    }

    public abstract void saveEntity(CompoundTag var1);

    public void onAddedToLevel() {
        super.onAddedToLevel();
        ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(this.level())).add(this);
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(this.level())).remove(this);
    }

    public void setPos(double x, double y, double z) {
        super.setPosRaw(x, y, z);
    }

    protected AABB makeBoundingBox() {
        return this.origin.getAABB(((LittleEntityPhysic)this.physic).getOBB()).toVanilla();
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void destroyAnimation() {
        this.kill();
    }

    public void kill() {
        this.subLevel.unload();
        super.kill();
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public LittleHitResult rayTrace(Vec3 pos, Vec3 look) {
        Vec3 newLook;
        LittleHitResult result = null;
        double distance = 0.0;
        for (Entity entity : this.entities()) {
            double tempDistance;
            LittleHitResult tempResult;
            Vec3 newLook2;
            Vec3 newPos;
            if (entity instanceof LittleEntity) {
                LittleEntity levelEntity = (LittleEntity)entity;
                if (!levelEntity.hasLoaded()) continue;
                newPos = levelEntity.origin.transformPointToFakeWorld(pos);
                newLook2 = levelEntity.origin.transformPointToFakeWorld(look);
                if (!((LittleEntityPhysic)levelEntity.physic).getOBB().intersects(newPos, newLook2) || (tempResult = levelEntity.rayTrace(pos, look)) == null) continue;
                tempDistance = newPos.distanceTo(tempResult.hit.getLocation());
                if (result != null && !(tempDistance < distance)) continue;
                result = tempResult;
                distance = tempDistance;
                continue;
            }
            newPos = this.origin.transformPointToFakeWorld(pos);
            newLook2 = this.origin.transformPointToFakeWorld(look);
            if (!entity.getBoundingBox().intersects(newPos, newLook2)) continue;
            tempResult = new LittleHitResult(this, (HitResult)new EntityHitResult(entity, (Vec3)entity.getBoundingBox().clip(newPos, newLook2).get()), this.subLevel);
            tempDistance = newPos.distanceTo(tempResult.hit.getLocation());
            if (result != null && !(tempDistance < distance)) continue;
            result = tempResult;
            distance = tempDistance;
        }
        Vec3 newPos = this.origin.transformPointToFakeWorld(pos);
        BlockHitResult tempResult = this.subLevel.clip(new ClipContext(newPos, newLook = this.origin.transformPointToFakeWorld(look), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
        if (tempResult == null || tempResult.getType() != HitResult.Type.BLOCK || !(tempResult instanceof BlockHitResult)) {
            return result;
        }
        if (result == null || pos.distanceTo(tempResult.getLocation()) < distance) {
            return new LittleHitResult(this, (HitResult)tempResult, this.subLevel);
        }
        return result;
    }

    public boolean shouldRender(double x, double y, double z) {
        Vec3 center = this.getRealCenter();
        double d0 = center.x - x;
        double d1 = center.y - y;
        double d2 = center.z - z;
        return this.shouldRenderAtSqrDistance(d0 * d0 + d1 * d1 + d2 * d2);
    }

    @Override
    public boolean hasLoaded() {
        return this.subLevel != null;
    }
}

