/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control;

import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.text.TextBuilder;

public class GuiDirectionIndicator
extends GuiButtonIcon {
    private Facing facing;

    public GuiDirectionIndicator(String name, Facing facing) {
        super(name, Icon.EMPTY, x -> {});
        this.setFacing(facing);
    }

    public Facing getFacing() {
        return this.facing;
    }

    public void setFacing(Facing facing) {
        this.facing = facing;
        this.setIcon(GuiDirectionIndicator.toIcon(facing));
        this.setTooltip(new TextBuilder().translate("gui.points." + facing.name).build());
    }

    public static Icon toIcon(Facing facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Facing.EAST -> Icon.ARROW_RIGHT;
            case Facing.WEST -> Icon.ARROW_LEFT;
            case Facing.UP -> Icon.ARROW_UP;
            case Facing.DOWN -> Icon.ARROW_DOWN;
            case Facing.SOUTH -> Icon.ARROW_IN;
            case Facing.NORTH -> Icon.ARROW_OUT;
        };
    }
}

