/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control;

import net.minecraft.util.Mth;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiCounter;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.grid.LittleGrid;

public class GuiDistanceControl
extends GuiParent {
    public static final double EPSILON = 1.0E-5;

    public GuiDistanceControl(String name, LittleGrid context, int distance) {
        super(name);
        this.add(new GuiCounter("blocks", 0).setTooltip(new TextBuilder().translate("gui.distance.blocks").build()));
        this.add(new GuiStateButton("grid", LittleGrid.mapBuilder()).setDim(20, 10));
        this.add(new GuiCounter("ltdistance", 0).setTooltip(new TextBuilder().translate("gui.distance.pixels").build()));
        this.setDistance(context, distance);
    }

    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            super.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
        }
        super.raiseEvent(event);
    }

    public void resetTextfield() {
        ((GuiCounter)this.get("blocks", GuiCounter.class)).resetTextfield();
        ((GuiCounter)this.get("ltdistance", GuiCounter.class)).resetTextfield();
    }

    public void setVanillaDistance(double distance) {
        int lt;
        LittleGrid grid = null;
        while (Math.abs((grid = grid == null ? LittleGrid.MIN : grid.next()).toVanillaGrid(lt = grid.toGrid(distance)) - distance) > 1.0E-5 && grid.next() != null) {
        }
        this.setDistance(grid, lt);
    }

    public void setDistance(LittleGrid grid, int distance) {
        int max = LittleTiles.CONFIG.general.maxDoorDistance * grid.count;
        distance = Mth.clamp((int)distance, (int)(-max), (int)max);
        GuiStateButton contextBox = (GuiStateButton)this.get("grid");
        contextBox.select((Object)grid);
        int blocks = distance / grid.count;
        GuiCounter blocksTF = (GuiCounter)this.get("blocks");
        blocksTF.setValue(blocks);
        blocksTF.resetTextfield();
        GuiCounter ltdistanceTF = (GuiCounter)this.get("ltdistance");
        ltdistanceTF.setValue(distance - blocks * grid.count);
        ltdistanceTF.resetTextfield();
    }

    public int getDistance() {
        GuiCounter blocksTF = (GuiCounter)this.get("blocks");
        GuiCounter ltdistanceTF = (GuiCounter)this.get("ltdistance");
        LittleGrid context = this.getDistanceGrid();
        try {
            int distance = blocksTF.getValue() * context.count + ltdistanceTF.getValue();
            int max = LittleTiles.CONFIG.general.maxDoorDistance * context.count;
            distance = Mth.clamp((int)distance, (int)(-max), (int)max);
            return distance;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public LittleGrid getDistanceGrid() {
        GuiStateButton contextBox = (GuiStateButton)this.get("grid");
        return (LittleGrid)contextBox.selected((Object)LittleGrid.overallDefault());
    }

    public double getVanillaDistance() {
        return this.getDistanceGrid().toVanillaGrid(this.getDistance());
    }
}

