/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.gui.control.animation.GuiTimelinePanel;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationHandler;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;
import team.creative.littletiles.common.structure.animation.event.ChildDoorEvent;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;

public class GuiChildEventPanel
extends GuiTimelinePanel {
    public final GuiTreeItemStructure item;
    public final List<GuiChildTimelineChannel> children = new ArrayList<GuiChildTimelineChannel>();

    public GuiChildEventPanel(GuiTreeItemStructure item, GuiRecipeAnimationHandler handler, AnimationTimeline timeline, int duration) {
        super(handler, duration);
        this.item = item;
        List<AnimationTimeline.AnimationEventEntry> events = GuiChildEventPanel.extract(timeline, ChildDoorEvent.class);
        for (AnimationTimeline.AnimationEventEntry entry : events) {
            ChildDoorEvent event = (ChildDoorEvent)entry.getEvent();
            GuiChildTimelineChannel channel = this.getOrCreate(event.childId);
            if (!channel.isSpaceFor(null, entry.start)) continue;
            channel.addKey(entry.start, event);
        }
        GuiParent channelControl = new GuiParent();
        this.add((GuiControl)channelControl);
        channelControl.add((GuiControl)new GuiComboBox("childBox", (IComponentMap)new TextMapBuilder()));
        channelControl.add((GuiControl)new GuiButton("childAdd", x -> {
            GuiComboBox childBox = (GuiComboBox)this.get("childBox");
            Integer selected = (Integer)childBox.selected();
            if (selected != null) {
                this.getOrCreate(selected);
            }
            this.updateAddBox();
        }).setTranslate("gui.add"));
        channelControl.add((GuiControl)new GuiButton("removed_unused", x -> {
            GuiChildEventPanel.clearUnusedChannel(this.children);
            this.updateAddBox();
        }).setTranslate("gui.door.clean.channel"));
        this.updateAddBox();
    }

    public void updateAddBox() {
        GuiComboBox childBox = (GuiComboBox)this.get("childBox");
        GuiButton button = (GuiButton)this.get("childAdd");
        TextMapBuilder map = new TextMapBuilder();
        for (int i = 0; i < this.item.itemsCount(); ++i) {
            if (this.hasChild(i) || !(this.item.getChildStructure(i) instanceof LittleDoor)) continue;
            map.addComponent((Object)i, (Component)Component.literal((String)((GuiTreeItemStructure)this.item.getItem(i)).getTitle()));
        }
        childBox.set((IComponentMap)map);
        childBox.setEnabled(map.size() > 0);
        button.setEnabled(map.size() > 0);
        if (this.getParent() != null) {
            this.reflow();
        }
    }

    protected GuiChildTimelineChannel getOrCreate(int id) {
        while (this.children.size() <= id) {
            this.children.add(null);
        }
        GuiChildTimelineChannel channel = this.children.get(id);
        if (channel == null) {
            channel = new GuiChildTimelineChannel(this.time, id);
            this.children.set(id, channel);
            this.time.addGuiTimelineChannel(Component.literal((String)("" + id)), (GuiTimelineChannel)channel);
        }
        return channel;
    }

    protected boolean hasChild(int id) {
        return this.children.size() > id && this.children.get(id) != null;
    }

    public boolean isChildEmpty() {
        for (GuiChildTimelineChannel channel : this.children) {
            if (channel == null || channel.isChannelEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addBefore() {
        this.add((GuiControl)new GuiLabel("childLabel").setTitle((Component)GuiChildEventPanel.translatable((String)"gui.door.child").append(":")));
    }

    public void collectEvents(int duration, List<AnimationTimeline.AnimationEventEntry> events, boolean opening) {
        for (GuiChildTimelineChannel channel : this.children) {
            for (GuiTimelineKey key : channel.keys()) {
                if (key.tick > duration) continue;
                events.add(new AnimationTimeline.AnimationEventEntry(key.tick, (AnimationEvent)key.value));
            }
        }
    }

    public static class GuiChildTimelineChannel
    extends GuiTimelineChannel<ChildDoorEvent> {
        public final int childId;

        public GuiChildTimelineChannel(GuiTimeline timeline, int childId) {
            super(timeline);
            this.childId = childId;
        }

        protected ChildDoorEvent getValueAt(int time) {
            return new ChildDoorEvent(this.childId);
        }
    }
}

