/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.animation;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationStorage;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.math.box.LittleBox;

public class GuiIsoAnimationViewer
extends GuiControl {
    private static final float MAXIMUM_ZOOM = 16.0f;
    protected SmoothValue rotX = new SmoothValue(200L);
    protected SmoothValue rotY = new SmoothValue(200L);
    protected SmoothValue rotZ = new SmoothValue(200L);
    protected SmoothValue scale = new SmoothValue(200L, 1.0);
    protected SmoothValue offX = new SmoothValue(200L);
    protected SmoothValue offY = new SmoothValue(200L);
    private GuiIsoView view;
    private boolean initialized = false;
    private boolean grabbed = false;
    public double grabX;
    public double grabY;
    public final GuiTreeItemStructure item;
    private LittleBox box;
    private LittleGrid grid;
    private boolean even;
    public boolean visibleAxis = true;

    public GuiIsoAnimationViewer(String name, GuiTreeItemStructure item, LittleBox box, LittleGrid grid, boolean even) {
        super(name);
        this.item = item;
        this.setView(GuiIsoView.UP);
        this.box = box.copy();
        this.grid = grid;
        this.even = even;
    }

    public LittleBox getBox() {
        return this.box;
    }

    public LittleGrid getGrid() {
        return this.grid;
    }

    public void setAxis(LittleBox box, LittleGrid grid) {
        this.box = box.copy();
        this.grid = grid;
        this.raiseEvent((GuiEvent)new GuiAnimationAxisChangedEvent(this));
    }

    public boolean isEven() {
        return this.even;
    }

    public void setEven(boolean even) {
        boolean changed = this.even != even;
        this.even = even;
        if (!changed || this.box == null) {
            return;
        }
        if (even) {
            --this.box.minX;
            --this.box.minY;
            --this.box.minZ;
        } else {
            ++this.box.minX;
            ++this.box.minY;
            ++this.box.minZ;
        }
        this.raiseEvent((GuiEvent)new GuiAnimationAxisChangedEvent(this));
    }

    public void setView(GuiIsoView view) {
        this.view = view;
        this.rotX.set((double)view.rotX);
        this.rotY.set((double)view.rotY);
        this.rotZ.set((double)view.rotZ);
        if (this.getParent() != null) {
            this.raiseEvent((GuiEvent)new GuiAnimationViewChangedEvent(this));
        }
    }

    public void mouseMoved(double x, double y) {
        super.mouseMoved(x, y);
        if (!this.grabbed) {
            return;
        }
        double scale = this.calculateScale();
        this.offX.add((x - this.grabX) / scale);
        this.offY.add((y - this.grabY) / scale);
        this.grabX = x;
        this.grabY = y;
    }

    public boolean mouseClicked(double x, double y, int button) {
        switch (button) {
            case 0: {
                this.grabX = x;
                this.grabY = y;
                this.grabbed = true;
                break;
            }
            case 1: {
                this.clickToSetAxis(x, y);
                break;
            }
            case 2: {
                this.resetView();
            }
        }
        return true;
    }

    public void mouseReleased(double x, double y, int button) {
        this.grabbed = false;
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        this.scale.add(0.05 * delta * (double)(Screen.hasControlDown() ? 5 : 1));
        if (Math.pow(this.scale.aimed(), 2.0) > 16.0) {
            this.scale.set(Math.sqrt(16.0));
        }
        if (this.scale.aimed() < 0.0) {
            this.scale.set(0.0);
        }
        return true;
    }

    public void clickToSetAxis(double x, double y) {
        GuiRecipeAnimationStorage storage = this.item.recipe.storage;
        if (!storage.isReady() || !storage.isReady(this.item)) {
            return;
        }
        float scale = this.calculateScale();
        Vec3d center = storage.center();
        Axis one = this.view.xAxis.axis;
        int posOne = this.grid.toGrid(-this.offX.current() * (double)this.view.xAxis.offset() + (x - (double)(this.rect.getWidth() / 2)) / (double)scale * (double)this.view.xAxis.offset() + center.get(one));
        int sizeOne = this.box.getSize(one);
        this.box.setMax(one, posOne + sizeOne);
        this.box.setMin(one, posOne);
        Axis two = this.view.yAxis.axis;
        int posTwo = this.grid.toGrid((-this.offY.current() + (y - (double)(this.rect.getHeight() / 2)) / (double)scale) * (double)(-this.view.yAxis.offset()) + center.get(two));
        int sizeTwo = this.box.getSize(two);
        this.box.setMax(two, posTwo + sizeTwo);
        this.box.setMin(two, posTwo);
        this.raiseEvent((GuiEvent)new GuiAnimationAxisChangedEvent(this));
        GuiIsoAnimationViewer.playSound((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_ON);
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    public void resetView() {
        this.offX.set(0.0);
        this.offY.set(0.0);
        this.scale.set(Math.sqrt(0.9 / this.item.recipe.storage.longestSide()));
    }

    public void nextAxis() {
        this.setView(Axis.values()[(this.view.zAxis.axis.ordinal() + 1) % Axis.values().length].facing(true));
    }

    public void mirrorView() {
        this.setView(this.view.zAxis.opposite());
    }

    public void setView(Facing facing) {
        this.setView(switch (facing) {
            default -> throw new MatchException(null, null);
            case Facing.EAST -> GuiIsoView.EAST;
            case Facing.WEST -> GuiIsoView.WEST;
            case Facing.UP -> GuiIsoView.UP;
            case Facing.DOWN -> GuiIsoView.DOWN;
            case Facing.SOUTH -> GuiIsoView.SOUTH;
            case Facing.NORTH -> GuiIsoView.NORTH;
        });
    }

    protected float calculateScale() {
        float dimensionScale = Math.min((float)this.rect.getContentWidth(), (float)this.rect.getContentHeight());
        return (float)((double)dimensionScale * Math.pow(this.scale.current(), 2.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, Rect controlRect, Rect realRect, double controlScale, int mouseX, int mouseY) {
        GuiRecipeAnimationStorage storage = this.item.recipe.storage;
        if (!storage.isReady() || !storage.isReady(this.item)) {
            return;
        }
        if (!this.initialized) {
            this.resetView();
            this.initialized = true;
        }
        this.rotX.tick();
        this.rotY.tick();
        this.rotZ.tick();
        this.scale.tick();
        this.offX.tick();
        this.offY.tick();
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        RenderSystem.applyModelViewMatrix();
        PoseStack pose = new PoseStack();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        double guiScale = window.getGuiScale();
        int height = (int)(realRect.getHeight() * guiScale);
        RenderSystem.viewport((int)((int)(realRect.minX * guiScale)), (int)((int)((double)window.getHeight() - realRect.minY * guiScale - (double)height)), (int)((int)(realRect.getWidth() * guiScale)), (int)height);
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        Matrix4f projection = new Matrix4f().ortho(0.0f, (float)this.rect.getWidth(), 0.0f, (float)this.rect.getHeight(), -1000.0f, ClientHooks.getGuiFarPlane());
        RenderSystem.setProjectionMatrix((Matrix4f)projection, (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        Vec3d center = storage.center();
        pose.translate((float)(this.rect.getWidth() / 2), (float)(this.rect.getHeight() / 2), 0.0f);
        float scale = this.calculateScale();
        pose.scale(scale, scale, scale);
        pose.translate(this.offX.current(), -this.offY.current(), 0.0);
        pose.mulPose(com.mojang.math.Axis.XP.rotationDegrees((float)this.rotX.current()));
        pose.mulPose(com.mojang.math.Axis.YP.rotationDegrees((float)this.rotY.current()));
        pose.mulPose(com.mojang.math.Axis.ZP.rotationDegrees((float)this.rotZ.current()));
        pose.translate(-center.x, -center.y, -center.z);
        storage.renderAll(pose, projection, mc);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.visibleAxis) {
            RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
            int colorAlpha = 255;
            LittleRenderBox renderBox = this.box.getRenderingBox(this.grid);
            RenderSystem.disableDepthTest();
            RenderSystem.lineWidth((float)16.0f);
            renderBox.renderLines(pose, (VertexConsumer)bufferbuilder, colorAlpha);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        }
        RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().ortho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, ClientHooks.getGuiFarPlane()), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        Lighting.setupFor3DItems();
        RenderSystem.disableDepthTest();
        pose = graphics.pose();
        pose.pushPose();
        int axisWidth = 20;
        int axisHeight = 16;
        Font font = Minecraft.getInstance().font;
        String string = this.view.xAxis.axis.name();
        int n = this.rect.getWidth() / 2 - axisWidth / 2;
        int n2 = this.rect.getHeight() - axisHeight;
        Objects.requireNonNull(font);
        graphics.drawString(font, string, n, n2 + 9 / 2, -1);
        Icon icon = this.view.xAxis.positive ? Icon.ARROW_RIGHT : Icon.ARROW_LEFT;
        pose.translate((float)(this.rect.getWidth() / 2 - axisWidth / 2), (float)(this.rect.getHeight() - axisHeight), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.location());
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiRenderHelper.textureRect((GuiGraphics)graphics, (int)9, (int)0, (int)icon.width(), (int)icon.height(), (float)icon.minX(), (float)icon.minY());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRenderHelper.textureRect((GuiGraphics)graphics, (int)8, (int)0, (int)icon.width(), (int)icon.height(), (float)icon.minX(), (float)icon.minY());
        pose.popPose();
        pose.pushPose();
        graphics.drawString(font, this.view.yAxis.axis.name(), 5, this.rect.getHeight() / 2 - axisHeight / 2, -1);
        icon = this.view.yAxis.positive ? Icon.ARROW_UP : Icon.ARROW_DOWN;
        pose.translate(0.0f, (float)(this.rect.getHeight() / 2 - axisHeight - 2), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.location());
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiRenderHelper.textureRect((GuiGraphics)graphics, (int)0, (int)-9, (int)icon.width(), (int)icon.height(), (float)icon.minX(), (float)icon.minY());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRenderHelper.textureRect((GuiGraphics)graphics, (int)0, (int)-8, (int)icon.width(), (int)icon.height(), (float)icon.minX(), (float)icon.minY());
        pose.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void closed() {
    }

    public void init() {
    }

    public void tick() {
    }

    public void flowX(int width, int preferred) {
    }

    public void flowY(int width, int height, int preferred) {
    }

    protected int preferredWidth(int availableWidth) {
        return 10;
    }

    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }

    public Axis axis() {
        return this.view.zAxis.axis;
    }

    public Facing getXFacing() {
        return this.view.xAxis;
    }

    public Facing getYFacing() {
        return this.view.yAxis;
    }

    public Facing getZFacing() {
        return this.view.zAxis;
    }

    static enum GuiIsoView {
        UP(90.0f, 90.0f, 0.0f, Facing.SOUTH, Facing.EAST, Facing.UP),
        DOWN(-90.0f, 90.0f, 0.0f, Facing.SOUTH, Facing.WEST, Facing.DOWN),
        EAST(0.0f, -90.0f, 0.0f, Facing.NORTH, Facing.UP, Facing.EAST),
        WEST(0.0f, 90.0f, 0.0f, Facing.SOUTH, Facing.UP, Facing.WEST),
        SOUTH(0.0f, 0.0f, 0.0f, Facing.EAST, Facing.UP, Facing.SOUTH),
        NORTH(0.0f, 180.0f, 0.0f, Facing.WEST, Facing.UP, Facing.NORTH);

        public final float rotX;
        public final float rotY;
        public final float rotZ;
        public final Facing xAxis;
        public final Facing yAxis;
        public final Facing zAxis;

        private GuiIsoView(float rotX, float rotY, float rotZ, Facing xAxis, Facing yAxis, Facing zAxis) {
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.zAxis = zAxis;
        }
    }

    public static class GuiAnimationAxisChangedEvent
    extends GuiControlChangedEvent {
        public GuiAnimationAxisChangedEvent(GuiIsoAnimationViewer viewer) {
            super((GuiControl)viewer);
        }
    }

    public static class GuiAnimationViewChangedEvent
    extends GuiControlChangedEvent {
        public GuiAnimationViewChangedEvent(GuiIsoAnimationViewer viewer) {
            super((GuiControl)viewer);
        }
    }
}

