/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.dialog;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.GuiSignalController;
import team.creative.littletiles.common.gui.signal.IConditionConfiguration;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalMode;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

public class GuiDialogSignal
extends GuiLayer {
    protected IConditionConfiguration event;
    public List<GuiSignalComponent> inputs;

    public GuiDialogSignal() {
        super("gui.dialog.signal", 320, 200);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(this::changed);
    }

    public void init(List<GuiSignalComponent> inputs, IConditionConfiguration event) {
        this.inputs = inputs;
        this.event = event;
        super.init();
    }

    public void changed(GuiControlChangedEvent event) {
        if (event.control.is("controller")) {
            GuiLabel label = (GuiLabel)this.get("result");
            GuiLabel delay = (GuiLabel)this.get("delay");
            try {
                SignalInputCondition condition = ((GuiSignalController)event.control).generatePattern();
                label.setTitle((Component)Component.translatable((String)"gui.signal.configuration.result").append(" " + condition.toString()));
                DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                df.setMaximumFractionDigits(5);
                delay.setTitle((Component)Component.literal((String)(df.format(condition.calculateDelay()) + " ticks")));
            }
            catch (GeneratePatternException e) {
                label.setTitle((Component)Component.translatable((String)"gui.signal.configuration.result").append(" ").append((Component)Component.translatable((String)e.getMessage())));
                delay.setTitle((Component)Component.literal((String)"0 ticks"));
            }
        }
    }

    public void create() {
        if (this.inputs == null) {
            return;
        }
        GuiLeftRightBox top = new GuiLeftRightBox();
        this.add((GuiControl)top.setVAlign(VAlign.CENTER));
        top.addLeft((GuiControl)new GuiLabel("result").setTranslate("gui.signal.configuration.result"));
        top.addRight((GuiControl)new GuiLabel("delay"));
        if (this.event.hasModeConfiguration()) {
            top.addRight((GuiControl)new GuiButton("mode", x -> ((GuiDialogSignalMode)LittleTilesGuiRegistry.MODE_DIALOG.open(this.getIntegratedParent(), new CompoundTag())).init(this, this.event)));
        }
        GuiSignalController controller = new GuiSignalController("controller", this.event.getOutput(), this.inputs);
        this.add(controller.setExpandable());
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        ArrayList<GuiSignalComponent> allInputs = new ArrayList<GuiSignalComponent>(this.inputs);
        allInputs.add(new GuiSignalComponent("[]", true, false, -1, 1, null, SignalMode.EQUAL));
        allInputs.add(new GuiSignalComponent("number", true, false, -1, 1, null, SignalMode.EQUAL));
        GuiComboBox inputs = new GuiComboBox("inputs", (IComponentMap)new TextMapBuilder().addComponent(allInputs, x -> Component.literal((String)x.info())));
        bottom.addLeft((GuiControl)inputs);
        bottom.addLeft((GuiControl)new GuiButton("add", x -> {
            GuiSignalComponent com = (GuiSignalComponent)inputs.selected();
            if (com.name().equals("[]")) {
                controller.addVirtualInput();
            } else if (com.name().equals("number")) {
                controller.addVirtualNumberInput();
            } else {
                controller.addInput(com);
            }
        }).setTranslate("gui.plus"));
        TextMapBuilder map = new TextMapBuilder();
        map.addComponent(x -> x.addOperator(SignalLogicOperator.AND), (Component)Component.literal((String)SignalLogicOperator.AND.display));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.OR), (Component)Component.literal((String)SignalLogicOperator.OR.display));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.XOR), (Component)Component.literal((String)SignalLogicOperator.XOR.display));
        map.addComponent(x -> x.addNotOperator(false), (Component)Component.literal((String)"not"));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.BITWISE_AND), (Component)Component.literal((String)SignalLogicOperator.BITWISE_AND.display));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.BITWISE_OR), (Component)Component.literal((String)SignalLogicOperator.BITWISE_OR.display));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.BITWISE_XOR), (Component)Component.literal((String)SignalLogicOperator.BITWISE_XOR.display));
        map.addComponent(x -> x.addNotOperator(true), (Component)Component.literal((String)"b-not"));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.ADD), (Component)Component.literal((String)SignalLogicOperator.ADD.display));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.SUB), (Component)Component.literal((String)SignalLogicOperator.SUB.display));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.MUL), (Component)Component.literal((String)SignalLogicOperator.MUL.display));
        map.addComponent(x -> x.addOperator(SignalLogicOperator.DIV), (Component)Component.literal((String)SignalLogicOperator.DIV.display));
        GuiComboBox operators = new GuiComboBox("operators", (IComponentMap)map);
        bottom.addLeft((GuiControl)operators);
        bottom.addLeft((GuiControl)new GuiButton("add", x -> ((Consumer)operators.selected()).accept(controller)).setTranslate("gui.plus"));
        if (this.event.getCondition() != null) {
            controller.setCondition(this.event.getCondition(), this);
        }
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            try {
                this.event.setCondition(controller.generatePattern());
                this.event.update();
                this.closeThisLayer();
            }
            catch (GeneratePatternException generatePatternException) {
                // empty catch block
            }
        }).setTranslate("gui.save"));
        this.changed(new GuiControlChangedEvent((GuiControl)controller));
        this.modeChanged();
    }

    public GuiSignalComponent getInput(SignalTarget target) throws ParseException {
        for (GuiSignalComponent component : this.inputs) {
            if (!component.name().equals(target.writeBase())) continue;
            return component;
        }
        throw new ParseException("input not found", 0);
    }

    public void modeChanged() {
        if (this.event.hasModeConfiguration()) {
            ((GuiButton)this.get("mode", GuiButton.class)).setTranslate(this.event.getModeConfiguration().getMode().translateKey);
            this.reflow();
        }
    }
}

