/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.control.parent.GuiPanel;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiTable;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.control.simple.GuiCounter;
import team.creative.creativecore.common.gui.control.simple.GuiCounterDecimal;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.control.simple.GuiTabButton;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.registry.NamedClassBoundHandlerRegistry;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.common.entity.particle.LittleParticlePresets;
import team.creative.littletiles.common.entity.particle.LittleParticleTexture;
import team.creative.littletiles.common.structure.type.premade.LittleParticleEmitter;

public class GuiParticle
extends GuiLayer {
    public static final NamedClassBoundHandlerRegistry<LittleParticleEmitter.ParticleSpread, ParticleSpreadGuiHandler> REGISTRY = new NamedClassBoundHandlerRegistry();
    public LittleParticleEmitter particle;
    public GuiComboBox<LittleParticlePresets> presetBox;
    public GuiComboBox<LittleParticleTexture> textureBox;
    public GuiCounterDecimal sizeStart;
    public GuiCounterDecimal sizeEnd;
    public GuiCounterDecimal sizeDiv;
    public GuiColorPicker color;
    public GuiCheckBox randomColor;
    public GuiSlider gravity;
    public GuiCheckBox collision;
    public GuiSteppedSlider age;
    public GuiCounter ageDiv;
    public GuiCounter count;
    public GuiCounter delay;
    public GuiTabButton<ParticleSpreadGuiHandler> spread;
    public GuiPanel spreadPanel;
    public GuiSyncLocal<CompoundTag> SAVE = this.getSyncHolder().register("save", x -> {
        this.particle.loadSettings((CompoundTag)x);
        this.particle.updateStructure();
        this.closeThisLayer();
    });

    public GuiParticle(LittleParticleEmitter particle) {
        super("particle", 200, 230);
        this.particle = particle;
        this.flow = GuiFlow.STACK_Y;
        this.setAlign(Align.STRETCH);
        this.registerEventChanged(x -> {
            if (x.control.is("spread")) {
                this.loadSpread(particle.spread);
            }
        });
    }

    public void create() {
        GuiParent presets = new GuiParent();
        this.add((GuiControl)presets);
        this.presetBox = new GuiComboBox("presets", (IComponentMap)new TextMapBuilder().addComponent(null, (Component)Component.literal((String)"")).addComponent((Object[])LittleParticlePresets.values(), x -> Component.translatable((String)("gui.particle.preset." + x.name().toLowerCase()))));
        presets.add((GuiControl)this.presetBox);
        this.presetBox.setExpandableX();
        presets.add((GuiControl)new GuiButton("save_preset", x -> {
            if (this.presetBox.selected() != null) {
                this.loadPreset((LittleParticlePresets)((Object)((Object)this.presetBox.selected())));
            }
        }).setTranslate("gui.particle.load"));
        this.textureBox = new GuiComboBox("texture", (IComponentMap)new TextMapBuilder().addComponent((Object[])LittleParticleTexture.values(), x -> x.title()));
        this.add((GuiControl)new GuiLabeledControl("gui.particle.texture", (GuiControl)this.textureBox));
        GuiParent size = new GuiParent();
        this.add((GuiControl)size.setVAlign(VAlign.CENTER));
        size.add((GuiControl)new GuiLabel("sizeLabel").setTranslate("gui.particle.size"));
        this.sizeStart = new GuiCounterDecimal("size", 0.4).setStep(0.05);
        size.add((GuiControl)this.sizeStart);
        size.add((GuiControl)new GuiLabel("sizeLabel").setTitle((Component)Component.literal((String)"->")));
        this.sizeEnd = new GuiCounterDecimal("sizeend", 0.6).setStep(0.05);
        size.add((GuiControl)this.sizeEnd);
        size.add((GuiControl)new GuiLabel("sizeDeviationLabel").setTranslate("gui.particle.sizedeviation"));
        this.sizeDiv = new GuiCounterDecimal("sizeDiv", 0.02).setStep(0.02);
        size.add((GuiControl)this.sizeDiv);
        this.color = new GuiColorPicker("color", new Color(255, 255, 255), true, 1);
        this.add((GuiControl)this.color);
        this.randomColor = new GuiCheckBox("randomColor", this.particle.settings.randomColor).setTranslate("gui.particle.randomcolor");
        this.add((GuiControl)this.randomColor);
        GuiParent physic = new GuiParent();
        this.add((GuiControl)physic.setVAlign(VAlign.CENTER));
        this.gravity = new GuiSlider("gravity", 0.0, -1.0, 1.0);
        physic.add((GuiControl)new GuiLabeledControl("gui.particle.gravity", (GuiControl)this.gravity));
        this.collision = new GuiCheckBox("collision", this.particle.settings.collision).setTranslate("gui.particle.collision");
        physic.add((GuiControl)this.collision);
        GuiParent ageParent = new GuiParent();
        this.add((GuiControl)ageParent.setVAlign(VAlign.CENTER));
        this.age = new GuiSteppedSlider("age", 20, 1, 100);
        ageParent.add((GuiControl)new GuiLabeledControl("gui.particle.age", (GuiControl)this.age));
        this.ageDiv = new GuiCounter("ageDiv", 20, 1, 100);
        ageParent.add((GuiControl)new GuiLabeledControl("gui.particle.agedeviation", (GuiControl)this.ageDiv));
        GuiParent amount = new GuiParent();
        this.add((GuiControl)amount.setVAlign(VAlign.CENTER));
        this.count = new GuiCounter("counter", this.particle.count);
        amount.add((GuiControl)new GuiLabeledControl("gui.particle.count", (GuiControl)this.count));
        this.delay = new GuiCounter("delay", this.particle.delay);
        amount.add((GuiControl)new GuiLabeledControl("gui.particle.per", (GuiControl)this.delay));
        amount.add((GuiControl)new GuiLabel("tickLabel").setTranslate("gui.particle.tick"));
        this.spread = new GuiTabButton("spread", (IComponentMap)new TextMapBuilder().addEntrySet(REGISTRY.entrySet(), x -> Component.translatable((String)("gui.particle.spread." + (String)x.getKey()))));
        this.add((GuiControl)this.spread);
        this.spreadPanel = new GuiPanel();
        this.add((GuiControl)this.spreadPanel);
        this.spread.select((Object)((ParticleSpreadGuiHandler)REGISTRY.get(this.particle.spread.getClass())));
        GuiParent bottom = new GuiParent().setAlign(Align.RIGHT);
        this.add((GuiControl)bottom);
        bottom.add((GuiControl)new GuiButton("save", x -> {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("tickCount", this.count.getValue());
            nbt.putInt("tickDelay", this.delay.getValue());
            LittleParticleEmitter.ParticleSpread spread = this.saveSpread();
            spread.write(nbt);
            LittleParticleEmitter.ParticleSettings newSettings = new LittleParticleEmitter.ParticleSettings();
            newSettings.randomColor = this.randomColor.value;
            newSettings.collision = this.collision.value;
            newSettings.texture = (LittleParticleTexture)((Object)((Object)this.textureBox.selected()));
            newSettings.lifetime = this.age.getIntValue();
            newSettings.lifetimeDeviation = this.ageDiv.getValue();
            newSettings.color = this.color.color.toInt();
            newSettings.gravity = (float)this.gravity.getValue();
            newSettings.startSize = (float)this.sizeStart.getValue();
            newSettings.endSize = (float)this.sizeEnd.getValue();
            newSettings.sizeDeviation = (float)this.sizeDiv.getValue();
            CompoundTag data = new CompoundTag();
            newSettings.write(data);
            nbt.put("settings", (Tag)data);
            this.SAVE.send((Tag)nbt);
            this.closeThisLayer();
        }).setTranslate("gui.save"));
        this.loadParticleSettings(this.particle.settings);
    }

    public void loadPreset(LittleParticlePresets preset) {
        this.loadParticleSettings(preset.settings);
        this.count.setValue(preset.count);
        this.delay.setValue(preset.delay);
        this.spread.select((Object)((ParticleSpreadGuiHandler)REGISTRY.get(this.particle.spread.getClass())));
        this.loadSpread(preset.spread);
    }

    public void loadSpread(LittleParticleEmitter.ParticleSpread particleSpread) {
        ParticleSpreadGuiHandler handler = (ParticleSpreadGuiHandler)this.spread.selected();
        this.spreadPanel.clear();
        handler.load((GuiParent)this.spreadPanel, particleSpread);
        this.reflow();
    }

    public LittleParticleEmitter.ParticleSpread saveSpread() {
        ParticleSpreadGuiHandler handler = (ParticleSpreadGuiHandler)this.spread.selected();
        if (handler != null) {
            return handler.save((GuiParent)this.spreadPanel);
        }
        return new LittleParticleEmitter.ParticleSpreadRandom();
    }

    public void loadParticleSettings(LittleParticleEmitter.ParticleSettings settings) {
        this.textureBox.select((Object)settings.texture);
        this.age.setValue((double)settings.lifetime);
        this.ageDiv.setValue(settings.lifetimeDeviation);
        this.color.setColor(new Color(settings.color));
        this.randomColor.set(settings.randomColor);
        this.gravity.setValue((double)settings.gravity);
        this.sizeStart.setValue((double)settings.startSize);
        this.sizeEnd.setValue((double)settings.endSize);
        this.sizeDiv.setValue((double)settings.sizeDeviation);
        this.collision.set(settings.collision);
    }

    static {
        REGISTRY.registerDefault("random", LittleParticleEmitter.ParticleSpreadRandom.class, (Object)new ParticleSpreadGuiHandler(){

            @Override
            public LittleParticleEmitter.ParticleSpread save(GuiParent parent) {
                LittleParticleEmitter.ParticleSpreadRandom spread = new LittleParticleEmitter.ParticleSpreadRandom();
                spread.speedX = (float)((GuiCounterDecimal)parent.get("speedx", GuiCounterDecimal.class)).getValue();
                spread.speedY = (float)((GuiCounterDecimal)parent.get("speedy", GuiCounterDecimal.class)).getValue();
                spread.speedZ = (float)((GuiCounterDecimal)parent.get("speedz", GuiCounterDecimal.class)).getValue();
                spread.spread = (float)((GuiCounterDecimal)parent.get("deviation", GuiCounterDecimal.class)).getValue();
                return spread;
            }

            @Override
            public void load(GuiParent parent, LittleParticleEmitter.ParticleSpread spread) {
                double d;
                double d2;
                LittleParticleEmitter.ParticleSpreadRandom r;
                GuiTable table = new GuiTable();
                parent.add((GuiControl)table);
                GuiRow row = new GuiRow();
                table.addRow(row);
                GuiColumn col = new GuiColumn();
                row.addColumn(col);
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.speedy", (GuiControl)new GuiCounterDecimal("speedy", (double)spread.speedY).setStep(0.05)));
                col = new GuiColumn();
                row.addColumn(col);
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.spread", (GuiControl)new GuiCounterDecimal("deviation", (double)spread.spread).setStep(0.05)));
                row = new GuiRow();
                table.addRow(row);
                col = new GuiColumn();
                row.addColumn(col);
                if (spread instanceof LittleParticleEmitter.ParticleSpreadRandom) {
                    r = (LittleParticleEmitter.ParticleSpreadRandom)spread;
                    d2 = r.speedX;
                } else {
                    d2 = 0.05;
                }
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.speedx", (GuiControl)new GuiCounterDecimal("speedx", d2).setStep(0.1)));
                col = new GuiColumn();
                row.addColumn(col);
                if (spread instanceof LittleParticleEmitter.ParticleSpreadRandom) {
                    r = (LittleParticleEmitter.ParticleSpreadRandom)spread;
                    d = r.speedZ;
                } else {
                    d = 0.05;
                }
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.speedz", (GuiControl)new GuiCounterDecimal("speedz", d).setStep(0.1)));
            }
        });
        REGISTRY.register("circular", LittleParticleEmitter.ParticleSpreadCircular.class, (Object)new ParticleSpreadGuiHandler(){

            @Override
            public LittleParticleEmitter.ParticleSpread save(GuiParent parent) {
                LittleParticleEmitter.ParticleSpreadCircular spread = new LittleParticleEmitter.ParticleSpreadCircular();
                spread.speedY = (float)((GuiCounterDecimal)parent.get("speedy", GuiCounterDecimal.class)).getValue();
                spread.spread = (float)((GuiCounterDecimal)parent.get("deviation", GuiCounterDecimal.class)).getValue();
                spread.radius = (float)((GuiCounterDecimal)parent.get("radius", GuiCounterDecimal.class)).getValue();
                spread.steps = ((GuiCounter)parent.get("steps", GuiCounter.class)).getValue();
                return spread;
            }

            @Override
            public void load(GuiParent parent, LittleParticleEmitter.ParticleSpread spread) {
                int n;
                double d;
                LittleParticleEmitter.ParticleSpreadCircular c;
                GuiTable table = new GuiTable();
                parent.add((GuiControl)table);
                GuiRow row = new GuiRow();
                table.addRow(row);
                GuiColumn col = new GuiColumn();
                row.addColumn(col);
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.speedy", (GuiControl)new GuiCounterDecimal("speedy", (double)spread.speedY).setStep(0.05)));
                col = new GuiColumn();
                row.addColumn(col);
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.spread", (GuiControl)new GuiCounterDecimal("deviation", (double)spread.spread).setStep(0.05)));
                row = new GuiRow();
                table.addRow(row);
                col = new GuiColumn();
                row.addColumn(col);
                if (spread instanceof LittleParticleEmitter.ParticleSpreadCircular) {
                    c = (LittleParticleEmitter.ParticleSpreadCircular)spread;
                    d = c.radius;
                } else {
                    d = 0.05;
                }
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.radius", (GuiControl)new GuiCounterDecimal("radius", d).setStep(0.1)));
                col = new GuiColumn();
                row.addColumn(col);
                if (spread instanceof LittleParticleEmitter.ParticleSpreadCircular) {
                    c = (LittleParticleEmitter.ParticleSpreadCircular)spread;
                    n = c.steps;
                } else {
                    n = 30;
                }
                col.add((GuiControl)new GuiLabeledControl("gui.particle.spread.steps", (GuiControl)new GuiCounter("steps", n)));
            }
        });
    }

    public static abstract class ParticleSpreadGuiHandler {
        public abstract void load(GuiParent var1, LittleParticleEmitter.ParticleSpread var2);

        public abstract LittleParticleEmitter.ParticleSpread save(GuiParent var1);
    }
}

