/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.client.LittleTilesClient;

public abstract class GuiConfigure
extends GuiLayer {
    public ContainerSlotView tool;
    public final GuiSyncLocal<CompoundTag> SAVE_CONFIG = this.getSyncHolder().register("save_config", nbt -> {
        DataResult result = DataComponentPatch.CODEC.parse((DynamicOps)NbtOps.INSTANCE, nbt);
        this.tool.get().applyComponents((DataComponentPatch)result.getOrThrow());
        this.tool.changed();
    });

    public GuiConfigure(String name, int width, int height, ContainerSlotView tool) {
        super(name, width, height);
        this.tool = tool;
    }

    public GuiConfigure(String name, ContainerSlotView tool) {
        super(name);
        this.tool = tool;
    }

    public abstract boolean saveConfiguration(PatchedDataComponentMap var1);

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (LittleTilesClient.KEY_CONFIGURE.matches(keyCode, scanCode)) {
            this.closeTopLayer();
            return true;
        }
        return false;
    }

    public void closed() {
        PatchedDataComponentMap map;
        if (this.isClient() && this.saveConfiguration(map = new PatchedDataComponentMap(DataComponentMap.EMPTY))) {
            DataResult dataresult = DataComponentPatch.CODEC.encode((Object)map.asPatch(), (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag());
            this.SAVE_CONFIG.send((Tag)((CompoundTag)dataresult.getOrThrow()));
        }
        super.closed();
    }
}

