/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe.test;

import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiPanel;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTest;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestError;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestResults;

public class GuiRecipeTest
extends GuiLayer {
    public RecipeTestResults results;
    public GuiRecipe recipe;

    public GuiRecipeTest() {
        super("gui.recipe.test", 300, 200);
        this.flow = GuiFlow.STACK_Y;
    }

    public void init(GuiRecipe recipe) {
        this.recipe = recipe;
        this.results = RecipeTest.STANDARD.test(recipe);
        this.clear();
        this.init();
    }

    public void becameTopLayer() {
        if (this.recipe != null) {
            this.init(this.recipe);
        }
    }

    public void create() {
        if (this.results == null) {
            return;
        }
        GuiScrollY box = new GuiScrollY();
        this.add((GuiControl)box.setExpandable());
        for (RecipeTestError error : this.results) {
            GuiPanel content = new GuiPanel((GuiFlow)GuiFlow.STACK_Y);
            box.add((GuiControl)content);
            content.add((GuiControl)new GuiLabel("header").setTitle(error.header()));
            content.add((GuiControl)new GuiLabel("desc").setTitle(error.description()));
            GuiParent bottomLine = new GuiParent((GuiFlow)GuiFlow.STACK_X).setAlign(Align.CENTER).setVAlign(VAlign.CENTER);
            content.add(bottomLine.setExpandableX());
            error.create(this.recipe, bottomLine, () -> this.init(this.recipe));
        }
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("refresh", x -> this.init(this.recipe)).setTranslate("gui.recipe.test.recheck"));
        bottom.addRight((GuiControl)new GuiButton("okay", x -> this.closeThisLayer()).setTranslate("gui.okay"));
    }
}

