/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.packet.action.BlockPacket;

public class ItemLittleWrench
extends Item {
    public ItemLittleWrench() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof BETiles) {
            if (context.getLevel().isClientSide) {
                LittleTileContext result = LittleTileContext.selectFocused((BlockGetter)context.getLevel(), context.getClickedPos(), context.getPlayer());
                if (context.getPlayer().isCrouching()) {
                    if (result.isComplete() && result.parent.isStructure()) {
                        LittleTilesGuiRegistry.STRUCTURE_OVERVIEW.open(context.getPlayer(), result);
                    } else {
                        LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(context.getLevel(), context.getClickedPos(), context.getPlayer(), BlockPacket.BlockPacketAction.WRENCH));
                    }
                } else {
                    LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(context.getLevel(), context.getClickedPos(), context.getPlayer(), BlockPacket.BlockPacketAction.WRENCH_INFO));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

