/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item.component;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.placement.selection.SelectionMode;

public class SelectionComponent {
    public static final Codec<SelectionComponent> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("mode").forGetter(e -> e.mode.getName()), (App)CompoundTag.CODEC.fieldOf("config").forGetter(e -> e.config)).apply((Applicative)x, SelectionComponent::new));
    public static final StreamCodec<FriendlyByteBuf, SelectionComponent> STREAM_CODEC = StreamCodec.of((buffer, s) -> {
        buffer.writeUtf(s.mode.getName());
        buffer.writeNbt((Tag)s.config);
    }, buffer -> new SelectionComponent(buffer.readUtf(), buffer.readNbt()));
    public final SelectionMode mode;
    private final CompoundTag config;

    public static SelectionComponent of(SelectionMode mode, CompoundTag config) {
        return new SelectionComponent(mode, config);
    }

    public static SelectionComponent getOrDefault(ItemStack stack) {
        SelectionComponent com = (SelectionComponent)stack.get(LittleTilesRegistry.SELECTION);
        if (com != null) {
            return com;
        }
        return new SelectionComponent((SelectionMode)SelectionMode.REGISTRY.getDefault(), new CompoundTag());
    }

    private SelectionComponent(String id, CompoundTag config) {
        this((SelectionMode)SelectionMode.REGISTRY.get(id), config);
    }

    private SelectionComponent(SelectionMode mode, CompoundTag config) {
        this.mode = mode;
        this.config = config;
    }

    public CompoundTag getConfig() {
        return this.config.copy();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SelectionComponent) {
            SelectionComponent s = (SelectionComponent)obj;
            return s.mode == this.mode && Objects.equal((Object)s.config, (Object)this.config);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.mode.hashCode() + this.config.hashCode();
    }

    public SelectionComponent withConfig(CompoundTag config) {
        return new SelectionComponent(this.mode, config);
    }

    public SelectionComponent withMode(SelectionMode mode) {
        return new SelectionComponent(mode, this.config);
    }
}

