/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxesVoxelShape;
import team.creative.creativecore.common.util.math.box.OBB;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.LittleEntityPhysic;
import team.creative.littletiles.common.level.handler.LevelHandler;
import team.creative.littletiles.common.math.vec.LittleHitResult;

public abstract class LittleAnimationHandler
extends LevelHandler {
    public Set<LittleEntity> entities = new CopyOnWriteArraySet<LittleEntity>();

    public LittleAnimationHandler(Level level) {
        super(level);
    }

    @Override
    public void unload() {
        super.unload();
        this.entities.clear();
    }

    protected void tickEntity(LittleEntity entity) {
        if (entity.level() != this.level || entity.level() instanceof IOrientatedLevel) {
            return;
        }
        entity.performTick();
    }

    public void tick() {
        for (LittleEntity entity : this.entities) {
            this.tickEntity(entity);
        }
    }

    public List<LittleEntity> find(AABB bb) {
        if (this.entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LittleEntity> found = new ArrayList<LittleEntity>();
        for (LittleEntity entity : this.entities) {
            if (!entity.hasLoaded() || !entity.getBoundingBox().intersects(bb)) continue;
            found.add(entity);
        }
        return found;
    }

    public LittleEntity find(UUID uuid) {
        for (LittleEntity entity : this.entities) {
            if (!entity.getUUID().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public void add(LittleEntity entity) {
        this.entities.add(entity);
    }

    public void remove(LittleEntity entity) {
        this.entities.remove(entity);
    }

    public Iterable<VoxelShape> collisionExcept(@Nullable Entity colliding, AABB box, Level level) {
        if (level instanceof ISubLevel) {
            return null;
        }
        ArrayList<BoxesVoxelShape> shapes = null;
        for (LittleEntity entity : this.find(box)) {
            if (!((LittleEntityPhysic)entity.physic).shouldPush()) continue;
            ArrayList<OBB> boxes = null;
            ABB transformedBox = entity.getOrigin().getOBB(box);
            for (VoxelShape shape : entity.getSubLevel().getBlockCollisions(colliding, transformedBox.toVanilla())) {
                for (AABB bb : shape.toAabbs()) {
                    if (!transformedBox.intersects(bb)) continue;
                    if (boxes == null) {
                        boxes = new ArrayList<OBB>();
                    }
                    boxes.add(new OBB(bb, entity.getOrigin()));
                }
            }
            if (boxes == null) continue;
            if (shapes == null) {
                shapes = new ArrayList<BoxesVoxelShape>();
            }
            shapes.add(BoxesVoxelShape.create(boxes));
        }
        return shapes;
    }

    public LittleHitResult getHit(Vec3 pos, Vec3 look, double reach) {
        AABB box = new AABB(pos, look);
        LittleHitResult newHit = null;
        double distance = reach;
        for (LittleEntity entity : this.find(box)) {
            LittleHitResult tempResult;
            if (!entity.hasLoaded() || (tempResult = entity.rayTrace(pos, look)) == null || !(tempResult.hit instanceof BlockHitResult)) continue;
            double tempDistance = pos.distanceTo(entity.getOrigin().transformPointToWorld(tempResult.hit.getLocation()));
            if (newHit != null && !(tempDistance < distance)) continue;
            newHit = tempResult;
            distance = tempDistance;
        }
        return newHit;
    }
}

