/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.structure;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingLevelHandler;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.packet.structure.StructurePacket;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;

public class StructureBlockToEntityPacket
extends StructurePacket {
    public UUID uuid;

    public StructureBlockToEntityPacket() {
    }

    public StructureBlockToEntityPacket(StructureLocation location, LittleAnimationEntity entity) {
        super(location);
        this.uuid = entity.getUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueStructure(Long2ObjectMap<SectionPos> chunks, RenderingLevelHandler target, Level targetLevel, RenderingLevelHandler origin, Level originLevel, LittleStructure structure, LittleAnimationEntity entity) throws LittleActionException {
        for (BETiles be : structure.blocks()) {
            BlockEntity block = entity.getSubLevel().getBlockEntity(be.getBlockPos());
            if (!(block instanceof BETiles)) continue;
            BETiles targetBE = (BETiles)block;
            long pos = SectionPos.asLong((BlockPos)be.getBlockPos());
            SectionPos section = (SectionPos)chunks.get(pos);
            if (section == null) {
                origin.getRenderChunk(be.getLevel(), pos).backToRAM();
                section = SectionPos.of((BlockPos)be.getBlockPos());
                chunks.put(pos, (Object)section);
            }
            Vec3 offset = RenderingLevelHandler.offsetCorrection(target, targetLevel, origin, originLevel, section);
            BERenderManager bERenderManager = targetBE.render;
            synchronized (bERenderManager) {
                if (!targetBE.render.isInQueueOrBeforeBuilding()) {
                    continue;
                }
                targetBE.render.additionalBuffers(x -> {
                    LayeredBufferCache layers = new LayeredBufferCache();
                    for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
                        BufferCache holder = be.render.buffers().extract(layer, structure.getIndex());
                        if (holder == null) continue;
                        if (offset != null) {
                            holder.applyOffset(offset);
                        }
                        layers.put(layer, holder);
                    }
                    if (!layers.isEmpty()) {
                        x.additional(this.uuid, layers);
                    }
                });
            }
        }
        for (StructureChildConnection child : structure.children.all()) {
            if (child.isLinkToAnotherWorld()) continue;
            try {
                this.queueStructure(chunks, target, targetLevel, origin, originLevel, child.getStructure(), entity);
            }
            catch (LittleActionException littleActionException) {}
        }
    }

    @Override
    public void execute(Player player, LittleStructure structure) {
        try {
            this.requiresClient(player);
            Long2ObjectOpenHashMap chunks = new Long2ObjectOpenHashMap();
            LittleAnimationEntity ani = (LittleAnimationEntity)LittleTilesClient.ANIMATION_HANDLER.find(this.uuid);
            this.queueStructure((Long2ObjectMap<SectionPos>)chunks, RenderingLevelHandler.of(ani.getSubLevel()), ani.getSubLevel(), RenderingLevelHandler.of(structure.getStructureLevel()), structure.getStructureLevel(), structure, ani);
        }
        catch (ClassCastException | LittleActionException e) {
            e.printStackTrace();
        }
    }
}

