/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.update;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.entity.LittleEntity;

public class BlockUpdate
extends CreativePacket {
    @CanBeNull
    public UUID uuid;
    public BlockState state;
    public BlockPos pos;
    @CanBeNull
    public CompoundTag tag;

    public BlockUpdate(LevelAccessor level, BlockPos pos, @Nullable BlockEntity be) {
        this.pos = pos;
        this.state = level.getBlockState(pos);
        if (be != null) {
            this.tag = be.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
        }
        if (level instanceof ISubLevel) {
            ISubLevel subLevel = (ISubLevel)level;
            this.uuid = subLevel.getHolder().getUUID();
        }
    }

    public BlockUpdate() {
    }

    public void executeClient(Player player) {
        Object level = player.level();
        if (this.uuid != null) {
            LittleEntity entity = LittleTiles.ANIMATION_HANDLERS.find(true, this.uuid);
            if (entity == null) {
                return;
            }
            level = entity.getSubLevel();
        }
        if (level instanceof ClientLevel) {
            ClientLevel c = (ClientLevel)level;
            c.setServerVerifiedBlockState(this.pos, this.state, 19);
        } else {
            level.setBlock(this.pos, this.state, 3);
        }
        if (this.tag != null) {
            level.getBlockEntity(this.pos).loadWithComponents(this.tag, (HolderLookup.Provider)level.registryAccess());
        }
    }

    public void executeServer(ServerPlayer player) {
    }
}

