/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import team.creative.littletiles.common.placement.PlacementPosition;

public class PlacementHelper {
    public static PlacementPosition getPosition(Level level, BlockHitResult moving, LittleGrid context, ILittleTool tile, ItemStack stack) {
        int x = moving.getBlockPos().getX();
        int y = moving.getBlockPos().getY();
        int z = moving.getBlockPos().getZ();
        Facing facing = moving.getType() != HitResult.Type.MISS ? Facing.get((Direction)moving.getDirection()) : null;
        boolean canBePlacedInsideBlock = true;
        if (facing != null && !PlacementHelper.canBePlacedInside(level, moving.getBlockPos(), moving.getLocation(), facing)) {
            switch (facing) {
                case EAST: {
                    ++x;
                    break;
                }
                case WEST: {
                    --x;
                    break;
                }
                case UP: {
                    ++y;
                    break;
                }
                case DOWN: {
                    --y;
                    break;
                }
                case SOUTH: {
                    ++z;
                    break;
                }
                case NORTH: {
                    --z;
                }
            }
            canBePlacedInsideBlock = false;
        }
        if (context == null) {
            return null;
        }
        return new PlacementPosition(new BlockPos(x, y, z), PlacementHelper.getHitVec(moving, context, canBePlacedInsideBlock).getVecGrid(), facing);
    }

    public static LittleVecAbsolute getHitVec(BlockHitResult result, LittleGrid grid, boolean isInsideOfBlock) {
        LittleVecAbsolute pos = new LittleVecAbsolute((HitResult)result, grid);
        Facing facing = Facing.get((Direction)result.getDirection());
        if (!isInsideOfBlock && result.getType() != HitResult.Type.MISS) {
            pos.getVec().set(facing.axis, facing.positive ? 0 : grid.count);
        }
        return pos;
    }

    public static LittleBox getTilesBox(PlacementPosition pos, LittleVec size, boolean centered, boolean placeInside) {
        LittleVec temp = pos.getVec().copy();
        if (centered && pos.facing != null) {
            Facing facing = pos.facing;
            if (placeInside) {
                facing = facing.opposite();
            }
            if (facing.positive) {
                temp.set(facing.axis, temp.get(facing.axis) + size.calculateCenter().get(facing.axis));
            } else {
                temp.set(facing.axis, temp.get(facing.axis) - size.calculateInvertedCenter().get(facing.axis));
            }
        }
        return new LittleBox(temp, size.x, size.y, size.z);
    }

    public static boolean canBlockBeUsed(Level world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        return be instanceof BETiles || ChiselsAndBitsManager.isChiselsAndBitsStructure(be);
    }

    public static boolean canBePlacedInside(Level level, BlockPos pos, Vec3 hitVec, Facing side) {
        if (PlacementHelper.canBlockBeUsed(level, pos)) {
            return !Maths.equals((double)((int)Maths.round((double)side.axis.get(hitVec))), (double)side.axis.get(hitVec), (double)1.0E-5);
        }
        return false;
    }
}

