/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.Objects;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.littletiles.client.tool.shaper.ShapeSelection;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.config.CornerShapeConfig;

public class LittleShapeOuterCorner
extends LittleShape<CornerShapeConfig> {
    public LittleShapeOuterCorner() {
        super(2);
    }

    @Override
    protected void build(LittleBoxes boxes, ShapeSelection selection, CornerShapeConfig config) {
        LittleTransformableBox box;
        LittleTransformableBox littleTransformableBox = box = new LittleTransformableBox(selection.getOverallBox(), new int[1]);
        Objects.requireNonNull(littleTransformableBox);
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        BoxCorner from = BoxCorner.EDS.transform((IntMatrix3c)config.matrix);
        BoxCorner to = BoxCorner.EUS.transform((IntMatrix3c)config.matrix);
        Facing facing = from.facingTo(to);
        BoxFace face = BoxFace.get((Facing)facing);
        boolean flipped = false;
        if (face.getCornerInQuestion(false, false) != to && face.getCornerInQuestion(true, false) != to) {
            flipped = true;
        }
        int value = box.get(facing.opposite());
        cache.setAbsolute(to, facing.axis, box.get(facing.opposite()));
        cache.setAbsolute(to, facing.axis, value);
        cache.setAbsolute(to.mirror(facing.one()), facing.axis, value);
        cache.setAbsolute(to.mirror(facing.two()), facing.axis, value);
        box.setData(cache.getData());
        if (config.secondMode) {
            flipped = !flipped;
        }
        box.setFlipped(facing, flipped);
        boxes.add(box);
    }
}

