/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation;

import java.text.ParseException;
import net.minecraft.nbt.CompoundTag;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;

public class AnimationSignalTrigger {
    public final SignalInputCondition condition;
    public final int transition;

    public AnimationSignalTrigger(CompoundTag nbt) {
        try {
            this.condition = SignalInputCondition.parseInput(nbt.getString("i"));
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid trigger condition found '" + nbt.getString("i") + "'");
        }
        this.transition = nbt.getInt("t");
    }

    public int signalChanged(LittleStructure structure) {
        if (this.condition.test(structure, false).any()) {
            return this.transition;
        }
        return -1;
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("i", this.condition.toString());
        nbt.putInt("t", this.transition);
        return nbt;
    }
}

