/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.AnimationSignalTrigger;
import team.creative.littletiles.common.structure.animation.AnimationState;

public class AnimationStateDirected
extends AnimationState {
    private int rightClickTransition = -1;
    private List<AnimationSignalTrigger> triggers;

    public AnimationStateDirected(CompoundTag nbt) {
        super(nbt);
        this.rightClickTransition = nbt.contains("right") ? nbt.getInt("right") : -1;
        ListTag list = nbt.getList("trigger", 10);
        this.triggers = new ArrayList<AnimationSignalTrigger>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.triggers.add(new AnimationSignalTrigger(list.getCompound(i)));
        }
    }

    public AnimationStateDirected(String name) {
        super(name);
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = super.save();
        if (this.hasRightClickTransition()) {
            nbt.putInt("right", this.rightClickTransition);
        }
        ListTag list = new ListTag();
        for (int i = 0; i < this.triggers.size(); ++i) {
            list.add((Object)this.triggers.get(i).save());
        }
        nbt.put("trigger", (Tag)list);
        return nbt;
    }

    public boolean hasRightClickTransition() {
        return this.rightClickTransition != -1;
    }

    public int signalChanged(LittleStructure structure) {
        for (AnimationSignalTrigger trigger : this.triggers) {
            int transition = trigger.signalChanged(structure);
            if (transition < 0) continue;
            return transition;
        }
        return -1;
    }
}

